/*:
 * @target MZ
 * @plugindesc 変数に上限・下限を設定できるプラグイン（プラグインパラメーター対応・Ver.1.1）★VariableLimiterEx.js
 * @author ChatGPT
 * 
 * @help
 * ◆概要：
 * 変数ごとに最大値・最小値を設定し、それを自動的に制限するプラグインです。
 * 
 * ◆使い方：
 * プラグインパラメータで、制限したい変数IDとその上限・下限を設定します。
 * ゲーム中にその変数が変更された場合、自動で制限されます。
 * 
 * ◆注意：
 * - 上限・下限はどちらか一方だけの設定でも構いません。
 * - 複数の変数に設定できます。
 * 
 * ◆更新履歴：
 * 2025/07/09 Ver.1.1 プラグインパラメーター対応版リリース
 *
 * @param Limits
 * @text 変数制限リスト
 * @type struct<Limit>[]
 * @desc 各変数に設定する最大・最小値のリストです
 */

/*~struct~Limit:
 * @param VariableID
 * @text 変数ID
 * @type variable
 * @desc 対象となる変数ID

 * @param MaxValue
 * @text 最大値
 * @type number
 * @min -9999999
 * @max 9999999
 * @desc この変数の最大値（未設定で制限なし）

 * @param MinValue
 * @text 最小値
 * @type number
 * @min -9999999
 * @max 9999999
 * @desc この変数の最小値（未設定で制限なし）
 */

(() => {
    const pluginName = "VariableLimiterEx";
    const parameters = PluginManager.parameters(pluginName);
    const limitListRaw = JSON.parse(parameters["Limits"] || "[]");

    /** 変数IDごとの制限を格納するオブジェクト */
    const variableLimits = {};

    for (const entryRaw of limitListRaw) {
        const entry = JSON.parse(entryRaw);
        const varId = Number(entry.VariableID);
        if (!varId) continue;

        const max = entry.MaxValue !== "" ? Number(entry.MaxValue) : undefined;
        const min = entry.MinValue !== "" ? Number(entry.MinValue) : undefined;

        variableLimits[varId] = {
            max: max,
            min: min
        };
    }

    const _Game_Variables_setValue = Game_Variables.prototype.setValue;
    Game_Variables.prototype.setValue = function(variableId, value) {
        const limit = variableLimits[variableId];
        if (limit) {
            if (limit.max !== undefined) {
                value = Math.min(value, limit.max);
            }
            if (limit.min !== undefined) {
                value = Math.max(value, limit.min);
            }
        }
        _Game_Variables_setValue.call(this, variableId, value);
    };
})();
