# フローチャート作成ツール（サンプル版）

## 概要
Webブラウザ上で動作するフローチャート作成ツールのサンプル版です。製品版の機能を体験できます。

## 主な機能

### 基本機能
- **フローチャート作成**: ドラッグ&ドロップでフローチャートを作成
- **シナリオ作成**: 1つのシナリオを作成可能
- **シーン追加**: 最大20シーンまで作成可能
- **自動レイアウト**: 美しいフローチャートを自動配置

### 編集機能
- **リアルタイム編集**: その場でテキスト編集
- **要素の追加・削除**: シーン、矢印の自由な追加・削除
- **分岐フロー**: 条件分岐を含む複雑なフローに対応
- **自動整列**: 要素の自動整列機能

### データ管理
- **保存・読み込み**: JSONファイルでの保存・読み込み
- **エクスポート**: 作成したフローチャートの出力
- **自動保存**: 作業内容の自動保存機能

### 表示機能
- **ズーム機能**: 拡大・縮小表示
- **全画面表示**: フルスクリーンでの編集
- **レスポンシブ対応**: 様々な画面サイズに対応

## サンプル版の制限事項
- **シナリオ数**: 1つまで
- **シーン数**: 最大20シーンまで
- **商用利用**: 不可（評価目的のみ）

## 動作環境
- **対応ブラウザ**: Chrome, Firefox, Safari, Edge（最新版推奨）
- **OS**: Windows, macOS, Linux
- **インターネット接続**: 不要（オフライン動作）

## 使用方法
1. `start.bat`をダブルクリックして起動
2. または `scenario-tree-sample.html` をブラウザで開く
3. 画面の指示に従ってフローチャートを作成

## 操作方法

### 基本操作
- **シーン追加**: 「シーン追加」ボタンをクリック（20シーンまで）
- **矢印追加**: 「矢印追加」ボタンをクリックして接続
- **テキスト編集**: 要素をクリックしてその場で編集
- **要素移動**: ドラッグ&ドロップで要素を移動

### ファイル操作
- **保存**: 「保存」ボタンでJSONファイルに保存
- **読み込み**: 「ファイル選択」で既存ファイルを読み込み

## 製品版との違い

| 機能 | サンプル版 | 製品版 |
|-----|---------|--------|
| シナリオ数 | 1個まで | 無制限 |
| シーン数 | 20個まで | 無制限 |
| 商用利用 | ✗ | ✓ |
| 技術サポート | ✗ | ✓ |
| アップデート | ✗ | ✓ |

## 製品版のご案内
より多くのシナリオやシーンを作成したい場合は、製品版をご検討ください。

### 製品版の特徴
- **無制限作成**: シナリオ数・シーン数に制限なし
- **全機能利用可能**: 全ての機能をフル活用
- **商用利用対応**: ビジネス用途での利用が可能
- **継続サポート**: 技術サポートとアップデート提供

## 評価用ライセンス
本サンプル版は評価・試用目的でのみ利用可能です。
- 個人・法人問わず評価利用可能
- 商用利用は禁止
- 再配布は禁止

## お問い合わせ
製品版に関するお問い合わせや購入については、別途提供される連絡先までお問い合わせください。

## 注意事項
- サンプル版の機能制限は技術的に実装されており、改変は不可です
- 本ソフトウェアの改変・再配布は禁止されています
- 評価目的を超えた利用は適切なライセンスをご購入ください

---
© 2025 ぱぱっと！シナリオツリー サンプル版 All rights reserved.