(() => {
  'use strict';

  function Window_ArrowCursorMixIn(windowClass) {
    const _updateCursor = windowClass._updateCursor;
    windowClass._updateCursor = function () {
      _updateCursor.call(this);
      this._windowCursorSprite.visible = this.isOpen() && this._cursorRect.width > 0 && this._cursorRect.height > 0;
    };
  
    windowClass._refreshCursor = function () {
      const x = this._cursorRect.x + this._padding - this.origin.x;
      const y = this._cursorRect.y + this._padding - this.origin.y + this._cursorRect.height/2;

      /**
       * system/Window.png の右上から、右矢印を切り抜いて使う
       */
      const p = 24;
      const q = p/2;
      const sx = 96+p;
      const sy = 0+p;
  
      this._windowCursorSprite.bitmap = this._windowskin;
      this._windowCursorSprite.anchor.x = 0.5;
      this._windowCursorSprite.anchor.y = 0.5;
      this._windowCursorSprite.setFrame(sx+q+p, sy+q, q, p);
      this._windowCursorSprite.move(x, y);
    };
  }

  Window_ArrowCursorMixIn(Window.prototype);
})();
