//=============================================================================
// T753_AddInputKey.js
// ----------------------------------------------------------------------------
// (C)2022 T753
// ----------------------------------------------------------------------------
// Version
// 1.01 2022/10/14 更新
// 　キーにバックスペースを追加。
// 1.00 2022/1/19 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc 入力可能キー追加プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_TitleSkip.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値は変更不要です。
 * イベントの設定（プラグインコマンド）は不要です。
 * 
 * ※条件分岐で以下のスクリプトを記述してください（半角大文字）。
 * 
 * ・押された瞬間
 * Input.isTriggered('■')
 * ・押されている間
 * Input.isPressed('■')
 * 
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2022/1/19 T753
 * 
 */
//=============================================================================
// 機能部分：
// 　キー入力判定を拡張し、イベントコマンドにある物以外のキーでも
// 押した判定を取得できます。
// （Ａ～Ｚ、BackSpaceを追加）
//=============================================================================
(function() {
    'use strict';

      Input.keyMapper[65] = "A";
      Input.keyMapper[66] = "B";
      Input.keyMapper[67] = "C";
      Input.keyMapper[68] = "D";
      Input.keyMapper[69] = "E";
      Input.keyMapper[70] = "F";
      Input.keyMapper[71] = "G";
      Input.keyMapper[72] = "H";
      Input.keyMapper[73] = "I";
      Input.keyMapper[74] = "J";
      Input.keyMapper[75] = "K";
      Input.keyMapper[76] = "L";
      Input.keyMapper[77] = "M";
      Input.keyMapper[78] = "N";
      Input.keyMapper[79] = "O";
      Input.keyMapper[80] = "P";
      Input.keyMapper[81] = "Q";
      Input.keyMapper[82] = "R";
      Input.keyMapper[83] = "S";
      Input.keyMapper[84] = "T";
      Input.keyMapper[85] = "U";
      Input.keyMapper[86] = "V";
      Input.keyMapper[87] = "W";
      Input.keyMapper[88] = "X";
      Input.keyMapper[89] = "Y";
      Input.keyMapper[90] = "Z";
      Input.keyMapper[8] = "BS";
  })();

