//=============================================================================
// T753_ChangeMessageWindow3line.js
// ----------------------------------------------------------------------------
// (C)2023 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2023/ 5/11 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc メッセージ３行化プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_ChangeMessageWindow3line.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値は変更不要です。
 * イベントの設定（プラグインコマンド）は不要です。
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2023/ 5/11 T753
 * 
 * 
 */
//=============================================================================
// 機能部分：
// 　メッセージウィンドウの位置等を調整します。
//=============================================================================
(function() {
    'use strict';

    Scene_Message.prototype.messageWindowRect = function() {
      //メッセージウィンドウを３行にして幅調整(250)、位置調整（10）。
      const ww = Graphics.boxWidth - 250;
      const wh = this.calcWindowHeight(3, false) + 8;
      const wx = (Graphics.boxWidth - ww) / 2 -10 ;
      const wy = 0;
      return new Rectangle(wx, wy, ww, wh);
    };

      Window_Message.prototype.updatePlacement = function() {
        const goldWindow = this._goldWindow;
        this._positionType = $gameMessage.positionType();
    //メッセージウィンドウを上に移動。
    this.y = (this._positionType * (Graphics.boxHeight - this.height)) / 2 - 10;
    if (goldWindow) {
        goldWindow.y = this.y > 0 ? 0 : Graphics.boxHeight - goldWindow.height;
    }
    };

})();

