//=============================================================================
// T753_ChangeOptions.js
// ----------------------------------------------------------------------------
// (C)2020 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2020/12/5 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc オプション内容変更プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_ChangeOptions.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値を変更してください。
 * イベントの設定（プラグインコマンド）は不要です。
 * ※パラメータをすべて『false』にするとエラーになりますので、
 * 　ご注意ください。
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2020/12/5 T753
 * 
 * 
 * @param Window Width
 * @desc オプションウィンドウの幅を変更します。
 * デフォルト：400
 * @type number
 * @default 400
 * 
 * 
 * @param Number of Lines
 * @desc オプションウィンドウの行数を変更します。
 * デフォルト：7行　（項目数と合わせます）
 * @type number
 * @default 7
 *
 * 
 * @param Always Dash
 * @text 常時ダッシュ
 * @desc オプションに『常時ダッシュ』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 *
 * 
 * @param Command Remember
 * @desc オプションに『コマンド記憶』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 *
 *
 * @param Touch UI
 * @desc オプションに『タッチUI』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 * 
 * 
 * @param Bgm Volume
 * @desc オプションに『BGM 音量』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 *
 *
 * @param Bgs Volume
 * @desc オプションに『BGS 音量』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 *
 *
 * @param Me Volume
 * @desc オプションに『ME 音量』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 *
 *
 * @param Se Volume
 * @desc オプションに『SE 音量』を表示します。
 * 表記はデータベースの『用語』→『メッセージ』から変更。
 * @type boolean
 * @default true
 * 
 */
//=============================================================================
// 機能部分：
// 　オプション内容を変更します。
//=============================================================================
(function() {
    'use strict';

　//パラメータを定義します。
    const parameters = PluginManager.parameters('T753_ChangeOptions');
　//プラグイン名に注意。。
    const alwaysDash = Boolean(parameters['Always Dash'] === 'true');
    const commandRemember = Boolean(parameters['Command Remember'] === 'true');
    const touchUI = Boolean(parameters['Touch UI'] === 'true');
    const bgmVolume = Boolean(parameters['Bgm Volume'] === 'true');
    const bgsVolume = Boolean(parameters['Bgs Volume'] === 'true');
    const meVolume = Boolean(parameters['Me Volume'] === 'true');
    const seVolume = Boolean(parameters['Se Volume'] === 'true');
    const windowWidth = Number(parameters['Window Width'] || 400);
    const numberLine = Number(parameters['Number of Lines'] || 7);

　//パラメータに応じて表示/非表示を変更します。
  //・一般オプション。
    Window_Options.prototype.addGeneralOptions = function() {
      if(alwaysDash) {
        this.addCommand(TextManager.alwaysDash, 'alwaysDash');
      }
      if(commandRemember) {
        this.addCommand(TextManager.commandRemember, 'commandRemember');
      }
      if(touchUI) {
        this.addCommand(TextManager.touchUI, "touchUI");
      }
    };
  //・音量オプション。
    Window_Options.prototype.addVolumeOptions = function() {
      if(bgmVolume) {
        this.addCommand(TextManager.bgmVolume, "bgmVolume");
      }
      if(bgsVolume) {
        this.addCommand(TextManager.bgsVolume, "bgsVolume");
      }
      if(meVolume) {
        this.addCommand(TextManager.meVolume, "meVolume");
      }
      if(seVolume) {
        this.addCommand(TextManager.seVolume, "seVolume");
      }
    };
  //・オプションウィンドウの幅、行数を変更します。
    Scene_Options.prototype.optionsWindowRect = function() {
      const n = Math.min(this.maxCommands(), this.maxVisibleCommands());
      const ww = windowWidth;
      const wh = this.calcWindowHeight(n, true);
      const wx = (Graphics.boxWidth - ww) / 2;
      const wy = (Graphics.boxHeight - wh) / 2;
      return new Rectangle(wx, wy, ww, wh);
    };
  
    Scene_Options.prototype.maxCommands = function() {
      return numberLine;
    };

})();

