//=============================================================================
// T753_ChangeSaveScreenLayout_NoChara.js
// ----------------------------------------------------------------------------
// (C)2020 T753
// ----------------------------------------------------------------------------
// Version
// 1.01 2023/4/4 歩行グラフィックを削除。
// 1.00 2021/12/3 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc セーブ画面レイアウト変更プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_ChangeSaveScreenLayout_NoChara.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値を変更してください。
 * イベントの設定（プラグインコマンド）は不要です。
 * 
 * ■利用例
 * 変数には文字列を格納できますので、数値と併用するといいかもしれません。
 * （文字列は『変数の操作』→『オペランド』→『スクリプト』欄に
 * 　"（ダブルクォーテーション）で囲んで入力できます）
 * 
 * 例1）
 * 変数1=『"スコア："』
 * 変数2=『スコア用変数』
 * 変数3=『"点"』
 * →セーブ画面=【スコア：（スコア用変数）点】
 * 
 * 例2）
 * 変数1=『"    （スペース）"』
 * 変数2=『"残りライフ  （スペース）"』
 * 変数3=『ライフ用変数』
 * →セーブ画面=【    残りライフ  （ライフ用変数）】
 * 
 * 例3）
 * 変数1=『"現在のセーブ回数は"』
 * 変数2=『"セーブ回数用変数"』
 * 変数3=『回』
 * →セーブ画面=【現在のセーブ回数は（セーブ回数用変数）回】
 * 
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2021/12/3 T753
 * 
 * @param Word 1st
 * @desc レイアウト1:表示したい値を格納した変数を選択してください。
 * デフォルト：変数1
 * @type variable
 * @default 1
 * 
 * @param Word 2nd
 * @desc レイアウト2
 * デフォルト：変数2
 * @type variable
 * @default 2
 * 
 * @param Word 3rd
 * @desc レイアウト3
 * デフォルト：変数3
 * @type variable
 * @default 3
 * 
 * 
 */
//=============================================================================
// 機能部分：
// 　セーブ画面レイアウトを変更します。
// 　任意の変数の組合せでゲーム中の情報を表現できます。
// 　変数に文字列を入力すれば１行の文章も書けます。
//=============================================================================
(function() {
    'use strict';

　//パラメータを定義します。
const parameters = PluginManager.parameters('T753_ChangeSaveScreenLayout_NoChara');
　//プラグイン名に注意。。
    const word1 = Number(parameters['Word 1st'] || 1);
    const word2 = Number(parameters['Word 2nd'] || 2);
    const word3 = Number(parameters['Word 3rd'] || 3);

    DataManager.makeSavefileInfo = function() {
      const info = {};
      info.title = $dataSystem.gameTitle;
//      info.characters = $gameParty.charactersForSavefile();
      info.faces = $gameParty.facesForSavefile();
      info.playtime = $gameSystem.playtimeText();
      info.timestamp = Date.now();
      //セーブ画面用変数。
      info.saveVariables = $gameVariables.value(word1) + $gameVariables.value(word2) + $gameVariables.value(word3);
      return info;
    };

    Window_SavefileList.prototype.drawPlaytime = function(info, x, y, width) {
      if (info.playtime) {
//          this.drawText(info.playtime, x, y, width, "right");
          this.drawText(info.saveVariables, x, y, width, "left");
      }
  };


})();


