//=============================================================================
// T753_ChangeVolumeOffset.js
// ----------------------------------------------------------------------------
// (C)2025 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2025/ 5/17 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc 音量つまみ調節プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_ChangeVolumeOffset.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値を変更してください。
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2025/ 5/17 T753
 * 
 * @param Volume Offset
 * @desc 音量の調整単位を変更します。
 * デフォルト：20
 * @type number
 * @default 20
 * 
 */
//=============================================================================
// 機能部分：
// 　音量の調整単位を変更します。
//=============================================================================
(function() {
    'use strict';

　//パラメータを定義します。
    const parameters = PluginManager.parameters("T753_ChangeVolumeOffset");
　//プラグイン名に注意。。
    const volumeoffset = Number(parameters["Volume Offset"] || 20);

Window_Options.prototype.volumeOffset = function() {
    return volumeoffset;
};

})();

