//=============================================================================
// T753_ClearTileNotTouch.js
// ----------------------------------------------------------------------------
// (C)2024 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2024/1/25 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc 透明タイルお触り禁止プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_ClearTileNotTouch.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値は変更不要です。
 * イベントの設定（プラグインコマンド）は不要です。
 * 
 * 
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2024/1/25 T753作成
 * ■Special Thanks
 * 　荒上 理紗斗 様 監修
 * 
 */
//=============================================================================
// 機能部分：
// 透明タイルをクリックしてもマップ移動しません。
//=============================================================================
Scene_Map.prototype.onMapTouch = function() {
  const x = $gameMap.canvasToMapX(TouchInput.x);
  const y = $gameMap.canvasToMapY(TouchInput.y);
  if ($gameMap.tileId(x, y, 0) !== 1544) {  // if を追加。分岐の概要 => 「もしクリック先のタイルIDが透明タイルでないなら」
    $gameTemp.setDestination(x, y);  // この行は本来は常に実行されますが、if 追記により透明タイルクリック時のみ動作が拒否されます。
  }
};