//=============================================================================
// T753_FailedToInitializeGraphics.js
// ----------------------------------------------------------------------------
// (C)2020 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2020/12/30 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc FTIG_エラー表示変更プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_FailedToInitializeGraphics.js
 * このプラグインには、プラグインコマンドはありません。
 * 
 * 『Chromeの設定からハードウェアアクセラレーションをONにすれば、
 * 解決する可能性があります（Failed to initialize graphics.）。』
 * とエラー表示を変更します。
 * 
 * ※通常：
 * 『Failed to initialize graphics.』のみ
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * イベントの設定（プラグインコマンド）は不要です。
 * 
 * ※エラー表示の内容を変更したい場合は、プラグインのファイルを
 * 　直接書き替えてください。
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2020/12/30 T753
 * 
 * 
 */
//=============================================================================
// 機能部分：
// 　エラー表示を変更します。
//=============================================================================
(function() {
    'use strict';

　//エラー表示を変更します。
SceneManager.initGraphics = function() {
    if (!Graphics.initialize()) {
        throw new Error('Chromeの設定からハードウェアアクセラレーションをONにすれば、解決する可能性があります（Failed to initialize graphics.）。');
    }
    Graphics.setTickHandler(this.update.bind(this));
  };


})();

