//=============================================================================
// T753_MaxSaveFiles.js
// ----------------------------------------------------------------------------
// (C)2024 T753
// ----------------------------------------------------------------------------
// Version
// 1.01 2024/ 6/10 ver.1.01
//   セーブ数が正しくなるように調整。
// 1.00 2024/ 4/27 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc セーブファイル数変更プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_MaxSaveFiles.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値を変更してください。
 * イベントの設定（プラグインコマンド）は不要です。
 * 
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2024/ 4/27
 * 
 * @param MaxSaveFiles
 * @desc セーブファイル数の最大値を変更します。
 * デフォルト：20
 * @type number
 * @default 20
 * 
 * 
 */
//=============================================================================
// 機能部分：
// 　セーブファイル数の最大値を変更します。
//=============================================================================
(function() {
    'use strict';

　//パラメータを定義します。
const parameters = PluginManager.parameters("T753_MaxSaveFiles");
　//プラグイン名に注意。。
    const maxsavefiles = Number(parameters["MaxSaveFiles"] || 20);

    DataManager.maxSavefiles = function() {
        return maxsavefiles + 1;
    }
    

  })();

