//=============================================================================
// T753_NotDrawItemNumber.js
// ----------------------------------------------------------------------------
// (C)2025 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2025/3/14 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc アイテム所持数非表示プラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_NotDrawItemNumber.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 *  イベントの設定（プラグインコマンド）は不要です。
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2025/3/14 T753
 * 
 * 
 * 
 */
//=============================================================================
// 機能部分：
// 　アイテムタイプ『通常アイテム』の、アイテム所持数を非表示に変更します。
//=============================================================================
(function() {
    'use strict';

　//以下の通り変更します。
Window_ItemList.prototype.drawItem = function(index) {
  const item = this.itemAt(index);
  if (item) {
      const numberWidth = this.numberWidth();
      const rect = this.itemLineRect(index);
      this.changePaintOpacity(this.isEnabled(item));
      this.drawItemName(item, rect.x, rect.y, rect.width - numberWidth);
  //    this.drawItemNumber(item, rect.x, rect.y, rect.width);
      this.changePaintOpacity(1);
  }
};
})();

