//=============================================================================
// T753_TitleSkip.js
// ----------------------------------------------------------------------------
// (C)2020 T753
// ----------------------------------------------------------------------------
// Version
// 1.00 2020/12/5 初版。

//=============================================================================
// プラグインの説明です。
//=============================================================================
/*:
 * @plugindesc タイトルスキッププラグイン
 * @target MZ
 * @url https://drive.google.com/drive/folders/1ko5ULmg6vISku_JzMF5dUeQmgYpou7Dh
 * @author T753
 * 
 * @help T753_TitleSkip.js
 * このプラグインには、プラグインコマンドはありません。
 *
 * ■利用方法
 * 『プラグイン管理』で基本設定の状態を『ON』にすれば利用可能です。
 * パラメータの値は変更不要です。
 * イベントの設定（プラグインコマンド）は不要です。
 *
 * ■利用規約
 * このプラグインの改変、再配布は自由です。
 * クレジットの表記も不要です。
 *
 * ■MEMO
 * 2020/12/5 T753
 * 
 */
//=============================================================================
// 機能部分：
// 　ゲームスタート時にタイトルでなく
// 　初期マップへ移動します。
//=============================================================================
(function() {
    'use strict';

    Scene_Boot.prototype.startNormalGame = function() {
      this.checkPlayerLocation();
      DataManager.setupNewGame();
      SceneManager.goto(Scene_Map);
      Window_TitleCommand.initCommandPosition();
  };

})();

