// おもちゃ
//
/*:
 * @plugindesc プラグインの説明。
 * @author プラグインの作者。
 * @param id
 * @desc パラメータの説明。
 * @default 0
 * @help プラグインの詳細な説明。

 */

// *****バトル部分の変更が煩雑でややこしいので別に分ける*****

// $gameSwitches.setValue(スイッチID,true or false) $gameSwitches.value(スイッチID)
// $gameVariables.setValue(変数ID,変数の値) var a = $gameVariables.value(1)
// $gameSelfSwitches.setValue(key, true or false) var key = [マップID, イベントID, セルフスイッチ] $gameSelfSwitches.value(key)
// for (let i = 0; i < 5; i++) {console.log((i + 1) + '回目の処理です')}
//var tokenenP0 = function(x,y) {
//}; 
// セミコロン要
(function() {
	var Nm = 'B_modif'
	// 全モンスター技を覚える仕様だと、モン娘への愛着面でマイナスっぽいで戦闘中使えるスキルを限定したバトルシステムにする
	
	// 後で消す。タイトル場面でバグがあるのがすぐわかるように、ウインドウの幅を変えている。
Window_TitleCommand.prototype.windowWidth = function() {
    return 250;
};


	
//window.alert(55)

	
	
	
	
	
	
	
	
	
	

	
BattleManager.makeRewards = function() {
	var nani = $gameVariables.value(62)
    this._rewards = {};
    this._rewards.gold = $gameTroop.goldTotal();
	if ($gameTroop._troopId != 141 && $gameTroop._troopId >= 139 && $gameTroop._troopId <= 146) {
        this._rewards.exp = 0 // 経験値がゼロになる敵グループ
	}else{
		// 難易度による経験値の変更。本当はマネージャーは直接書き換えているが、ややこしくなるのでこれは別にしてる
    	this._rewards.exp = Math.floor((1 + nani * 0.25) * $gameTroop.expTotal());
	}
    this._rewards.items = $gameTroop.makeDropItems();
};
	
	
	// ヘルプウインドウをアクターコマンドで定義する関係上、並びを変える
Scene_Battle.prototype.createAllWindows = function() {
    this.createLogWindow();
    this.createStatusWindow();
    this.createPartyCommandWindow();
	this.createHelpWindow();
    this.createActorCommandWindow();
    
    this.createSkillWindow();
    this.createItemWindow();
    this.createActorWindow();
    this.createEnemyWindow();
    this.createMessageWindow();
    this.createScrollTextWindow();
};
Scene_Battle.prototype.createActorWindow = function() {
    this._actorWindow = new Window_BattleActor(this._statusWindow.x, this._statusWindow.y);
    this._actorWindow.setHandler('ok',     this.onActorOk.bind(this));
    this._actorWindow.setHandler('cancel', this.onActorCancel.bind(this));
	this._actorWindow.backOpacity = 255
	//this._actorWindow._windowBackSprite.setColorTone([60,110,170,0 ])
    this.addWindow(this._actorWindow);
};
Scene_Battle.prototype.createHelpWindow = function() {
    this._helpWindow = new Window_Help();
    this._helpWindow.visible = false;
    this.addWindow(this._helpWindow);
	this._helpWindow2 = new Window_Help();
    this._helpWindow2.visible = false;
    this.addWindow(this._helpWindow2);
};
Scene_Battle.prototype.onActorCancel = function() {
    this._actorWindow.hide();
    switch (this._actorCommandWindow.currentSymbol()) {
    case 'skill':
        //this._skillWindow.show();
        //this._skillWindow.activate();
    	this._actorCommandWindow.activate();
        break;
    case 'item':
        this._itemWindow.show();
        this._itemWindow.activate();
        break;
    }
};	
Scene_Battle.prototype.initialize = function() {
    Scene_Base.prototype.initialize.call(this);
	ImageManager.loadSystem('Window4')
};
	

Scene_Battle.prototype.updateBattleProcess = function() {
	
	BattleManager.selectNextCommand
    if (!this.isAnyInputWindowActive() || BattleManager.isAborting() ||
            BattleManager.isBattleEnd()) {
            
        BattleManager.update();
        
        this.changeInputWindow();
    }
};
Scene_Battle.prototype.changeInputWindow = function() {
    if (BattleManager.isInputting()) {
        if (BattleManager.actor()) {
            this.startActorCommandSelection();
        } else {
            //this.startPartyCommandSelection();
        	
        	// パーティコマンドウインドウを省略しているので、少し誤魔化している
        	// 最初は戦闘の人間のコマンドだが、そいつが死亡してたり行動不能の場合、困るのでBattleManager.selectNextCommand()除外の処理をしている。
        	if (Input.isLongPressed('ok')){
        		Input._latestButton = 'shift' // OK押しっぱなしでコマンド入力が飛ばされがちなのを修正
        	}
        	BattleManager.selectNextCommand()
        	//window.alert(BattleManager._actorIndex)
        	this.startActorCommandSelection();
        	
        	
        }
    } else {
        this.endCommandSelection();
    }
};
	// 上と連動。押しっぱなしで戦闘アニメ早く
Sprite_Animation.prototype.setupRate = function() {
	if (Input.isLongPressed('ok') || Input.isPressed('shift')){
		this._rate = 2;
	}else{
		this._rate = 4
	}
};
Scene_Battle.prototype.createItemWindow = function() {
    var wy = this._statusWindow.fittingHeight(2)
    var wh = Graphics.boxHeight - this._statusWindow.height - this._statusWindow.fittingHeight(2)
    this._itemWindow = new Window_BattleItem(0, wy, Graphics.boxWidth, wh);
    this._itemWindow.setHelpWindow(this._helpWindow);
    this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
    this._itemWindow.setHandler('cancel', this.onItemCancel.bind(this));
    this.addWindow(this._itemWindow);
};
	
Scene_Battle.prototype.updateWindowPositions = function() {
    var statusX = 0;
    if (BattleManager.isInputting()) {
        statusX = this._actorCommandWindow.width;
    } else {
        statusX = this._actorCommandWindow.width / 2;
    }
    if (this._statusWindow.x < statusX) {
        this._statusWindow.x += 16;
        if (this._statusWindow.x > statusX) {
            this._statusWindow.x = statusX;
        }
    }
    if (this._statusWindow.x > statusX) {
        this._statusWindow.x -= 16;
        if (this._statusWindow.x < statusX) {
            this._statusWindow.x = statusX;
        }
    }

	
	//_actorWindow
};
Scene_Battle.prototype.createStatusWindow = function() {
    this._statusWindow = new Window_BattleStatus();
	this._statusWindow.x = 278
	this._statusWindow.height = this._statusWindow.fittingHeight(3)
	this._statusWindow.y = Graphics.boxHeight - this._statusWindow.height
	this._statusWindow.width = Graphics.boxWidth - 278
	this._statusWindow.windowskin = ImageManager.loadSystem('Window4')
	//this._statusWindow._windowBackSprite.setColorTone([-255,-255,-255,0])
	//this._statusWindow._windowFrameSprite.setColorTone([-255,-255,-255,0])
    this.addWindow(this._statusWindow);
};
Scene_Battle.prototype.createActorCommandWindow = function() {
    this._actorCommandWindow = new Window_ActorCommand();
    this._actorCommandWindow.setHandler('attack', this.commandAttack.bind(this));
    this._actorCommandWindow.setHandler('skill',  this.commandSkill.bind(this));
    this._actorCommandWindow.setHandler('guard',  this.commandGuard.bind(this));
    this._actorCommandWindow.setHandler('item',   this.commandItem.bind(this));
    this._actorCommandWindow.setHandler('cancel', this.selectPreviousCommand.bind(this));
	this._actorCommandWindow.setHelpWindow(this._helpWindow);
    this.addWindow(this._actorCommandWindow);
};
Scene_Battle.prototype.createEnemyWindow = function() {
    this._enemyWindow = new Window_BattleEnemy(0, this._statusWindow.y);
    //this._enemyWindow.x = Graphics.boxWidth - this._enemyWindow.width;
	this._enemyWindow.x = 0 //this._actorCommandWindow.width
	this._enemyWindow.y = Graphics.boxHeight - this._enemyWindow.fittingHeight(7)
	this._enemyWindow.width = this._actorCommandWindow.width
	this._enemyWindow.height = this._enemyWindow.fittingHeight(7)
    this._enemyWindow.setHandler('ok',     this.onEnemyOk.bind(this));
    this._enemyWindow.setHandler('cancel', this.onEnemyCancel.bind(this));
	//this._enemyWindow._windowBackSprite.setColorTone([60,110,170,0 ])
	this._enemyWindow.setHelpWindow(this._helpWindow2);
	this._enemyWindow._helpWindow.windowskin = ImageManager.loadSystem('Window4');
	this._enemyWindow._helpWindow.width = this._actorCommandWindow.width
	this._enemyWindow._helpWindow.height = Graphics.boxHeight - this._enemyWindow.fittingHeight(8)
	
    this.addWindow(this._enemyWindow);
};
Scene_Battle.prototype.commandSkill = function() {
	
	var skills2 = this._actorCommandWindow.actorskills2()
	var skill = $dataSkills[skills2[this._actorCommandWindow.index()]]
    var action = BattleManager.inputtingAction();
    action.setSkill(skill.id);
    BattleManager.actor().setLastBattleSkill(skill);
    this.onSelectAction();
	
	
	//BattleManager.inputtingAction().setSkill(this._actorCommandWindow.currentExt);
    //this.selectEnemySelection();
	
	
	
    //this._skillWindow.setActor(BattleManager.actor());
    //this._skillWindow.setStypeId(this._actorCommandWindow.currentExt());
    //this._skillWindow.refresh();
    //this._skillWindow.show();
    //this._skillWindow.activate();
};
	
Scene_Battle.prototype.onSkillOk = function() {
    var skill = this._skillWindow.item();
    var action = BattleManager.inputtingAction();
    action.setSkill(skill.id);
    BattleManager.actor().setLastBattleSkill(skill);
    this.onSelectAction();
};
Scene_Battle.prototype.onEnemyCancel = function() {
    this._enemyWindow.hide();
    switch (this._actorCommandWindow.currentSymbol()) {
    case 'attack':
        this._actorCommandWindow.activate();
        break;
    case 'skill':
        //this._skillWindow.show();
        //this._skillWindow.activate();
    	this._actorCommandWindow.activate();
        break;
    case 'item':
        this._itemWindow.show();
        this._itemWindow.activate();
        break;
    }
};
	
Scene_Battle.prototype.selectEnemySelection = function() {
    this._enemyWindow.refresh();
    this._enemyWindow.show();
	//select(0);これ、カーソルを初期位置に戻すやつ。けしとく
    //this._enemyWindow.select(0);
    this._enemyWindow.activate();
};
// Scene_Battle以外のバトル関係
Window_Help.prototype.contentsHeight = function() {
	// ヘルプウインドウで描き込める領域を増やす。面倒なので最大値
	return Graphics.boxHeight
};
	





	// 本当はWindow_Selectableなんだけど、面倒ごとを避けるためにアクターコマンドだけ変える
	//むしろWindow_ActorCommandは別アクターのウインドウを一つで共用しているので、微妙に変
	//カーソル位置の記録設定で別アクターのカーソル記録位置から別アクターのカーソル記録位置に行くと移動音が鳴る
Window_ActorCommand.prototype.onTouch = function(triggered) {
    var lastIndex = this.index();
    var x = this.canvasToLocalX(TouchInput.x);
    var y = this.canvasToLocalY(TouchInput.y);
    var hitIndex = this.hitTest(x, y);
    if (hitIndex >= 0) {
        if (hitIndex === this.index()) {
            if (triggered && this.isTouchOkEnabled()) {
                this.processOk();
            }
        } else if (triggered && this.isCursorMovable()) {
            this.select(hitIndex);
        }
    } else if (this._stayCount >= 10) {
        if (y < this.padding) {
            this.cursorUp();
        } else if (y >= this.height - this.padding) {
            this.cursorDown();
        }
    }
    //if (this.index() !== lastIndex) {
    //    SoundManager.playCursor();
    //}
};

	// isEnabledそのスキルが使えるかどうか
Window_ActorCommand.prototype.isEnabled = function(item) {
    return this._actor && this._actor.canUse(item);
};
Window_ActorCommand.prototype.makeCommandList = function() {
	
    if (this._actor) {
        //this.addAttackCommand();
        this.addSkillCommands();
        //this.addGuardCommand();
        this.addItemCommand();
    	this.updateHelp()
    }
};

Window_ActorCommand.prototype.addAttackCommand = function() {
    this.addCommand(TextManager.attack, 'attack', this._actor.canAttack());
};

Window_ActorCommand.prototype.addSkillCommands = function() {
	// this._actor._skills2
	var skills2 = this.actorskills2()
	for (var i = 0; i < skills2.length; i++) {
		var name = ($dataSkills[skills2[i]].name).padEnd(7, '　')
		var num = ($dataSkills[skills2[i]].mpCost).toString()
		if (num == 0) {
			var numstr = ''
		}else if (num.length == 1) {
			var numstr = ' ' + num
		} else {
			var numstr = num // 二桁以上の数字の場合、何か使う時の念のため別に分けておく
		}
		
		this.addCommand(name + numstr, 'skill', this.isEnabled($dataSkills[skills2[i]]), skills2[i])
	}
	
	//var skillTypes = this._actor.addedSkillTypes();
    //skillTypes.sort(function(a, b) {
    //    return a - b;
    //});
    //skillTypes.forEach(function(stypeId) {
    //   var name = $dataSystem.skillTypes[stypeId];
    //    this.addCommand(name, 'skill', true, stypeId);
    //}, this);
};
Window_ActorCommand.prototype.actorskills2 = function() {
	if (this._actor) {
		var skills = this._actor._skills
		for (var i = 0; i < skills.length; i++) {
			if (skills[i] >= 25) {
				break
			}
		}
		var a0 = i
		
		if (this._actor._actorId != 1 && this._actor._actorId != 2) {
			var skills2 = skills.filter(function(number) {
	    		return number !== 24 && number !== 26 && number < 80;
	    	});
		}else if (this._actor._actorId == 1) {
			var askill = skills.slice(0,2)
			askill = askill.filter(function(number) {
	    		return number !== 24 && number !== 26 && number < 25;
	    	});
			var bskill = skills.slice(a0,a0 + $gameVariables.value(4) + 1)
			bskill = bskill.filter(function(number) {
	    		return number !== 24 && number !== 26 && number < 80; // スキルの数が少なくてｖ変数4が大きいとバグになるのでその対策
	    	});
			var skills2 = askill.concat(bskill)
		}else if (this._actor._actorId == 2) {
			var askill = skills.slice(0,1)
			askill = askill.filter(function(number) {
	    		return number !== 24 && number !== 26 && number < 25;
	    	});
			var bskill = skills.slice(a0,a0 + $gameVariables.value(4) + 2)
			bskill = bskill.filter(function(number) {
	    		return number !== 24 && number !== 26 && number < 80;
	    	});
			var skills2 = askill.concat(bskill)
		}
	}else{
		var skills2 = [1]
	}
	return skills2
}
Window_ActorCommand.prototype.addItemCommand = function() {
    this.addCommand(TextManager.item, 'item',this._actor.canMove());
};
Window_ActorCommand.prototype.windowWidth = function() {
    return 278//192
};

Window_ActorCommand.prototype.numVisibleRows = function() {
	return $gameVariables.value(4) + 4
	
};
Window_ActorCommand.prototype.processOk = function() {
    if (this._actor) {
        if (ConfigManager.commandRemember) {
            this._actor._lastCommandindex = this._index
        } else {
            this._actor._lastCommandindex = 0
        }
    }
    Window_Command.prototype.processOk.call(this);
};

Window_ActorCommand.prototype.drawItem = function(index) {
	var skillNo = this._list[index].ext
    var rect = this.itemRectForText(index);
	if (!(skillNo)) { // 枠線ない場合と、スキルなしの場合
		
	}else if (skillNo < 25) {
		this.drawItem_o_Rect(rect,'#FA0000')
	}else if (skillNo >= 25 && skillNo < 80){
		this.drawItem_o_Rect(rect,'#00FA00')
	}
    var align = this.itemTextAlign();
    this.resetTextColor();
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
};
Window_ActorCommand.prototype.selectLast = function() {
    this.select(0);
    if (this._actor && ConfigManager.commandRemember) {
        var symbol = this._actor.lastCommandSymbol();
        if (symbol === 'item') {
        	this.selectSymbol(symbol);
        }else{
            this.select(this._actor._lastCommandindex)
        	//var skill = this._actor.lastBattleSkill();
            //if (skill) {
            //    this.selectExt(skill.stypeId);
            //}
        }
    }
};
Window_ActorCommand.prototype.drawItem_o_Rect = function(rect,color) {
	this.contents.paintOpacity = 100
	var x = rect.x - 5
	var y = rect.y
	var xw = rect.width + 11
	var yh = rect.height
	this.contents.paintOpacity = 50
	this.contents.fillRect(x         ,          y,  6, yh, color)
	this.contents.fillRect(x         ,          y, xw,  6, color)
	this.contents.fillRect(x + xw - 6,          y,  6, yh, color)
	this.contents.fillRect(x         , y + yh - 6, xw,  6, color)
	
	this.contents.fillRect(x         ,          y,  3, yh, color)
	this.contents.fillRect(x         ,          y, xw,  3, color)
	this.contents.fillRect(x + xw - 3,          y,  3, yh, color)
	this.contents.fillRect(x         , y + yh - 3, xw,  3, color)
	this.contents.paintOpacity = 255
}
Window_ActorCommand.prototype.updateHelp = function() {
	if (!this.item()){
		this._helpWindow.visible = false
	}else if (this._helpWindow){
		this._helpWindow.visible = true
	}
	this.setHelpWindowItem(this.item())
	
}
Window_ActorCommand.prototype.item = function() {
    return this.actorskills2() && this.index() >= 0 ? $dataSkills[this.actorskills2()[this.index()]] : $dataSkills[1];
};	
	
Window_ActorCommand.prototype.select = function(index) {
    Window_Selectable.prototype.select.call(this, index);
	// ここを通ってupdateHelpがある
	this.updateHelp()
};

	
//あとでけす
//Window_ActorCommand.prototype.show = function() {
//    this.refresh();
//    this.select(0);
//	//window.alert(this.showHelpWindow())
//	this.showHelpWindow()
//    Window_SkillList.prototype.show.call(this); // Window_Selectable.prototype.show.call(this);
//};

//Window_ActorCommand.prototype.hide = function() {
//	this.hideHelpWindow()
//    Window_Selectable.prototype.hide.call(this);
//}
	// アクターに、最後に使ったコマンドのインデックス位置記録パラメータを作る。既存のと併用するとややこしいので
Game_Actor.prototype.initMembers = function() {
    Game_Battler.prototype.initMembers.call(this);
    this._actorId = 0;
    this._name = '';
    this._nickname = '';
    this._classId = 0;
    this._level = 0;
    this._characterName = '';
    this._characterIndex = 0;
    this._faceName = '';
    this._faceIndex = 0;
    this._battlerName = '';
    this._exp = {};
    this._skills = [];
    this._equips = [];
    this._actionInputIndex = 0;
    this._lastMenuSkill = new Game_Item();
    this._lastBattleSkill  = new Game_Item();
    this._lastCommandSymbol = '';
	this._lastCommandindex = 0
	this._lastEnemyindex = 0
};
Game_Actor.prototype.onBattleEnd = function() {
    this.clearResult();
    this.removeBattleStates();
    this.removeAllBuffs();
    this.clearActions();
    if (!this.isPreserveTp()) {
        this.clearTp();
    }
	this._lastEnemyindex = 0 // 戦闘終了後、敵を示すカーソル位置はリセット
    this.appear();
};
	
Window_BattleEnemy.prototype.initialize = function(x, y) {
    this._enemies = [];
    var width = this.windowWidth();
    var height = this.windowHeight();
    Window_Selectable.prototype.initialize.call(this, x, y, width, height);
    this.refresh();
	
    this.hide();
};
Window_BattleEnemy.prototype.selectLast = function() {
	var actor = BattleManager.actor()
	this._index = 0
	if (actor && ConfigManager.commandRemember) {
		var a0 = actor._lastEnemyindex
		//window.alert(a0)
		for (var i = 0; i < $gameTroop.aliveMembers().length; i++) {
			if ($gameTroop.aliveMembers()[i].index () === a0) {
				this._index = i; // 一致するエネミーが見つかった場合、そのインデックスを保存
				break; // ループを終了
			}
		}
		
	}
	//window.alert(this._index)
	this.select(this._index);
};
Window_BattleEnemy.prototype.numVisibleRows = function() {
    return 7;
};
Window_BattleEnemy.prototype.maxCols = function() {
    return 1;
};
Window_BattleEnemy.prototype.enemy = function() {
    return this._enemies[this.index()];
};
Window_BattleEnemy.prototype.processOk = function() {
	var actor = BattleManager.actor()
	if (actor) {
        if (ConfigManager.commandRemember) {
        	
        	$gameActors.actor(actor.actorId())._lastEnemyindex = this.enemy().index()
        	//window.alert(actor._lastEnemyindex)
        } else {
            $gameActors.actor(actor.actorId())._lastEnemyindex = 0
        }
    }
    Window_Selectable.prototype.processOk.call(this);
};
Window_BattleEnemy.prototype.updateHelp = function(enemy) {
	if (this._helpWindow && enemy){
		//$gameParty.allMembers()[1]._states
		var judge0 = true
		for (var i = 0; i < $gameParty.allMembers().length; i++) {
			if ($gameParty.allMembers()[i]._states.contains(31)) { // イビルアイステートのチェック
				judge0 = false
			}else if ($gameParty.allMembers()[i].hasArmor($dataArmors[15])) { // イビルアイステートのチェック
				judge0 = false
			}
		}
		if (judge0) {
			this._helpWindow.hide();
			return
		}
		if (enemy.enemy().dropItems[0].kind <= 0){
			var hokakuka = '捕獲不可'
		}else{
			var hokakuka = ''
		}
		//this._states.push(stateId)
		//enemy.enemy()というアホみたいな文は、enemy：今出ているバトルエネミーの、enemy()：エネミーデータベース情報
		//Window_BattleEnemyのenemy()と、Game_Enemyのenemy()の指すのがちがうからややこしい
		//var text = enemy.enemy().dropItems[0].kind
		// BattleManagerで直前に使った技の情報を抜くことができるのは便利なので、とっておく
		/*
		if (BattleManager._action && BattleManager._action.isSkill()) {
			var text = BattleManager.action.item().id
		}
		*/
		//行間を33にすることで、0行目から9行目まで書くことが可能だった
		//this._helpWindow.drawText(i * 111111, 0, 33 * i, 278, 'left')
		
		
		this._helpWindow.contents.clear()
		this._helpWindow.contentsOpacity = 180
		this._helpWindow.contents.textColor = '#07d438'
		this._helpWindow.contents.outlineColor = '#004d13'
		/*
		var i = this.index()
		var x = TouchInput.x
		var y = TouchInput.y
	    var enemies = this._enemies
	    var sprites = BattleManager._spriteset._enemySprites
        var x0 = this._enemies[i]._screenX
    	var y0 = this._enemies[i]._screenY
    	var sw = sprites[i].bitmap.width
		var sh = sprites[i].bitmap.height
		var x1 = x0 - Math.floor(sw / 2)
		var y1 = y0 - sh
		*/
		
		var text = [] // String().padStart(3, ' ')_elementRate
		text[0] = 'HP ' + String(enemy.hp).padStart(5, ' ') +  ' MP ' + String(enemy.mp).padStart(4, ' ')
		text[1] = 'ATK ' + String(enemy.atk).padStart(3, ' ') + '  DEF ' + String(enemy.def).padStart(3, ' ')
		text[2] = 'MAT ' + String(enemy.mat).padStart(3, ' ') + '  MDF ' + String(enemy.mdf).padStart(3, ' ')
		text[3] = 'AGI ' + String(enemy.agi).padStart(3, ' ') + '  VIT ' + String(enemy.luk).padStart(3, ' ')
		text[4] = 'CA  ' + String(enemy._capture).padStart(3, ' ')
		text[5] = ''
		text[6] = ''
		text[7] = hokakuka
		text[8] = 'mHP ' + String(enemy.mhp).padStart(5, ' ')
		text[9] = ''
		
		var res  = 'Res  '
		var weak = 'Weak '
		for (var i = 0; i <= 9; i++) {
			if (enemy.elementRate(i) < 1.0){
				res = res + $dataSystem.elements[i]
			}else if (enemy.elementRate(i) > 1.0){
				weak = weak + $dataSystem.elements[i]
			}
		}
		// 耐性、弱点がない時は表記しないようにしようかと思ったけど、敵全部に耐性弱点つけるようにしたんでイランかもしれん
		if (res !== 'Res  '){
			text[5] = res
		}
		if (weak !== 'Weak '){
			text[6] = weak
		}
		
		var font0 = this.contents.fontFace
		this._helpWindow.contents.fontFace = 'font1' // 機械っぽいフォントに変更
		for (var i = 0; i <= 7; i++) { // もう捕獲可能かどうかまでしか記載しない
			this._helpWindow.drawText(text[i], 0, 33 * i, 278, 'left')
		}
		this._helpWindow.contents.fontFace = font0
		// ATK DEF MAT MDF AGI   VIT:体力で、状態異常体制にする？
		
	}
};
	
Window_BattleEnemy.prototype.exyj = function() {
	var lastIndex = this.index()
	var newIndex = -1
	//var x = this.canvasToLocalX(TouchInput.x);
	//var y = this.canvasToLocalY(TouchInput.y);
	var x = TouchInput.x // 普通に、クリックした画面の座標
	var y = TouchInput.y
    var enemies = this._enemies
    var sprites = BattleManager._spriteset._enemySprites
    
	for (var i = 0; i < enemies.length; i++) {
        var x0 = this._enemies[i]._screenX // _screenXはなぜか画像の中央ｘ座標
    	var y0 = this._enemies[i]._screenY // _screenYはなぜか画像の一番下をｙ座標にしてる
    	var sw = sprites[i].bitmap.width
		var sh = sprites[i].bitmap.height
		var x1 = x0 - Math.floor(sw / 2)
		var y1 = y0 - sh
		var x2 = x - x1
		var y2 = y - y1
    	if (x >= x1 && y >= y1 && x < x1 + sw && y < y1 + sh){
    		
    		if (parseInt(sprites[i].bitmap.getAlphaPixel(x2, y2),16) > 20){
    			newIndex = i
    			break
    		}
    		
    	}
    }
	if (newIndex == -1) {
	}else if (newIndex != lastIndex) {
		this.select(newIndex)
        SoundManager.playCursor();
	}else if (newIndex == lastIndex) {
		this.processOk()
    }
    //this._enemies = $gameTroop.aliveMembers();
    //上が生存エネミーの配列。つまり、選択肢に出ているエネミー一覧って事。
	//enemy() → RPGEnemy敵キャラのデータベース情報
	// _screenX 画面上の x 座標    _screenY　width
	// BattleManager._spriteset._enemySprites
	// Game_EnemyのenemyId()はモンスターの番号$dataEnemies[this._enemyId]
	// Game_Enemyのindex()は$gameTroopでの番号
};
	


Window_BattleEnemy.prototype.select = function(index) {
    Window_Selectable.prototype.select.call(this, index);
	//if (index == 0) {
	//	aaaaaaaa[s] = bujlo
	//}
	//window.alert(index)
    $gameTroop.select(this.enemy());
	// ここを通ってupdateHelpがある
	this.updateHelp(this.enemy())
};
Window_BattleEnemy.prototype.show = function() {
    this.refresh();
	this.selectLast()
	this.showHelpWindow()
    Window_Selectable.prototype.show.call(this);
};

Window_BattleEnemy.prototype.hide = function() {
	this.hideHelpWindow()
    Window_Selectable.prototype.hide.call(this);
    $gameTroop.select(null);
};
	// エネミーの位置を判断する色々を作成

Window_BattleEnemy.prototype.processTouch = function() {
    if (this.isOpenAndActive()) {
    	
        if (TouchInput.isTriggered() && this.isTouchedInsideFrame()) {
            this._touching = true;
            this.onTouch(true);
        } else if (TouchInput.isCancelled()) {
            if (this.isCancelEnabled()) {
                this.processCancel();
            }
        }else if (TouchInput.isTriggered() && !(this.isTouchedInsideFrame())) {
        	this.exyj()
        	
        }
        if (this._touching) {
            if (TouchInput.isPressed()) {
                this.onTouch(false);
            } else {
                this._touching = false;
            }
        }
    } else {
        this._touching = false;
    }
};
Window_Base.prototype.drawActorIcons = function(actor, x, y, width) {
	// 一応、ステートと能力上昇のアイコン表記に関する場所
	// ただ、能力上昇は使わないのでアイコン範囲もぶち壊しにしていたりする
	// 注意点として、これはアイコンを扱っているのでステートを扱っているのではないということ
	// 扱う番号も、全部アイコンの画像の番号でステートの番号ではない
    width = width || 144;
	var lim0 = 10 // 表記しないアイコンのID範囲。普通は10で。つまり、アイコン0とか上の方のは表記なしの空のアイコン
	var icons = actor.allIcons().filter(num => num > lim0);
	var haba = Math.floor(width / icons.length)
	if (haba > Window_Base._iconWidth) {
		haba = Window_Base._iconWidth
	}
    for (var i = 0; i < icons.length; i++) {
        this.drawIcon(icons[i], x + haba * i, y + 2);
    }
};
Window_BattleStatus.prototype.windowWidth = function() {
    return Graphics.boxWidth - 278;
};
Window_BattleStatus.prototype.numVisibleRows = function() {
    return 3;
};
Window_BattleStatus.prototype.gaugeAreaWidth = function() {
	return 330 - (278 - 192)
};
Window_BattleStatus.prototype.drawGaugeAreaWithoutTp = function(rect, actor) {
    this.drawActorHp(actor, rect.x + 0, rect.y, 110);// 116
    this.drawActorMp(actor, rect.x + 135,  rect.y, 110);
};
	
	// 特定グループの敵には、A、B、Cなどがつかないようにする
Game_Enemy.prototype.name = function() {
	if ($gameTroop._troopId >= 139 && $gameTroop._troopId <= 146) {
        return this.originalName()  // 識別文字なし
	}else{
		return this.originalName() + (this._plural ? this._letter : '');
	}
};
// 敵の行動でターンでの制御の挙動がおかしいので
Game_Enemy.prototype.meetsTurnCondition = function(param1, param2) {
    var n = $gameTroop.turnCount() + 1 // n を+1の修正しただけ
    if (param2 === 0) {
        return n === param1;
    } else {
        return n > 0 && n >= param1 && n % param2 === param1 % param2;
    }
};
	
Sprite_Enemy.prototype.updateCollapse = function() {
	if ($gameSwitches.value(4)) {
		var d = this._effectDuration
		this.scale.x = (this.scale.x  * (d - 1) + 0.1)  / d
		this.scale.y = (this.scale.y  * (d - 1) + 0.1)  / d
	}else{
		
	}
	this.blendMode = Graphics.BLEND_ADD;
	this.setBlendColor([255, 128, 128, 128]);
	this.opacity *= this._effectDuration / (this._effectDuration + 1);
};


Game_Enemy.prototype.setup = function(enemyId, x, y) {
    this._enemyId = enemyId;
    this._screenX = x;
	if (this._enemyId == 50) { // ラスボスの戦闘の配置を変える
		this._screenX = 48*17/2;
		this._screenY = 48*13;
	}else{
		this._screenY = y + 48;
	}
    this.recoverAll();
};
// 捕獲っぽいエフェクトのために。ただし、先にドロップアイテム判定してからやる
// なんかツクールMVは死亡エフェクトの後にドロップアイテムの判定してる？かもしれないので
// 我流の判定をぶち込んで、捕獲という名のアイテム獲得の後に、捕獲エフェクトする
Game_Enemy.prototype.performCollapse = function() {
    Game_Battler.prototype.performCollapse.call(this);
	this.makeDropItems2() // 死亡エフェクトの前に捕獲判定
    switch (this.collapseType()) {
    case 0:
        this.requestEffect('collapse');
        SoundManager.playEnemyCollapse();
        break;
    case 1:
        this.requestEffect('bossCollapse');
        SoundManager.playBossCollapse1();
        break;
    case 2:
        this.requestEffect('instantCollapse');
        break;
    }
};
// 改造しにくいので、forの文に書き直し
Game_Enemy.prototype.makeDropItems = function() {
	var d0 = []
	var enemy = this.enemy()
	var dropItemRate = this.dropItemRate() // dropItemRate()：主人公側の可変できるドロップアイテム率
	for (var i = 0; i < enemy.dropItems.length; i++) {
		var di = enemy.dropItems[i];
		if (i == 0) { // バグの温床になりそうなのでできるだけ変えたくないので
			if (di.kind > 0 && this.exp() != this.enemy().exp) { // dropItems[i].kind=0は、ドロップアイテムなしのこと
				d0 = d0.concat(this.itemObject(di.kind, di.dataId));
			}
		}else if (di.kind > 0 && Math.random() * di.denominator < dropItemRate) {
			d0 = d0.concat(this.itemObject(di.kind, di.dataId));
		}
	}
	return d0
};
	// 捕獲をアイテムドロップで表現しているので、その処理について
Game_Enemy.prototype.makeDropItems2 = function() {
	// 捕獲判定
	$gameSwitches.setValue(4,false)
	if (!(this.enemy().dropItems[0].kind > 0)) { // ドロップアイテムない場合はリターン
		return
	}
	var r0 = 0 // 第一判定。何のスキルで攻撃して敵を倒したか
	var r1 = false
	if (BattleManager._action && BattleManager._action.isSkill()) {
		var sid = BattleManager._action.item().id
		if (sid == 28) { // バインド７０％
			r0 = 70
		}else if (sid == 63 || sid == 49) { // 怪音波も捕獲率高い
			r0 = 50// ５０％
		}else if (sid == 21) {
			r0 = 30// まきつき３０％
		}else if (sid == 51 || sid == 43) {
			r0 = 25// クラッカーの電気まきつき３０％
		}else{
			r0 = 10 // 何もなくても10
		}
		if (Math.random() * 100 < r0) {
			r1 = true
		}
	}
	if (Math.random() * 100 < this._capture) { // 第二判定、捕獲率CR
		r1 = true
	}
	// 第三判定、MP減少している、捕獲状態異常になっていると捕獲しやすい。狂酒の捕獲率はMP判定に加算
	var r0 = (1 - this.mpRate()) * 20
	if (this.isStateAffected(43)) {
		r0 += 90
		this.eraseState(43)
	}
	if (Math.random() * 100 < r0) {
		r1 = true
	}
	if (r1) {
		$gameSwitches.setValue(4,true)
		this._exp = Math.floor(this.enemy().exp * 0.7)
		this.startAnimation(10, false, 3) // 捕獲性交判定時のアニメーション
	}
	this._capture = 11 // 捕獲の成否にかかわらず、死亡時は捕獲率リセット
	//ドロップ判定は戦闘終了時にしている？
	//$gameSwitches.setValue(4,true)については、捕獲時に敵グラを縮小変化させるのに使用
	//ifステートで判断しようとして失敗。死亡の時のステート処理を考えるとややこしい
	//ステート消すeraseState(11)ステートがあるか判定isStateAffected(11)
	//by arakusyumi
};
Game_Enemy.prototype.initMembers = function() {
    Game_Battler.prototype.initMembers.call(this);
    this._enemyId = 0;
    this._letter = '';
    this._plural = false;
    this._screenX = 0;
    this._screenY = 0;
	this._capture = 11 // 新しく、捕獲数字のパラメーター作る
	this._exp = -1
};
Game_Enemy.prototype.exp = function() {
	if (this._exp == -1) {
		 return this.enemy().exp;
	}else{
		return this._exp
	}
};
// 追加されたステートが捕獲関連ステートだった場合、捕獲率を変動させてそのステートを消す
	
Game_Enemy.prototype.addState = function(stateId) {
    if (this.isStateAddable(stateId)) {
        if (!this.isStateAffected(stateId)) {
	        if (stateId >= 12 && stateId <= 14) { // 粘液の場合
			    if (stateId === 12) {
			    	this._capture += 10
			    }else if (stateId === 13) {
			    	this._capture += 15
			    }else if (stateId === 14) {
			    	this._capture += 25
			    }
		    	if (this._capture >= 100) {
					this._capture = 31
					stateId = 15
		    	}else{
		    		return // ステートが追加されないように戻す
		    	}
	        }else if (stateId >= 4 && stateId <= 5) { // 猛毒、呪詛の場合。CAを１５あげる
	        	this._capture += 15
	        }
        	stateId = this.addSpecialState(stateId)
            this.addNewState(stateId);
            this.refresh();
        }
        this.resetStateCounts(stateId);
        this._result.pushAddedState(stateId);
    }
};

Game_Actor.prototype.addState = function(stateId) { // エネミーと内容が違うので分ける
    if (this.isStateAddable(stateId)) {
        if (!this.isStateAffected(stateId)) {
        	stateId = this.addSpecialState(stateId)
            this.addNewState(stateId);
            this.refresh();
        }
        this.resetStateCounts(stateId);
        this._result.pushAddedState(stateId);
    }
};
	// 死亡時に、パッシブスキルのステートがはがれないように改造
Game_BattlerBase.prototype.die = function() {
    this._hp = 0;
    for (var i = 4; i <= 20; i++) {
    	this.eraseState(i)
    }
    this.clearBuffs();
};
	/*
	// 榎並―死亡時はステートによってCAが変動するので猛毒と呪詛の除外処理
	// ・・・そうしようと思ったけど、ステートの画面表示が死亡の時に消えるのにタイムラグ起きるようになったから、やめる
Game_Enemy.prototype.die = function() {
    this._hp = 0;
    for (var i = 6; i <= 20; i++) {
    	this.eraseState(i)
    }
    this.clearBuffs();
};
*/
Game_Battler.prototype.addSpecialState = function(stateId) { //特殊なスキルの調整
    if (stateId === 8) { // 攻撃能力
    	if (this._states.includes(6)){
    		stateId = 7
    		this.eraseState(6)
    	}else if (this._states.includes(7)){
    		stateId = 8
    		this.eraseState(7)
    	}else{
    		stateId = 6
    	}
    }else if (stateId === 11) { // 
    	if (this._states.includes(9)){
    		stateId = 10
    		this.eraseState(9)
    	}else if (this._states.includes(10)){
    		stateId = 11
    		this.eraseState(10)
    		//this.eraseState(5)
    		//this._states.push(5)
    	}else{
    		stateId = 9
    	}
    }
    return stateId
};



Scene_Battle.prototype.startFadeIn = function(duration, white) {
    //this.createFadeSprite(white);
    //this._fadeSign = 1;
    //this._fadeDuration = duration || 30;
    //this._fadeSprite.opacity = 255;
};

Scene_Map.prototype.startFlashForEncounter = function(duration) {
    //var color = [255, 255, 255, 255];
    //$gameScreen.startFlash(color, duration);
};
	
Game_Action.prototype.isForDeadFriend = function() {
    return this.checkItemScope([9, 10]);
};

	// した2つ、ターゲットが死んでるかどうかについてやってる。ややこしい
Game_Action.prototype.testApply = function(target) {
	if (this.item().effects.some(effect => effect.code == 22 && effect.dataId == 1)) {// コード22ステート解除、dataId==1戦闘不能。それが存在する場合の処理
		var d0 = true
	}else{
		var d0 = this.isForDeadFriend() === target.isDead()
	}
    return (d0 &&
            ($gameParty.inBattle() || this.isForOpponent() ||
            (this.isHpRecover() && target.hp < target.mhp) ||
            (this.isMpRecover() && target.mp < target.mmp) ||
            (this.hasItemAnyValidEffects(target))));
};
	//味方ターゲットの？
Game_Action.prototype.targetsForFriends = function() {
    var targets = [];
    var unit = this.friendsUnit();
    if (this.isForUser()) {
        return [this.subject()];
    } else if (this.item().effects.some(effect => effect.code == 22 && effect.dataId == 1)) {
        // 生きている味方・単独でも死んだ味方・単独でもどちらでもターゲットにできる時だけど
    	// コード22ステート解除、dataId==1戦闘不能。それが存在する場合の処理
    	//window.alert(111)
    	if (this.isForOne()) { // 単体蘇生
        	targets.push(unit.members()[this._targetIndex]);
        } else { // 全体蘇生
            targets = unit.members();
        }
    } else if (this.isForDeadFriend()) {
        if (this.isForOne()) {
        	targets.push(unit.smoothDeadTarget(this._targetIndex));
        } else {
            targets = unit.deadMembers();
        }
    } else if (this.isForOne()) {
        if (this._targetIndex < 0) {
            targets.push(unit.randomTarget());
        } else {
            targets.push(unit.smoothTarget(this._targetIndex));
        }
    } else {
        targets = unit.aliveMembers();
    }
    return targets;
};

	
	// 状態異常には魔法攻撃力を噛ませる
	//「運」は他になんの効果があるか直感的にわかりづらいので、この言い回しを削除。生命力VITにする
Game_Action.prototype.lukEffectRate = function(target) {
    return Math.max(1.0 + (this.subject().mat - target.luk) * 0.001, 0.0);
};
	// コモンイベントスキルを使う場合、使用者対象範囲などを獲得しておく
	// スキルでコモンイベントを動かすと変な挙動があるんで、使わないかもしれん
	// ※挙動が不安定なので、保留。動かないようにしておく
	// 自爆に使うので動かすことにした
Game_Action.prototype.applyGlobal = function() {
    this.item().effects.forEach(function(effect) {
        if (effect.code === Game_Action.EFFECT_COMMON_EVENT) {
        	if (this.subject().isActor()) {
        		$gameVariables.setValue(26,this.subject()._actorId)
        		$gameVariables.setValue(27,this._lastTargetIndex)
        	}else{
        		$gameVariables.setValue(26,this.subject().index() + 1000) // グループ内の番号代入
        		$gameVariables.setValue(27,this._lastTargetIndex)
        	}
            $gameTemp.reserveCommonEvent(effect.dataId);
        }
    }, this);
};

	// アクションのここを改造して、特定のスキルを使う時は別のスキルを使うようにする
Game_Action.prototype.setSkill = function(skillId) {
	if (skillId == 13) {
		var r0 = 11 * Math.random()
		if (r0 >= 0 && r0 < 2) {
			skillId = 31
		}else if (r0 >= 2 && r0 < 4) {
    		skillId = 46
		}else if (r0 >= 4 && r0 < 6) {
			skillId = 49
		}else if (r0 >= 6 && r0 < 8) {
			skillId = 51
		}else if (r0 >= 8 && r0 < 10) {
			skillId = 57
		}else{
			skillId = 60
		}
    }
    this._item.setObject($dataSkills[skillId]);
};

	
	// コスト払う時のTPの数値を用いて、自分にステートを付ける変なやり口でしとく
Game_Battler.prototype.paySkillCost = function(skill) {
	
    this._mp -= this.skillMpCost(skill);
    this._tp -= this.skillTpCost(skill);
	if (skill.tpGain >= 20) {
		this.addState(skill.tpGain)
	}else if (skill.id == 48) { // コアクラッシュの番号 自爆用
		this.addParam(0,-1*(Math.floor(this.mhp / 8)))
	}
};
	// ダメージを受けた時、最大HPも削られる改造・アクター
	
Game_Actor.prototype.gainHp = function(value) {
	var nani = $gameVariables.value(62)
	if (value < 0) {
		value = Math.floor(value * (1 - nani * 0.05))// ダメージ量の修正。ゲームバランス用
		this.addParam(0,-1*(Math.floor(-value / 20)))
	}
    this._result.hpDamage = -value;
    this._result.hpAffected = true;
    this.setHp(this.hp + value);
};
	// ダメージを受けた時、最大HPも削られる改造・エネミー
Game_Enemy.prototype.gainHp = function(value) {
	var nani = Math.max($gameVariables.value(62),2)
	if (value < 0) {
		value = Math.floor(value * (1 + nani * 0.1)) // ダメージ量ゲームバランス用…バランス悪くなったので上弦ありになった
		this.addParam(0,-1*(Math.floor(-value / 20)))
	}
    this._result.hpDamage = -value;
    this._result.hpAffected = true;
    this.setHp(this.hp + value);
};
	
	// 攻撃回数変更
Game_Action.prototype.numRepeats = function() {
    var repeats = this.item().repeats;
	if (!(this.isItem())) {
        repeats += this.subject().attackTimesAdd();
    }
    return Math.floor(repeats);
};
Game_Action.prototype.apply = function(target) {
    var result = target.result();
    this.subject().clearResult();
    result.clear();
    result.used = this.testApply(target);
	
	var hityo = Math.max(this.itemHit(target) - 1,0)
	var evayo = Math.max(0 - this.itemEva(target),0)
	var hithu = Math.max(1 - this.itemHit(target),0)
	
    result.missed = (result.used && Math.random() >= this.itemHit(target) + evayo * hithu);
    result.evaded = (!result.missed && Math.random() < this.itemEva(target)*(1 - hityo));
    result.physical = this.isPhysical();
    result.drain = this.isDrain();
	// 属性有効度の計算と格納
    result.elementRate = this.calcElementRate(target)
	
    if (result.isHit()) {
        if (this.item().damage.type > 0) {
            result.critical = (Math.random() < this.itemCri(target));
            var value = this.makeDamageValue(target, result.critical);
            this.executeDamage(target, value);
        }
        this.item().effects.forEach(function(effect) {
            this.applyItemEffect(target, effect);
        }, this);
        this.applyItemUserEffect(target);
    }
};
	// クリティカルダメージを、デフォルトの3倍から２倍に変更。
Game_Action.prototype.applyCritical = function(damage) {
    return damage * 2;
};
	// ツクールでの攻撃速度補正入力の上限が2000なので、いじる。ステータスは1000ぐらいの差を覆しそう
Game_Action.prototype.speed = function() {
    var agi = this.subject().agi;
    var speed = agi + Math.randomInt(Math.floor(5 + agi / 4));
    if (this.item()) {
    	if (this.item().speed == 2000) { // 先制攻撃
    		speed += 6000
    	}else if (this.item().speed == 1000) { // 回復、攻撃補助
    		speed += 4000
    	}else if (this.item().speed == 500) { // 補助消去など
    		speed += 2000
    	}else{
    		speed += this.item().speed;
    	}
    }
    if (this.isAttack()) {
        speed += this.subject().attackSpeed();
    }
    return speed;
};
	
	
	// 属性防御強化は、属性の欠点を打ち消すという工夫
Game_BattlerBase.prototype.elementRate = function(elementId) {
	 // すべての属性倍率を取得（配列）
	rates = this.traitsWithId(Game_BattlerBase.TRAIT_ELEMENT_RATE, elementId)
                      .map(trait => trait.value);
	//window.alert(rates)
	// ratesが空の場合は1.0を返す（倍率なし）
	if (rates.length === 0) return 1.0;
		// 上と下の倍率があるか判定
		var hasAbove = rates.some(rate => rate > 1.0);
		var hasBelow = rates.some(rate => rate < 1.0);
	if (hasAbove && hasBelow) {
		// 上も下もある場合 → 1.0未満の倍率だけにする。つまり、ダメージ増加の倍率はなしにする。
		return rates
		.filter(rate => rate < 1.0)
		.reduce((acc, rate) => acc * rate, 1.0);
	} else {
		return rates.reduce((acc, rate) => acc * rate, 1.0) // それ以外 → 全部掛け合わせる
	}
};
	// 属性有効度で、クリティカルと同じようにダメージ数字を赤にする
Sprite_Damage.prototype.setup = function(target) {
    var result = target.result();
    if (result.missed || result.evaded) {
        this.createMiss();
    } else if (result.hpAffected) {
        this.createDigits(0, result.hpDamage);
    } else if (target.isAlive() && result.mpDamage !== 0) {
        this.createDigits(2, result.mpDamage);
    }
	//window.alert(result.elementRate)
    if (result.critical) {
        this.setupCriticalEffect();
    }else if (result.elementRate > 1.0) {
    	this.setupWeakEffect()
    }else if (result.elementRate < 1.0) {
    	this.setupResEffect()
    }
	
};
Sprite_Damage.prototype.setupWeakEffect = function() {//弱点を突かれた
    this._flashColor = [255, 165, 0, 160];
    this._flashDuration = 60;
};
Sprite_Damage.prototype.setupResEffect = function() {//耐性
    this._flashColor = [0, 108, 115, 160];
    this._flashDuration = 60;
};
	// ダメージの表記sprite = new Sprite_Damage()のY座標が下になりすぎないようにする
Sprite_Battler.prototype.setupDamagePopup = function() {
    if (this._battler.isDamagePopupRequested()) {
        if (this._battler.isSpriteVisible()) {
            var sprite = new Sprite_Damage();
            sprite.x = this.x + this.damageOffsetX();
            sprite.y = Math.min(this.y + this.damageOffsetY(),48*10);
            sprite.setup(this._battler);
            this._damages.push(sprite);
            this.parent.addChild(sprite);
        }
        this._battler.clearDamagePopup();
        this._battler.clearResult();
    }
};
	// 属性複数対応
Game_Action.prototype.calcElementRate = function(target) {
    var elementId = this.item().damage.elementId;
    if (elementId < 0) {
        return this.elementsMaxRate(target, this.subject().attackElements());
    } else {
        var baseRate = target.elementRate(elementId);
        var maxRate = this.elementsMaxRate(target, this.subject().attackElements());
    	if (baseRate == 1.0) {
    		return maxRate
    	}else if (maxRate == 1.0) {
    		return baseRate
    	}else{
    		return Math.max(baseRate, maxRate);
    	}
        
    }
};
	
//Game_Map.prototype.changeBattleback = function(battleback1Name, battleback2Name) {
//    this._battleback1Name = battleback1Name;
//    this._battleback2Name = battleback2Name;
//};
	
//ここでビットマップを決定	
//Spriteset_Battle.prototype.battleback1Bitmap = function() {
//    return ImageManager.loadBattleback1(this.battleback1Name());
//};
//上をふまえると、Spriteset_Battle.prototype.createBattlebackだけしかバトルバックのビットマップを
//使っていないので、こいつを再起動しないと背景差し替え変化が起こらないと考えられる
//setTransform (x, y, scaleX, scaleY, rotation, skewX, skewY, pivotX, pivotY)
	
	// イベントコマンドで戦闘背景を変えた後、動かすと戦闘中に別の背景にできる
	// 背景の絵自体を変える時に使おうとしたけど、画像の大きさ違いとかで混乱するので美容に使いにくい
	// さらにBattleManager._spritesetからやる必要があったりする。今回は使わないけど便利なので保留
Spriteset_Battle.prototype.c_Battleback = function() { 
    this._back1Sprite.bitmap = this.battleback1Bitmap();
    this._back2Sprite.bitmap = this.battleback2Bitmap();
	
};

Spriteset_Battle.prototype.syubi_Battleback = function() { 
	this._back2Sprite.bitmap = this.battleback2Bitmap();
    var enemies = $gameTroop.members();// 敵の状況で背景を変える場合
	var v0 = $gameVariables.value(37)
	$gameVariables.setValue(37,v0 + 1) 
	var hp0 = Math.min(1, (v0 * 4 + 56) / 233)
	var hp1 = 56/233
	// 守備隊との戦闘では、敵の死亡時に変数の蓄積を行い、それで背景を変えるv37
	// 最大横233　最小24　scale 24/233
	// 上移動210     408  624
	//380,0 56        345,70 124   290
	// 292,186 さ(88,186)
	// ラスボスはHP残量で、守備隊はザコの倒した数で変動させる。今回はテストプレイ
	if (v0 > 46) {
		$gameSwitches.setValue(20,true)
		return
	}
	var width = this._battleField.width;
    var height = this._battleField.height;
    var sprite2 = this._back2Sprite; // 守備隊は２のみ使う
    sprite2.scale.x = hp0
	sprite2.scale.y = hp0
	//window.alert(height)
	sprite2.x = -32 +(1 - hp0) * (48*17 + 60) / 2
	sprite2.y = -25 - (25* (1/(1 - hp1) + hp0/(hp1 - 1)))
	
	
};


Spriteset_Battle.prototype.last_Battleback = function() { 
	this._back2Sprite.bitmap = this.battleback2Bitmap();
	
    var enemies = $gameTroop.members();
	var sprite1 = this._back1Sprite
	/*
	var v0 = $gameVariables.value(37)
	// ラスボスHP残量
	var hp0 = enemies[0].hp - 3000  // 少しの間、余裕を持たせたいのでHP3000がラスト
	
	if (hp0 < v0) {
		v0 = hp0
		$gameVariables.setValue(37,v0) // 拡大率をおさめる
	}
	*/
	
	// ラスボス。敵の状況で背景を変える場合・・・にしようかと思ったが、やっぱりターン数でやる
	var v0 = 10000 - Math.max(0,Math.min(10,$gameTroop.turnCount() - 2)) * 1000 // ターン数を代入
	$gameVariables.setValue(38,v0)
	if (v0 < 0) {
		var s0 = 2
		sprite1.x = (1 - s0) * 48 * 17 / 2
		sprite1.y =  0/ + 740 * (1 - 2)
	}else if (v0 >= 5000 && v0 <= 10000) {
		var s0 = Math.min(2, v0 / 5000) // 拡大倍率。加速させたい場合はhp0にかける
		sprite1.x = (1 - s0) * 48 * 17 / 2
		sprite1.y =  0 + 740 * (1 - s0)
	}else{
		var s0 = Math.min(2, (5000 * 2 - v0) / 5000)
		sprite1.x = (1 - s0) * 48 * 17 / 2
		sprite1.y =  0/ + 740 * (1 - 2)
	}
	
    sprite1.scale.x = s0
	sprite1.scale.y = s0
	
};
// ちょっと挿入。スプライトセット._enemySpritesの並びが$gameTroop.aliveMembers()に連動しないと面倒なので
// 主にクリックで敵を選ぶときのための習性
Spriteset_Battle.prototype.createEnemies = function() {
    var enemies = $gameTroop.members();
    var sprites = [];
    for (var i = 0; i < enemies.length; i++) {
        sprites[i] = new Sprite_Enemy(enemies[i]);
    }
	this._enemySprites = sprites;
	var sprites00 = sprites.slice() // 表示のZ座標だけ変える？
	sprites00.sort(this.compareEnemySprite.bind(this));
    for (var j = 0; j < sprites00.length; j++) {
        this._battleField.addChild(sprites00[j]);
    }
    
};
// 特定の敵を手前に表示
	
Spriteset_Battle.prototype.compareEnemySprite = function(a, b) {
	var a0 = a._enemy
	var b0 = b._enemy
	//window.alert(a0._enemyId)
	if (a0._enemyId >= 51 && a0._enemyId <= 54) {
        return 1; // aが47~49番なら、aを前に表示
    } else if (b0._enemyId >= 51 && b0._enemyId <= 54) {
        return -1; // bが47~49番なら、bを前に表示
    }
    if (a0._enemyId >= 55 && a0._enemyId <= 64) {// 奥への表示
        return -1; 
    } else if (b0._enemyId >= 55 && b0._enemyId <= 64) {
        return 1; 
    }
	
    if (a.y !== b.y) {
        return a.y - b.y;
    } else {
        return b.spriteId - a.spriteId;
    }
};



Sprite_Animation.prototype.processTimingData = function(timing) {
    var duration = timing.flashDuration * this._rate;
	var target = this._target._enemy // アニメーションの対象
    // 特定の敵キャラのID（例: 50番）をチェック
    if (!target) {
    }else if (target._enemyId === 50) {
    	if (!this._duplicated && timing.se) {
    		AudioManager.playSe(timing.se);
    	}
        return; // IDが50の場合はフラッシュをスキップ
    }
    switch (timing.flashScope) {
    case 1:
        this.startFlash(timing.flashColor, duration);
        break;
    case 2:
        this.startScreenFlash(timing.flashColor, duration);
        break;
    case 3:
        this.startHiding(duration);
        break;
    }
    if (!this._duplicated && timing.se) {
        AudioManager.playSe(timing.se);
    }
};
	
	// バトラーの表示アイコンについてやってる部分。再度ビューとかは主人公もこれでやるのかな
Sprite_StateIcon.prototype.updateIcon = function() {
    var icons = [];
    if (this._battler && this._battler.isAlive()) {
        icons = this._battler.allIcons();
    }
    if (icons.length > 0) {
    	this._animationIndex = 0
        this._iconIndex = icons[this._animationIndex];
    } else {
        this._animationIndex = 0;
        this._iconIndex = 0;
    }
};
	
	
Sprite_StateIcon.prototype.updateFrame = function() {
    var width = 64
    var lim0 = 10 // 表記しないアイコンの画像。０番だけでいい気がするが、念のため１０未満を取り除く
    var icons = this._battler.allIcons().filter(num => num > lim0&& num != 160)
    var haba = Math.floor(width / icons.length)
    var pw = Sprite_StateIcon._iconWidth
    var ph = Sprite_StateIcon._iconHeight

    // 既存のスプライトを削除
    while (this.children.length > 0) {
        var sprite = this.children[0]
        this.removeChild(sprite)
        sprite.destroy() // スプライトを完全に解放
    }

    // 新しいスプライトを追加
    for (var i = 0; i < icons.length; i++) {
        var sprite = new Sprite()
        sprite.bitmap = this._bitmap
        sprite.x = i * haba
        this.addChild(sprite)
        var sx = icons[i] % 16 * pw
        var sy = Math.floor(icons[i] / 16) * ph
        sprite.setFrame(sx, sy, pw, ph)
    }
};
	
	// ラストバトルの終わり方を特殊な感じにする
BattleManager.displayVictoryMessage = function() {
	if (!($gameSwitches.value(19))){
		$gameMessage.add(TextManager.victory.format($gameParty.name()));
	}
};
BattleManager.playVictoryMe = function() {
	if (!($gameSwitches.value(19))){
		AudioManager.playMe($gameSystem.victoryMe());
	}
};


Window_BattleLog.prototype.displayAction = function(subject, item) {
    var numMethods = this._methods.length;
    if (DataManager.isSkill(item)) {
        if (item.message1) {
            this.push('addText', subject.name() + item.message1.format(item.name));
        }
        if (item.message2) {
            this.push('addText', item.message2.format(item.name));
        }
    } else {
        this.push('addText', TextManager.useItem.format(subject.name(), item.name));
    }
    if (this._methods.length === numMethods) {
        this.push('wait');
    }
};


	
	
	
})();