//=============================================================================
// 100CallSpine.js
//=============================================================================

/*:
 *
 * @help
 * 保存データ
 *
 *
 *
 *
 *
 *
 */





//========================================================
//                    [むぎ]アニメーション
//========================================================

function 待機(Call) {
    var ExpressionMapp = {
        0: "絶頂中",
        1: "絶頂大",
        2: "絶頂小",
        3: "通常"
    };
    var Expression = !CGSw ? "【待機】" + ExpressionMapp[Call] : (Call === "000" ? "000" : "【待機】" + Call);
    var Trak = 0;

    $gameScreen.spine(10).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 眉(Call) {
    var ExpressionMapp = { 0: "通常", 1: "怒り", 2: "困り" };
    var Expression;
    if (Call === "000") {
        Expression = "000";
    } else if (!isNaN(Number(Call))) {
        Expression = "【眉】" + (ExpressionMapp[Call] || Call);
    } else {
        Expression = "【眉】" + Call;
    }
    var Trak = 1;
    $gameScreen.spine(10).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 目(Call) {
    var ExpressionMapp = {
        0: "アヘ", 1: "半目", 2: "薄目", 3: "通常",
        4: "閉じ1", 5: "閉じ1涙", 6: "閉じ2", 7: "閉じ2涙", 8: "驚き"
    };
    var Expression;
    if (Call === "000") {
        Expression = "000";
    } else if (!isNaN(Number(Call))) {
        Expression = "【目】" + (ExpressionMapp[Call] || Call);
    } else {
        Expression = "【目】" + Call;
    }
    var Trak = 2;
    $gameScreen.spine(10).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 口(Call) {
    var ExpressionMapp = {
        0: "ねこ口", 1: "ねこ口開け", 2: "舌出し", 3: "舌出しよだれ",
        4: "舌出し笑", 5: "舌出し笑よだれ", 6: "閉じへの字", 7: "閉じ逆への字",
        8: "開け大", 9: "開け大よだれ", 10: "開け大笑", 11: "開け小",
        12: "開け笑", 13: "食いしばり", 14: "000"
    };
    var Expression;
    if (Call === "000") {
        Expression = "000";
    } else if (!isNaN(Number(Call))) {
        Expression = "【口】" + (ExpressionMapp[Call] || Call);
    } else {
        Expression = "【口】" + Call;
    }
    var Trak = 3;
    $gameScreen.spine(10).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 頬(Call) {
    var ExpressionMapp = { "0": "赤み小", "1": "赤み大" };
    var key = String(Call);
    var Expression;

    if (key === "000") {
        Expression = "000";
    } else if (ExpressionMapp.hasOwnProperty(key)) {
        Expression = "【ほほ】" + ExpressionMapp[key];
    } else {
        Expression = "【ほほ】" + key;
    }

    var Trak = 4;
    var spine10 = $gameScreen.spine(10);
    if (spine10) spine10.setAnimation(Trak, Expression, 'continue', true);

    var spine49 = $gameScreen.picture(49) && $gameScreen.spine(49);
    if (spine49) spine49.setAnimation(Trak, Expression, 'continue', true);

    return Expression;
}


function 汗(Call) {
    var ExpressionMapp = { 0: "大", 1: "小" };
    var Expression = !CGSw ? "【汗】" + ExpressionMapp[Call] : (Call === "000" ? "000" : "【汗】" + Call);
    var Trak = 5;
    $gameScreen.spine(10).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}



//========================================================
//                    [ゆき]アニメーション
//========================================================

function 待機2(Call) {
    var ExpressionMapp = {
        0: "絶頂中",
        1: "絶頂大",
        2: "絶頂小",
        3: "通常"
    };
    var Expression = !CGSw ? "【待機】" + ExpressionMapp[Call] : (Call === "000" ? "000" : "【待機】" + Call);
    var Trak = 0;

    $gameScreen.spine(11).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 眉2(Call) {
    var ExpressionMapp = { 0: "通常", 1: "怒り", 2: "困り" };
    var Expression;
    if (Call === "000") {
        Expression = "000";
    } else if (!isNaN(Number(Call))) {
        Expression = "【眉】" + (ExpressionMapp[Call] || Call);
    } else {
        Expression = "【眉】" + Call;
    }
    var Trak = 1;
    $gameScreen.spine(11).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 目2(Call) {
    var ExpressionMapp = {
        0: "アヘ", 1: "半目", 2: "薄目", 3: "通常",
        4: "閉じ1", 5: "閉じ1涙", 6: "閉じ2", 7: "閉じ2涙", 8: "驚き"
    };

    var Expression;
    if (Call === "000") {
        Expression = "000";
    } else if (!isNaN(Number(Call))) {
        Expression = "【目】" + (ExpressionMapp[Call] || Call);
    } else {
        Expression = "【目】" + Call;
    }
    var Trak = 2;
    $gameScreen.spine(11).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 口2(Call) {
    var ExpressionMapp = {
        0: "ねこ口", 1: "ねこ口開け", 2: "舌出し", 3: "舌出しよだれ",
        4: "舌出し笑", 5: "舌出し笑よだれ", 6: "閉じへの字", 7: "閉じ逆への字",
        8: "開け中", 9: "開け大", 10: "開け大よだれ", 11: "開け小",
        12: "開け笑", 13: "開け笑大", 14: "食いしばり", 15: "000"
    };

    var Expression;
    if (Call === "000") {
        Expression = "000";
    } else if (!isNaN(Number(Call))) {
        Expression = "【口】" + (ExpressionMapp[Call] || Call);
    } else {
        Expression = "【口】" + Call;
    }
    var Trak = 3;
    $gameScreen.spine(11).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 頬2(Call) {
    var ExpressionMapp = { 0: "赤み小", 1: "赤み大" };
    var Expression = (Call === "000") ? "000" :
                     (Call in ExpressionMapp) ? "【ほほ】" + ExpressionMapp[Call] : "【ほほ】" + Call;
    var Trak = 4;

    $gameScreen.spine(11).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}

function 汗2(Call) {
    var ExpressionMapp = { 0: "大", 1: "小" };
    var Expression = !CGSw ? "【汗】" + ExpressionMapp[Call] : (Call === "000" ? "000" : "【汗】" + Call);
    var Trak = 5;

    $gameScreen.spine(11).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    return Expression;
}



//========================================================
//                    [共通]アニメーション
//========================================================

function 表情統合(Call, Trak, prefix) {
    var baseName = String(Call[1]);
    var Expression = (baseName === "000") ? "000" : prefix + baseName;
    var target = Call[0] === 0 ? 10 : 11;

    $gameScreen.spine(target).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) {
        $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    }

    return Expression;
}
function 合成(Call)   { return 表情統合(Call, 10,  "【合成】"); }
function 合成1(Call)   { return 表情統合(Call, 20,  "【合成】"); }
function 合成2(Call)  { return 表情統合(Call, 11,  "【合成】"); }
function 合成3(Call)  { return 表情統合(Call, 12,  "【合成】"); }
function 合成4(Call)  { return 表情統合(Call, 13,  "【合成】"); }
function 合成5(Call)  { return 表情統合(Call, 14, "【合成】"); }
function 合成6(Call)  { return 表情統合(Call, 15, "【合成】"); }
function 合成7(Call)  { return 表情統合(Call, 16, "【合成】"); }
function 合成8(Call)  { return 表情統合(Call, 17, "【合成】"); }
function 合成9(Call)  { return 表情統合(Call, 18, "【合成】"); }
function 合成10(Call) { return 表情統合(Call, 19, "【合成】"); }

function 目線(Call) { return 表情統合(Call, 6, "【目線】"); }

function ACall(Call) {
    var NNh  = Call[0];
    var Sw22 = $gameSwitches.value(22);

    if(NNh === 0) {
        var Pic    = Call[1];
        var Trc    = Call[2];
        var Anime  = Call[3];

        $gameScreen.spine(Pic).setAnimation(Trc, Anime, 'continue', true);
    } else {
        var Pic    = Call[1];
        var Trc    = Call[2];
        var Anime  = Call[3];
        var Anime2 = Call[4];

        if(Sw22) {
            Anime  = Anime + "/timeScale=2";
            $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2], 'sequential', 'continue', true);
		} else {
            $gameScreen.spine(Pic).setAnimation(Trc, [Anime, Anime2], 'sequential', 'continue', true);
        }
    }
}



//========================================================
//                    呼び出し基礎
//========================================================

function 表情適用(Call, Trak, 種別ラベル, マッピング) {
    var baseName = !CGSw ? マッピング[Call] : Call;
    var Expression = (baseName === "000") ? "000" : `【${種別ラベル}】${baseName}`;

    $gameScreen.spine(10).setAnimation(Trak, Expression, 'continue', true);
    if ($gameScreen.picture(49)) {
        $gameScreen.spine(49).setAnimation(Trak, Expression, 'continue', true);
    }

    return Expression;
}

//========================================================
//                    立ち絵表示
//========================================================

function 出現(CallCharacter) {

    if(CallCharacter === "むぎ") {
        $gameScreen.Picture_Fade(10, 255, 1);
        $gameScreen.Picture_Fade(11, 0, 1);
    }

    if(CallCharacter === "ゆき") {
        $gameScreen.Picture_Fade(10, 0, 1);
        $gameScreen.Picture_Fade(11, 255, 1);
    }

    if(CallCharacter === "無し") {
        $gameScreen.Picture_Fade(10, 0, 1);
        $gameScreen.Picture_Fade(11, 0, 1);
    }
}


function 立ち絵表示(CallCharacter) {

    if(CallCharacter === "むぎ") {
       CGSw       = false;
       NrCall     = "むぎ";
       立ち絵       = [0,"むぎ"];
    }

    if(CallCharacter === "ゆき") {
       CGSw       = false;
       NrCall     = "ゆき";
       立ち絵 = [0,"ゆき"];
    }

    if(CallCharacter === "双子") {
        var NSpine  = [10, "姉むぎ立ち絵", 50, 25, -30];
        var NSpine2 = [11, "妹ゆき立ち絵", 50, 520, -30];
        CGSw       = false;

        var MPic   = NSpine[0];
        var MName  = NSpine[1];
        var MScale = NSpine[2];
        var MXx    = NSpine[3];
        var MYy    = NSpine[4];

        var YPic   = NSpine2[0];
        var YName  = NSpine2[1];
        var YScale = NSpine2[2];
        var YXx    = NSpine2[3];
        var YYy    = NSpine2[4];

        $gameScreen.showPicture(MPic, "", 0, MXx, MYy, MScale, MScale, 255,0);
        $gameScreen.showPicture(YPic, "", 0, YXx, YYy, YScale, YScale, 255,0);

        $gameScreen.spine(MPic).setSkeleton(MName)
        .setAnimation(0, "【待機】通常")
        .setAnimation(1, "000")
        .setAnimation(2, "000")
        .setAnimation(3, "000")
        .setAnimation(4, "000")
        .setAnimation(5, "000")
        .setAnimation(6, "000")
        .setAnimation(7, "000")
        .setAnimation(8, "000")
        .setAnimation(9, "000")
        .setAnimation(10, "000")
		.setMix(0.3);

        $gameScreen.spine(YPic).setSkeleton(YName)
        .setAnimation(0, "【待機】通常")
        .setAnimation(1, "000")
        .setAnimation(2, "000")
        .setAnimation(3, "000")
        .setAnimation(4, "000")
        .setAnimation(5, "000")
        .setAnimation(6, "000")
        .setAnimation(7, "000")
        .setAnimation(8, "000")
        .setAnimation(9, "000")
        .setAnimation(10, "000")
        .setMix(0.3); 
        
        スキン呼び出し("むぎ");
        スキン呼び出し("ゆき");
    }
}