//=============================================================================
// 100InfoCall.js
//=============================================================================

/*:
 *
 * @help
 * ヒント保存データ
 * 
 * 
 * Spineトラック
 * 
 * 0.待機/タグ
 * 1.小タグ
 * 2.選択
 * 3.チェック1
 * 4.チェック2
 * 5.チェック3
 * 6.チェック4
 * 7.チェック5
 * 8.チェック6
 * 9.チェック7
 * 10.チェック8
 * 11.チェック9
 * 12.チェック10
 * 13.チェック11
 * 14.選択2
 * 
 */

(function() {
    'use strict';

    let HintMap = {
        "noname" : ["000","000"],
        "HB1"  : ["選択1","タグ1","タグ12"],
        "HB2"  : ["選択2","タグ2","タグ22"],
        "HB3"  : ["選択3","タグ3","タグ32"],
        "HB4"  : ["選択4"],
        "HB5"  : ["選択5","1-1"],
        "HB6"  : ["選択6","1-2"],
        "HB7"  : ["選択7","1-3"],
        "HB8"  : ["選択8","2-1"],
        "HB9"  : ["選択9","2-2"],
        "HB10" : ["選択10","2-3"],
        "HB11" : ["選択11","2-4"],
        "HB12" : ["選択12","3-1"],
        "HB13" : ["選択13","3-2"],
        "HB14" : ["選択14","3-3"],
        "HB15" : ["選択15","3-4"],
        "HB16" : ["選択16","3-5"],
        "HB17" : ["条件1",  "000"],
        "HB18" : ["条件2",  "000"],
        "HB19" : ["条件3",  "000"],
        "HB20" : ["条件4",  "000"],
        "HB21" : ["条件5",  "000"],
        "HB22" : ["条件6",  "000"],
        "HB23" : ["条件7",  "000"],
        "HB24" : ["条件8",  "000"],
        "HB25" : ["条件9",  "000"],
        "HB26" : ["条件10", "000"],
        "HB27" : ["条件11", "000"]
    };

    window.ヒント呼び出し = async function() {
        SceneManager._scene._messageWindow.pause = false;
        SceneManager._scene._messageWindow.terminateMessage();
        イベントチェック("文章禁止");
        $gameSwitches.setValue(28,false);
        $gameVariables.setValue(50,911);
        $gameSwitches.setValue(71,true);

        $gameScreen.startFadeOut(30);
        await wait(45);

        スパイン = "ヘルプ";

        await wait(15);

        アニメ更新 = [1,200,0,"出現","出現2"];
        $gameScreen.startFadeIn(30);
        await wait(30);
        $gameVariables.setValue(50,0);
    };

    window.ヒント選択2 = async function() {
        var Call  = $gameVariables.value(28);
        var Anime = HintMap[Call];

        アニメ更新 = [0,200,14,Anime[0]];
        
        if(Anime === "000") {
            return;
        }

        $gameSwitches.setValue(81,true);
    };

    window.ヒント選択 = async function() {
        var Call  = $gameVariables.value(28);
        var Anime = HintMap[Call];

        アニメ更新 = [0,200,2,Anime[0]];
        
        if(Anime === "000") {
            return;
        }

        $gameSwitches.setValue(81,true);
    };

    window.ヒント実行 = async function() {
        $gameVariables.setValue(50,911);
        var Call  = $gameVariables.value(28);
        var Anime = HintMap[Call];
        アニメ更新 = [0,200,2,"000"];

        if(["HB1", "HB2", "HB3"].includes(Call)) {
            アニメ更新 = [1,200,0,Anime[1],Anime[2]];
            アニメ更新 = [0,200,1,"000"];
        } else if(Call === "HB4") {
            ヒント終了();
            return;
        } else {
            if(["HB14", "HB15", "HB16"].includes(Call)) {
                ヒントチェック(Call);
            } else {
                for (var i = 3; i <= 13; i++) {
                    アニメ更新 = [0,200,i,"000"];
                }
            }
            アニメ更新 = [0,200,1,Anime[1]];
        }

        $gameSwitches.setValue(81,true);
        await wait(15)
        $gameVariables.setValue(50,0);
    };

    window.ヒント終了 = async function() {
        $gameVariables.setValue(50,911);
        $gameSwitches.setValue(71,false);

        $gameScreen.startFadeOut(30);
        await wait(45);

        ピクチャ消去 = [0,200];

        await wait(15);

        $gameScreen.startFadeIn(30);
        await wait(30);
        $gameVariables.setValue(50,0);
        $gameSwitches.setValue(28,true);
        イベントチェック("文章許可");
    };

    window.ヒントチェック = async function(Call) {
        if($gameSwitches.value(20)) return;
        var HStNum = [];

        var val122 = $gameVariables.value(122); //日数

        var Vsw12 = $gameSwitches.value(12); //むぎ恋人
        var Vsw13 = $gameSwitches.value(13); //ゆき恋人

        //管理スイッチ
        var Vsw122 = $gameSwitches.value(122);
        var Vsw123 = $gameSwitches.value(123);
        var Vsw124 = $gameSwitches.value(124);
        var Vsw125 = $gameSwitches.value(125);
        var Vsw126 = $gameSwitches.value(126);
        var Vsw127 = $gameSwitches.value(127);
        var Vsw128 = $gameSwitches.value(128);
        var Vsw129 = $gameSwitches.value(129);
        var Vsw130 = $gameSwitches.value(130);
        var Vsw131 = $gameSwitches.value(131);
        var Vsw132 = $gameSwitches.value(132);
        var Vsw133 = $gameSwitches.value(133);
        var Vsw134 = $gameSwitches.value(134);
        var Vsw135 = $gameSwitches.value(135);
        var Vsw136 = $gameSwitches.value(136);
        var Vsw137 = $gameSwitches.value(137);
        var Vsw138 = $gameSwitches.value(138);
        var Vsw139 = $gameSwitches.value(139);
        var Vsw140 = $gameSwitches.value(140);
        var Vsw141 = $gameSwitches.value(141);
        var Vsw142 = $gameSwitches.value(142);
        var Vsw143 = $gameSwitches.value(143);
        var Vsw144 = $gameSwitches.value(144);
        var Vsw145 = $gameSwitches.value(145);
        var Vsw146 = $gameSwitches.value(146);

        if (Call === "HB14") {
            if (Vsw128) {
                HStNum.push("チェック1");
            } else {
                HStNum.push("000");
            } //Mお風呂1

            if (Vsw129) {
                HStNum.push("チェック2");
            } else {
                HStNum.push("000");
            } //Mお風呂2

            if (Vsw130) {
                HStNum.push("チェック3");
            } else {
                HStNum.push("000");
            } //Mお風呂3

            if (Vsw122) {
                HStNum.push("チェック4");
            } else {
                HStNum.push("000");
            } //M好感度1

            if (Vsw123) {
                HStNum.push("チェック5");
            } else {
                HStNum.push("000");
            } //M好感度2

            if (Vsw137) {
                HStNum.push("チェック6");
            } else {
                HStNum.push("000");
            } //騎乗位1

            if (Vsw134) {
                HStNum.push("チェック7");
            } else {
                HStNum.push("000");
            } //手コキ1

            if (Vsw135) {
                HStNum.push("チェック8");
            } else {
                HStNum.push("000");
            } //手コキ2

            if (Vsw136) {
                HStNum.push("チェック9");
            } else {
                HStNum.push("000");
            } //手コキ発情

            if (Vsw138) {
                HStNum.push("チェック10");
            } else {
                HStNum.push("000");
            } //騎乗位2

            if (Vsw139) {
                HStNum.push("チェック11");
            } else {
                HStNum.push("000");
            } //騎乗位3
        }

        if (Call === "HB15") {
            if (Vsw131) {
                HStNum.push("チェック1");
            } else {
                HStNum.push("000");
            } //Yお風呂1

            if (Vsw132) {
                HStNum.push("チェック2");
            } else {
                HStNum.push("000");
            } //Yお風呂2

            if (Vsw133) {
                HStNum.push("チェック3");
            } else {
                HStNum.push("000");
            } //Yお風呂3

            if (Vsw125) {
                HStNum.push("チェック4");
            } else {
                HStNum.push("000");
            } //Y好感度1

            if (Vsw126) {
                HStNum.push("チェック5");
            } else {
                HStNum.push("000");
            } //Y好感度2

            if (Vsw143) {
                HStNum.push("チェック6");
            } else {
                HStNum.push("000");
            } //バック スイッチ13解放

            if (Vsw140) {
                HStNum.push("チェック7");
            } else {
                HStNum.push("000");
            } //パイズリ1

            if (Vsw141) {
                HStNum.push("チェック8");
            } else {
                HStNum.push("000");
            } //パイズリ2

            if (Vsw142) {
                HStNum.push("チェック9");
            } else {
                HStNum.push("000");
            } //パイズリ3

            if (Vsw144) {
                HStNum.push("チェック10");
            } else {
                HStNum.push("000");
            } //バック2

            if (Vsw145) {
                HStNum.push("チェック11");
            } else {
                HStNum.push("000");
            } //バック3
        }

        if (Call === "HB16") {
            if (val122 <= 30 || Vsw146) {
                HStNum.push("チェック1");
            } else {
                HStNum.push("000");
            } //日数30日以内 または スイッチ146

            if (Vsw146 || (!Vsw12 && !Vsw13)) {
                HStNum.push("チェック2");
            } else {
                HStNum.push("000");
            } //スイッチ146 または 両方恋人でない

            if (Vsw146 || Vsw123) {
                HStNum.push("チェック3");
            } else {
                HStNum.push("000");
            } //スイッチ146 または 123

            if (Vsw146 || Vsw126) {
                HStNum.push("チェック4");
            } else {
                HStNum.push("000");
            } //スイッチ146 または 126

            while (HStNum.length < 11) {
                HStNum.push("000");
            }
        }
        var Track = 3;
        for (var i = 0; i < HStNum.length; i++) {
            アニメ更新 = [0, 200, Track, HStNum[i]];
            Track++;
        }
    };


    window.イベントチェック = async function(Call) {
        if (Call === "文章禁止") {
            window._disableMessage = true;
        } else if (Call === "文章許可") {
            window._disableMessage = false;
        }
    };

    if (!window._originalCommand101) {
        window._disableMessage = false;
        window._originalCommand101 = Game_Interpreter.prototype.command101;
        Game_Interpreter.prototype.command101 = function(params) {
            if (window._disableMessage) {
                while (this._index < this._list.length) {
                    const command = this._list[this._index];
                    if ([101, 401, 102, 103, 104, 105].includes(command.code)) {
                        this._index++;
                    } else {
                        break;
                    }
                }
                return true;
            }
            return window._originalCommand101.call(this, params);
        };
    }

    window.wait = function(frames) {
        return new Promise(resolve => {
            setTimeout(resolve, frames / 60 * 1000);
        });
    };
})();
