//=============================================================================
// 100SaveLoad.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc セーブ・ロード画面に関連する処理をまとめたスクリプトです。
 * @author 
 *
 * @help
 * 本プラグインは、セーブ／ロード画面に関する演出やデータの割当処理を行います。
 *
 * プラグインコマンドはありません。
 * 以下の関数は全てイベントの「スクリプト」コマンドから
 * 関数名(); と記述することで実行可能です。
 *
 * - SLセットアップ();
 * - SL選択();
 * - SLページ();
 * - SLページ選択();
 * - SL立ち絵();
 * - SLスキン();
 * - SLデータ();
 * - SL情報割当();
 * - SLセーブデータログ();
 */

(function() {

    // --------------------------------------------------------
    // マッピング配列
    // --------------------------------------------------------
    var mappings = [
        { id: 181, idx: 0, src: "arrayA" }, { id: 182, idx: 3, src: "arrayA" },
        { id: 183, idx: 6, src: "arrayA" }, { id: 184, idx: 21, src: "arrayA" },
        { id: 185, idx: 22, src: "arrayA" }, { id: 186, idx: 0, src: "arrayB" },
        { id: 187, idx: 3, src: "arrayB" }, { id: 188, idx: 6, src: "arrayB" },
        { id: 189, idx: 21, src: "arrayB" }, { id: 190, idx: 22, src: "arrayB" }
    ];

    var map = {
        'ファイルB': 1, 'ファイルB2': 2, 'ファイルB3': 3, 'ファイルB4': 4,
        'ファイルB5': 5, 'ファイルB6': 6, 'ファイルB7': 7, 'ファイルB8': 8,
        'ファイルB9': 9, 'ファイルB10': 10
    };

    // --------------------------------------------------------
    // 関数群
    // --------------------------------------------------------

    window.SLセットアップ = function() {
        Text          = 181; // 初期値
        Pic           = 101; // ピクチャID
        SaveNum       = 1;
        SaveX         = 2;
        SaveY         = 3;
        iNum          = 0;
        i             = 80;
        isFileMissing = false;

        if (utakata && utakata.CommonSaveManager) {
            utakata.CommonSaveManager.load();
        }

        for (let i = 191; i <= 210; i++) {
            $gameVariables.setValue(i,"　");
        }

        $gameVariables.setValue(47,1);
        $gameVariables.setValue(2,1);

        $gameScreen.startFadeOut(30);

        setTimeout(function () {
            スパイン  = "セーブ";
            スパイン2 = "セーブ2";

            setTimeout(function () {
                if($gameVariables.value(45) === 0) {
                    アニメ呼び出し = [0,100,0,"000"];
                } else {
                    アニメ呼び出し = [0,100,0,"ロード"];
                }

                var Anime = "ページ" + $gameVariables.value(47);
                アニメ呼び出し2 = [0,100,1,Anime];

                $gameScreen.spine(200).setAnimation(0, "透明");
                $gameScreen.spine(200).setAnimation(1, "000");

                while (Text < 221) {
                    NJ.セーブロード.ピクチャ()
                    $gameScreen.dTextRealTime = true;
                    $gameScreen.dTextAlign = XX; //0で左、1で中央、2で右
                    $gameScreen.setDTextPicture("　　　　　　　　　　", Ts);
                    $gameScreen.setDTextPicture("　" + "\\v[" + Text + "]" + "　" , Ts);
                    $gameScreen.showPicture(Pic,0,0,X,Y,100,100,255,0)
                    Pic++;
                    Text++;
                    NJ.セーブロード.ピクチャ2()
                }

                while (Text < 231) {
                    NJ.セーブロード.ピクチャ3()
                    $gameScreen.dTextRealTime = true;
                    $gameScreen.dTextAlign = 1;
                    $gameScreen.setDTextPicture("　　　　　", Ts);
                    $gameScreen.setDTextPicture("　" + "\\v[" + Text + "]" + "　" , Ts);
                    $gameScreen.showPicture(Pic,0,0,X,Y,100,100,255,0)
                    Pic++;
                    Text++;
                }

                $gameVariables.setValue(28,"ファイルB");

                SLデータ();
                NJ.セーブロード.セットアップ()
                SL情報割当();
                SL立ち絵();
                SL選択();
                $gameScreen.showPicture(192,"背景/セーブマスク",1,640,360,100,100,255,0);
                $gameScreen.showPicture(193,"背景/セーブマスク2",1,640,360,100,100,255,0);

                var interpreter = new Game_Interpreter();
                interpreter.pluginCommand("SETMASK", ["190", "192"]);
                interpreter.pluginCommand("SETMASK", ["191", "193"]);

                setTimeout(function () {
                    $gameScreen.startFadeIn(30);
                    setTimeout(function () {
                        if($gameVariables.value(45) === 0) {
                            セーブセリフ();
                        } else {
                            ロードセリフ();
                        }
                        $gameSwitches.setValue(35, true);
                    }, 500);
                }, 500);
            }, 100);
        }, 500);
    };

    window.SL選択 = function() {
        var name = $gameVariables.value(28);
        var idx = map[name] || 1;
        $gameVariables.setValue(2, idx);

        var animName = '選択' + idx;
        $gameScreen.spine(200).setAnimation(10, animName, 'continue', true);

        var dataObj = window['セーブデータ' + idx] || {};

        var arrayA = Array.isArray(dataObj.DataC) ? dataObj.DataC : [];
        var arrayB = Array.isArray(dataObj.DataD) ? dataObj.DataD : [];

        for (var i = 0; i < mappings.length; i++) {
            var e = mappings[i];
            var srcArr = (e.src === "arrayA" ? arrayA : arrayB);
            var v = srcArr[e.idx];
            $gameVariables.setValue(e.id, v !== undefined && v !== null ? v : "　");
        }

        var boneIndexMap = [1,2,4,5,7,8,1,2,4,5,7,8];

        var idxA = 0, idxB = 1;
        var BoneN = 0;
        var Gagem = 521;
        var GageM = 522;

        while (BoneN < 6) {
            var s1 = BoneN <= 2 ? (arrayA[boneIndexMap[idxA]] || 0) : (arrayB[boneIndexMap[idxA]] || 0);
            var s2 = BoneN <= 2 ? (arrayA[boneIndexMap[idxB]] || 0) : (arrayB[boneIndexMap[idxB]] || 0);

            $gameVariables.setValue(Gagem,s1);
            $gameVariables.setValue(GageM,s2);

            Gagem+=2;
            GageM+=2;
            BoneN++;
            idxA += 2;
            idxB += 2;
        }

        SLスキン();
        $gameSwitches.setValue(84, true);
    };

    window.SLページ = function() {
        var map = {
            'ファイルB11': [1,11],
            'ファイルB12': [2,12],
            'ファイルB13': [3,13],
            'ファイルB14': [4,14],
            'ファイルB15': [5,15],
            'ファイルB16': [6,16],
            'ファイルB17': [7,17],
            'ファイルB18': [8,18],
            'ファイルB19': [9,19],
            'ファイルB20': [10,20]
        };

        var name = $gameVariables.value(28);
        var Num = map[name];
        var AnimeName = '選択' + Num[1];

        $gameScreen.spine(100).setAnimation(10, AnimeName, 'continue', true);
        $gameSwitches.setValue(84, true);
    };

    window.SLページ選択 = function() {
        var map = {
            'ファイルB11': [1,11],
            'ファイルB12': [2,12],
            'ファイルB13': [3,13],
            'ファイルB14': [4,14],
            'ファイルB15': [5,15],
            'ファイルB16': [6,16],
            'ファイルB17': [7,17],
            'ファイルB18': [8,18],
            'ファイルB19': [9,19],
            'ファイルB20': [10,20]
        };

        var name = $gameVariables.value(28);
        var Num = map[name][0];
        var AnimeName = 'ページ' + Num;

        $gameScreen.spine(100).setAnimation(1, AnimeName, 'continue', true);
        $gameSwitches.setValue(84, true);

        $gameVariables.setValue(47,Num);
        $gameVariables.setValue(28,"ファイルB");

        setTimeout(function () {
            SLデータ();
            SL情報割当();
            SL選択();
        }, 0);
    };

    window.SL立ち絵 = function() {
        var NSpine  = [190, "姉むぎ立ち絵", 25, -75, 110];
        var NSpine2 = [191, "妹ゆき立ち絵", 25, -70, 385];

        var MPic   = NSpine[0];
        var MName  = NSpine[1];
        var MScale = NSpine[2];
        var MXx    = NSpine[3];
        var MYy    = NSpine[4];

        var YPic   = NSpine2[0];
        var YName  = NSpine2[1];
        var YScale = NSpine2[2];
        var YXx    = NSpine2[3];
        var YYy    = NSpine2[4];

        $gameScreen.showPicture(MPic, "", 0, MXx, MYy, MScale, MScale, 255,0);
        $gameScreen.showPicture(YPic, "", 0, YXx, YYy, YScale, YScale, 255,0);

        $gameScreen.spine(MPic).setSkeleton(MName)
        .setAnimation(0, "000")
        .setAnimation(1, "000")
        .setAnimation(2, "000")
        .setAnimation(3, "000")
        .setAnimation(4, "000")
        .setAnimation(5, "000")
        .setAnimation(6, "000")
        .setAnimation(7, "000")
        .setAnimation(8, "000")
        .setAnimation(9, "000")
        .setAnimation(10, "000");

        $gameScreen.spine(YPic).setSkeleton(YName)
        .setAnimation(0, "000")
        .setAnimation(1, "000")
        .setAnimation(2, "000")
        .setAnimation(3, "000")
        .setAnimation(4, "000")
        .setAnimation(5, "000")
        .setAnimation(6, "000")
        .setAnimation(7, "000")
        .setAnimation(8, "000")
        .setAnimation(9, "000")
        .setAnimation(10, "000");

        setTimeout(function () {
            SLスキン();
        }, 0);
    };

    window.SLスキン = function() {
        var fs = require("fs");
        var slot = ($gameVariables.value(47) - 1) * 10 + $gameVariables.value(2);
        var path = StorageManager.localFilePath(slot);

        var picM = 190, picY = 191;
        var t1 = 50, t2 = 51, t3 = 52, t5 = 54;
        var fade = 255;

        var skinM = [], skinY = [];

        if (fs.existsSync(path)) {
            try {
                var raw = fs.readFileSync(path, "utf8");
                var vars = JsonEx.parse(LZString.decompressFromBase64(raw)).variables._data;
                skinM = Array.isArray(vars[116]) ? vars[116] : [];
                skinY = Array.isArray(vars[117]) ? vars[117] : [];
            } catch (e) {
                fade = 0;
            }
        } else {
            fade = 0;
        }

        if (fade === 255) {
            var m0 = skinM[0] || "", m3 = skinM[3] || "";
            var y0 = skinY[0] || "", y3 = skinY[3] || "";

            $gameScreen.spine(picM).setAnimation(t2, /私服|無し/.test(m0) ? "000" : "ショーパン消し", "continue", true);
            $gameScreen.spine(picM).setAnimation(t1, m0.indexOf("メイド") !== -1 ? "下着消し" : "000", "continue", true);
            $gameScreen.spine(picM).setAnimation(t5, m3.indexOf("首輪") !== -1 ? "首輪用" : "000", "continue", true);
            $gameScreen.spine(picM).setAnimation(t3, /スク水|ビキニ|バスタオル/.test(m0) ? "下着消し2" : "000", "continue", true);

            $gameScreen.spine(picY).setAnimation(t1, y0.indexOf("メイド") !== -1 ? "下着消し" : "000", "continue", true);
            $gameScreen.spine(picY).setAnimation(t5, y3.indexOf("首輪") !== -1 ? "首輪用" : "000", "continue", true);
            $gameScreen.spine(picY).setAnimation(t3, /スク水|ビキニ|バスタオル/.test(y0) ? "下着消し2" : "000", "continue", true);

            if (skinM.length >= 6) $gameScreen.spine(picM).setSkin.apply($gameScreen.spine(picM), skinM);
            if (skinY.length >= 6) $gameScreen.spine(picY).setSkin.apply($gameScreen.spine(picY), skinY);
        }

        for (var i = picM; i <= picY; i++) {
            if ($gameScreen.Picture_Fade) {
                $gameScreen.Picture_Fade(i, fade, 1);
            }
        }
    };

    window.SLデータ = function() {
        var fs = require("fs");
        var セーブ開始 = ($gameVariables.value(47) - 1) * 10 + 1;
        var セーブ終了 = $gameVariables.value(47) * 10;

        for (var slot = 1; slot <= 10; slot++) {
            window["セーブデータ" + slot] = {
                DataA: null,
                DataB: null,
                DataC: [],
                DataD: [],
                DataE: []
            };
        }

        for (var i = セーブ開始; i <= セーブ終了; i++) {
            var path = StorageManager.localFilePath(i);
            if (!fs.existsSync(path)) continue;

            try {
                var raw = fs.readFileSync(path, "utf8");
                var decompressed = LZString.decompressFromBase64(raw);
                if (!decompressed) continue;

                var parsed = JsonEx.parse(decompressed);
                var vars = parsed.variables._data;

                var slotIndex = i - セーブ開始 + 1;
                var slotData = {
                    DataA: Array.isArray(vars[116]) ? vars[116].slice() : null,
                    DataB: Array.isArray(vars[117]) ? vars[117].slice() : null,
                    DataC: [],
                    DataD: [],
                    DataE: [vars[121] || 0, vars[122] || 0, vars[123] || 0]
                };

                for (var j = 61; j <= 83; j++) {
                    slotData.DataC.push(vars[j] != null ? vars[j] : 0);
                }
                for (var j = 84; j <= 106; j++) {
                    slotData.DataD.push(vars[j] != null ? vars[j] : 0);
                }

                window["セーブデータ" + slotIndex] = slotData;

            } catch (e) {
            }
        }
    };

    window.SL情報割当 = function() {
        var page = $gameVariables.value(47);
        var variableId = 191;
        var picVarId = 221;
        var slotNumber = (page - 1) * 10 + 1;

        for (var i = 1; i <= 10; i++) {
            var data = window["セーブデータ" + i];

            $gameVariables.setValue(picVarId++, slotNumber);

            if (data && Object.prototype.toString.call(data.DataE) === "[object Array]") {
                var gold = data.DataE[0] != null ? data.DataE[0] : "　";
                var days = data.DataE[1] != null ? data.DataE[1] : "　";
                var time = data.DataE[2] != null ? data.DataE[2] : "　";

                $gameVariables.setValue(variableId++, time);
                $gameVariables.setValue(variableId++, gold);
                $gameVariables.setValue(variableId++, days);
            } else {
                $gameVariables.setValue(variableId++, "　");
                $gameVariables.setValue(variableId++, "　");
                $gameVariables.setValue(variableId++, "　");
            }

            slotNumber++;
        }
    };

    window.SLセーブデータログ = function() {
        for (var i = 1; i <= 10; i++) {
            var key = "セーブデータ" + i;
            var data = window[key];
            console.log("[" + key + "]", data);
        }
    };

    window.SLセーブ = async function() {
        セーブセリフ2();
        var SLNum = ($gameVariables.value(47) - 1) * 10 + $gameVariables.value(34);

        var SLslot = [];

        var TimeG = new Date();
        var Ye = TimeG.getFullYear();
        var Mo = TimeG.getMonth() + 1;
        var Da = TimeG.getDate();

        SLslot.push($gameSystem.getSavePlayTime());//プレイ時間
        SLslot.push((Ye)+" "+(Mo)+"."+(Da));//セーブ日数

        $gameVariables.setValue(123, SLslot);
        $gameVariables.setValue(48, SLNum)
        await wait(30);
        $gameMap._interpreter.pluginCommand("SaveCommand", ["save", "[48]"]);
        NJ.セーブロード.ページ2()
        SLデータ();
        SLスキン();
        NrSpineGage.forceUpdateAll();
    }
})();
