//=============================================================================
// AutoLineBreak.js
//=============================================================================

/*:
 * @target MV
 * @plugindesc 自動改行プラグインv1.0.0
 * @author NJ
 *
 * @param MaxCharsPerLine
 * @type number
 * @default 20
 *
 * @param InsertAutoBreakSpace
 * @type boolean
 * @default true
 * @desc 自動改行時に全角スペースを入れるか（ON:入れる / OFF:入れない）
 *
 * @help
 * バージョン
 * v1.0.0 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

(function () {
    const parameters = PluginManager.parameters('AutoLineBreak');
    const maxChars = Number(parameters['MaxCharsPerLine'] || 20);
    const insertAutoBreakSpace = String(parameters['InsertAutoBreakSpace']) === 'true';
    const forbiddenStartChars = ['）', '」', '』', '】', '、', '。', '…'];

    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function () {
        _Scene_Boot_start.call(this);

        let _nwActive = false;

        const _Window_Message_convertEscapeCharacters = Window_Message.prototype.convertEscapeCharacters;
        Window_Message.prototype.convertEscapeCharacters = function (text) {
            _nwActive = /\\[Nn][Ww]\[/.test($gameMessage.allText());
            return _Window_Message_convertEscapeCharacters.call(this, text);
        };

        const _Window_Message_drawTextEx = Window_Message.prototype.drawTextEx;
        Window_Message.prototype.drawTextEx = function (text, x, y) {
            this._drawStartX = x;
            this._wasNewLine = false;
            this._justAutoBreak = false;
            return _Window_Message_drawTextEx.call(this, text, x, y);
        };

        const _Window_Message_processNormalCharacter = Window_Message.prototype.processNormalCharacter;
        Window_Message.prototype.processNormalCharacter = function (textState) {
            if (!this._charCount) this._charCount = 0;

            if (_nwActive && this._wasNewLine && this._justAutoBreak && insertAutoBreakSpace) {
                const spaceWidth = this.textWidth("　");
                this.contents.drawText("　", textState.x, textState.y, spaceWidth, this.lineHeight(), 'left');
                textState.x += spaceWidth;
            }

            this._wasNewLine = false;
            this._justAutoBreak = false;

            const currentChar = textState.text[textState.index];
            const nextChar = textState.text[textState.index + 1];

            if (currentChar === '\n') {
                this._charCount = 0;
                this._wasNewLine = true;
                this._justAutoBreak = false;
            } else if (currentChar !== '\r' && currentChar !== '\x1b') {
                this._charCount++;
            }

            if (this._charCount >= maxChars) {
                if (!forbiddenStartChars.includes(nextChar)) {
                    textState.text = textState.text.slice(0, textState.index + 1) + '\n' + textState.text.slice(textState.index + 1);
                    this._charCount = 0;
                    this._wasNewLine = true;
                    this._justAutoBreak = true;
                }
            }

            _Window_Message_processNormalCharacter.call(this, textState);
        };

        const _Window_Message_startMessage = Window_Message.prototype.startMessage;
        Window_Message.prototype.startMessage = function () {
            this._charCount = 0;
            this._wasNewLine = false;
            _nwActive = false;
            _Window_Message_startMessage.call(this);
        };

        const _Window_Message_newPage = Window_Message.prototype.newPage;
        Window_Message.prototype.newPage = function (textState) {
            this._charCount = 0;
            this._wasNewLine = false;
            _Window_Message_newPage.call(this, textState);
        };

        const _Window_Message_processNewLine = Window_Message.prototype.processNewLine;
        Window_Message.prototype.processNewLine = function (textState) {
            this._charCount = 0;
            this._wasNewLine = true;
            _Window_Message_processNewLine.call(this, textState);
        };

    };
})();
