//=============================================================================
// NrSpineBoneMemory.js
//=============================================================================

/*:
 * @plugindesc マップに戻った時、スイッチがONならSpineにsetBoneを適応するプラグイン v1.0.0
 * @author NJ
 *
 * @param PictureSettings
 * @text ピクチャ別スパイン骨設定
 * @type struct<PictureSetting>[]
 * @default []
 *
 * @help
 * バージョン:
 * v1.0.0 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

/*~struct~PictureSetting:
 * @param PictureId
 * @type number
 * @text ピクチャID
 *
 * @param SwitchId
 * @type switch
 * @text 適用スイッチID
 *
 * @param BoneList
 * @text ボーン設定リスト
 * @type struct<BoneSetting>[]
 */

/*~struct~BoneSetting:
 * @param BoneName
 * @type string
 * @text ボーン名
 *
 * @param X
 * @type number
 * @text X座標(px)
 *
 * @param Y
 * @type number
 * @text Y座標(px)
 *
 * @param Rotation
 * @type string
 * @text 回転(°)
 * @desc マイナス角度を許容（例：-45）
 *
 * @param Duration
 * @type number
 * @text 補間時間(フレーム)
 * @default 0
 *
 * @param ScreenCoord
 * @type boolean
 * @text スクリーン座標を使用
 * @default true
 */

(() => {
    const parameters = PluginManager.parameters('NrSpineBoneMemory');
    const pictureSettings = JSON.parse(parameters['PictureSettings'] || '[]')
        .map(p => JSON.parse(p))
        .map(obj => ({
            pictureId: Number(obj.PictureId),
            switchId: Number(obj.SwitchId),
            bones: (JSON.parse(obj.BoneList) || []).map(b => {
                const bone = JSON.parse(b);
                return {
                    name: String(bone.BoneName),
                    x: Number(bone.X),
                    y: Number(bone.Y),
                    rotation: parseFloat(bone.Rotation),
                    duration: Number(bone.Duration || 0),
                    screenCoord: bone.ScreenCoord !== 'false'
                };
            })
        }));

    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function() {
        _Scene_Map_start.call(this);
        this._spineBoneMemoryApplied = false;
    };

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        
        if (!this._spineBoneMemoryApplied) {
            const spriteset = this._spriteset;
            if (spriteset && spriteset.updateSpineBones) {
                spriteset.updateSpineBones();
                this._spineBoneMemoryApplied = true;
            }
        }
    };

    const _Spriteset_Map_create = Spriteset_Map.prototype.create;
    Spriteset_Map.prototype.create = function() {
        _Spriteset_Map_create.call(this);
        this._spineBonesUpdated = false;
    };


    Spriteset_Map.prototype.updateSpineBones = function() {
        if (this._spineBonesUpdated) return;
        pictureSettings.forEach(setting => {
            if (!$gameSwitches.value(setting.switchId)) return;
            const spine = $gameScreen.spine(setting.pictureId);
            if (!spine || typeof spine.setBone !== 'function') return;

            setting.bones.forEach(b => {
                spine.setBone(
                    b.name,
                    b.x,
                    b.y,
                    -b.rotation,
                    b.duration,
                    b.screenCoord
                );
            });
        });
        this._spineBonesUpdated = true;
    };

    const _Spriteset_Map_update = Spriteset_Map.prototype.update;
    Spriteset_Map.prototype.update = function() {
        _Spriteset_Map_update.call(this);
        if (!this._spineBonesUpdated) {
            this.updateSpineBones();
        }
    };
})();