//=============================================================================
// OncursorCHANGE.js
//=============================================================================

/*:
 * @plugindesc マウスカーソル変更
 * @author Onmoremind
 *
 * @param Switch ID
 * @text 動作スイッチ
 * @type switch
 * @desc カーソル変更用スイッチ
 * @default 1
 *
 * @param Variable ID
 * @text 画像変更変数
 * @type variable
 * @desc カーソル変更用変数
 * @default 1
 *
 * @param Image List
 * @text 画像リスト
 * @desc 画像ファイル名のリスト
 * @default icons/icon1,icons/icon2,icons/icon3
 *
 * @param Offset X
 * @text X座標オフセット
 * @desc X座標オフセット
 * @default 0
 *
 * @param Offset Y
 * @text Y座標オフセット
 * @desc Y座標オフセット
 * @default 0
 *
 * @help
 * 【利用規約】
 *  パラメータで設定したスイッチと変数で、
 *  カーソルを変更する単純なプラグインです。
 *  
 *  プラグイン作者に無断で使用、改変、再配布は不可。
 */

(function () {
    var parameters = PluginManager.parameters('OncursorCHANGE');
    var switchId = Number(parameters['Switch ID'] || 1);
    var variableId = Number(parameters['Variable ID'] || 1);
    var imageList = (parameters['Image List'] || '').split(',');
    var offsetX = Number(parameters['Offset X'] || 0);
    var offsetY = Number(parameters['Offset Y'] || 0);

    var _Scene_Base_update = Scene_Base.prototype.update;
    Scene_Base.prototype.update = function () {
        _Scene_Base_update.call(this);
        if ($gameSwitches.value(switchId)) {
            this.updateMouseCursorImage();
        } else {
            this.removeMouseCursorImage();
            document.body.style.cursor = 'default'; 
        }
    };

    Scene_Base.prototype.updateMouseCursorImage = function () {
        var imageIndex = $gameVariables.value(variableId) - 1; 

        if (imageIndex < 0 || imageIndex >= imageList.length) {
            this.removeMouseCursorImage();
            document.body.style.cursor = 'default'; 
            return;
        }

        var imagePath = imageList[imageIndex];
        if (!this._mouseCursorSprite) {
            this._mouseCursorSprite = new Sprite();
            this.addChild(this._mouseCursorSprite);
        }
        this._mouseCursorSprite.bitmap = ImageManager.loadPicture(imagePath);
        this._mouseCursorSprite.x = TouchInput.x + offsetX;
        this._mouseCursorSprite.y = TouchInput.y + offsetY;
        document.body.style.cursor = 'none'; 
    };

    Scene_Base.prototype.removeMouseCursorImage = function () {
        if (this._mouseCursorSprite) {
            this.removeChild(this._mouseCursorSprite);
            this._mouseCursorSprite = null;
        }
    };
})();