//=============================================================================
// ReserveScriptExecutor.js
//=============================================================================

/*:
 * @plugindesc イベント終了後にスクリプトを実行するプラグイン v1.0.0
 * @author NJ
 * 
 * @help
 * このプラグインはイベント中にスクリプトを予約し、
 * イベント終了後に自動で実行することができます。
 * 
 * 使用方法:
 * 1. イベント中の「スクリプト」コマンドで以下を記述：
 * 
 *    reserveScript(`
 *      実行したい内容。
 *    `);
 * 
 * 2. イベントが終了すると、予約されたスクリプトが自動で実行されます。
 * 
 * 注意点:
 *  プラグインコマンドではなく、「スクリプトコマンド」で実行してください。
 * 
 * バージョン
 * v1.0.0 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

(() => {
    'use strict';

    const RSExecutor = {
        reservedScript: null
    };

    window.reserveScript = function(script) {
        if (typeof script === "string" && script.trim().length > 0) {
            RSExecutor.reservedScript = script;
        } else {
            console.warn("⚠️ 無効なスクリプトが指定されました。");
        }
    };

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);

        if (RSExecutor.reservedScript && !$gameMap.isEventRunning()) {
            try {
                eval(RSExecutor.reservedScript);
            } catch (error) {
                console.error("❌ スクリプト実行エラー：", error);
            }
            RSExecutor.reservedScript = null;
        }
    };
})();
