//=============================================================================
// SwitchMacroTrigger.js
//=============================================================================

/*:
 * @plugindesc スイッチ変更時にスクリプトを自動実行するプラグイン V1.0.0
 * @author NJ
 * 
 * @param WatchList
 * @type struct<WatchItem>[]
 * @desc 監視するスイッチと実行スクリプトのリスト
 * @default []
 * 
 * @help
 * 
 * 設定方法;
 * 1. プラグインパラメータ「WatchList」に監視対象のスイッチ番号と実行スクリプトを登録。
 * 2. スイッチがONになったら、登録されたスクリプトが実行され、モードで設定した通りになる。
 *
 * バージョン
 * v1.1.0 ウェイトのタイミングを調整できる機能を追加
 * v1.0.0 初回
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

/*~struct~WatchItem:
 * @param switchId
 * @desc 監視するスイッチ番号 (数値のみ)
 * @type number
 * @min 1
 *
 * @param script
 * @desc スイッチがONの時に実行するスクリプト
 * @type note
 * 
 * @param mode
 * @desc スクリプト実行後の動作 (AutoOff:実行後にOFF / Continuous:OFFになるまで実行)
 * @type select
 * @option AutoOff
 * @option Continuous
 * @default AutoOff
 *
 * @param interval
 * @desc Continuous時の繰り返し間隔（フレーム単位）
 * @type number
 * @min 1
 * @default 1
 *
 * @param timing
 * @desc intervalの適用タイミング（Before: 実行前に待機 / After: 実行後に待機）
 * @type select
 * @option Before
 * @option After
 * @default After
 */

(function() {
    const parameters = PluginManager.parameters('SwitchMacroTrigger');
    const watchList = JSON.parse(parameters['WatchList'] || '[]').map(item => JSON.parse(item));
    const _switchTimers = {};

    function updateSwitchTriggers() {
        watchList.forEach(entry => {
            const switchId = Number(entry.switchId);
            const script = JSON.parse(entry.script);
            const mode = entry.mode || "AutoOff";
            const interval = Number(entry.interval || 1);
            const timing = entry.timing || "After";

            if (!_switchTimers[switchId]) {
                _switchTimers[switchId] = { timer: 0, locked: false };
            }
            const state = _switchTimers[switchId];

            if (!$gameSwitches.value(switchId)) {
                state.timer = 0;
                state.locked = false;
                return;
            }

            if (mode === "AutoOff") {
                try {
                    eval(script);
                } catch (e) {
                    console.error(`[ERROR] スイッチID ${switchId} のスクリプト実行エラー:`, e.message);
                }
                $gameSwitches.setValue(switchId, false);
                return;
            }

            if (mode === "Continuous") {
                if (timing === "Before") {
                    state.timer++;
                    if (state.timer >= interval) {
                        try {
                            eval(script);
                        } catch (e) {
                            console.error(`[ERROR] スイッチID ${switchId} のスクリプト実行エラー:`, e.message);
                        }
                        state.timer = 0;
                    }
                } else {
                    if (!state.locked) {
                        try {
                            eval(script);
                        } catch (e) {
                            console.error(`[ERROR] スイッチID ${switchId} のスクリプト実行エラー:`, e.message);
                        }
                        state.locked = true;
                        state.timer = 0;
                    } else {
                        state.timer++;
                        if (state.timer >= interval) {
                            state.locked = false;
                        }
                    }
                }
            }
        });
    }

    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        updateSwitchTriggers();
    };
})();
