//=============================================================================
// VariableMacroTrigger.js
//=============================================================================

/*:
 * @plugindesc 変数変更時にスクリプトを自動実行するプラグイン V1.1.0
 * @author NJ
 * 
 * @param WatchList
 * @type struct<WatchItem>[]
 * @desc 監視する変数と実行スクリプトのリスト
 * @default []
 * 
 * @help
 * 設定方法;
 * 1. プラグインパラメータ「WatchList」に監視対象の変数名と実行スクリプトを登録。
 * 2. 変数は `変数名 = "値";` の形で設定（例: `Test = 1;`）
 * 3. 変数の値が変更されたら、登録されたスクリプトが実行され、変数は `0` にリセットされる。
 *
 * バージョン
 * v1.0.0 初回
 * v1.1.0 登録名に数字を入れると変数を参照する機能を追加。
 *
 * 利用規約：
 *  プラグイン作者に無断で使用、改変、再配布は不可です。
 */

/*~struct~WatchItem:
 * @param varName
 * @desc 監視する変数名 (例: "Test" or 1 ※数字を入れるとその番号の変数を監視します。)
 * @type string
 *
 * @param script
 * @desc 変数が変更された際に実行するスクリプト
 * @type note
 */

(function() {
    var parameters = PluginManager.parameters('VariableMacroTrigger');
    var watchList = JSON.parse(parameters['WatchList'] || '[]').map(function(item) {
        return JSON.parse(item);
    });

    function checkVariableChanges() {
        watchList.forEach(function(entry) {
            var varKey = entry.varName;
            var script = entry.script;
            var varValue;

            if (!isNaN(varKey) && Number(varKey) > 0) { 
                var varId = Number(varKey);
                varValue = $gameVariables.value(varId);
            } else {
                if (typeof window[varKey] === "undefined") {
                    window[varKey] = 0;
                }
                varValue = window[varKey];
            }

            if (varValue !== 0) {
                try {
                    var cleanedScript = JSON.parse(script);
                    eval(cleanedScript);
                } catch (e) {
                    console.error("[ERROR] スクリプト実行エラー:", e.message);
                }

                if (!isNaN(varKey) && Number(varKey) > 0) {
                    $gameVariables.setValue(varId, 0);
                } else {
                    window[varKey] = 0;
                }
            }
        });
    }

    var _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        checkVariableChanges();
    };
})();
