/*:ja
 * @plugindesc マウス座標を取得します。
 * @author トリアコンタン
 *
 * @help 変数のスクリプトに以下のコマンドを入力すると、マウスの座標を代入できます。
 *
 *
 * TouchInput.mouseX
 * マウスのX座標を取得。
 *
 * TouchInput.mouseY
 * マウスのY座標を取得。
 *
 */

(function() {
    'use strict';
    var _TouchInput__onMouseMove = TouchInput._onMouseMove;
    TouchInput._onMouseMove = function(event) {
        _TouchInput__onMouseMove.apply(this, arguments);
        this.mouseX = Graphics.pageToCanvasX(event.pageX);
        this.mouseY = Graphics.pageToCanvasY(event.pageY);
    };
})();