//=============================================================================
// RPG Maker MZ - AltMessageWindow
//=============================================================================

/*:ja
 * @target MZ
 * @plugindesc メッセージウィンドウのレイアウトを変更します。
 * @author arihu
 *
 * @help AltMessageWindow.js
 *
 */

//=============================================================================
// メッセージ用フォントの読み込み
//=============================================================================
const fontFamily = 'mincho';
const loadGameFonts = Scene_Boot.prototype.loadGameFonts;
Scene_Boot.prototype.loadGameFonts = function () {
    FontManager.load(fontFamily, 'mgenplus-1c-regular.ttf');
    loadGameFonts.apply(this, arguments);
};

const widthScale = 0.75;
const fontsize = 23;
Scene_Message.prototype.messageWindowRect = function () {
    //奇数だとフォントが荒れるので偶数にすること
    const ww = Math.floor(Graphics.boxWidth * widthScale);
    const wh = this.calcWindowHeight(3, false) + 10;
    const wx = Math.ceil((Graphics.boxWidth - ww) / 2);
    const wy = 2;
    return new Rectangle(wx, wy, ww, wh);
};

Window_Message.prototype.updatePlacement = function () {
    const goldWindow = this._goldWindow;
    this._positionType = $gameMessage.positionType();
    this.y = (this._positionType * (Graphics.boxHeight - this.height)) / 2;
    if (this._positionType === 1) {
        this.x = Math.ceil((Graphics.boxWidth - this.width) / 2);
    } else {
        this.x = Math.ceil((Graphics.boxWidth - this.width) / 2);
    }
    if (goldWindow) {
        goldWindow.y = this.y > 0 ? 0 : Graphics.boxHeight - goldWindow.height;
    }
};


Window_Message.prototype.resetFontSettings = function () {
    this.contents.fontFace = fontFamily;
    this.contents.fontSize = fontsize;
    this.resetTextColor();
};

Window_Message.prototype.loadWindowskin = function () {
    this.windowskin = ImageManager.loadSystem("Window");
};

Window_Message.prototype.newLineX = function (textState) {
    const faceExists = $gameMessage.faceName() !== "";
    const faceWidth = ImageManager.faceWidth;
    const spacing = 20;
    const margin = faceExists ? faceWidth + spacing : this.lineXMargin();
    return textState.rtl ? this.innerWidth - margin : margin;
};
Window_Message.prototype.lineXMargin = function (textState) {
    return 100;
}

Window_NameBox.prototype.resetFontSettings = function () {
    this.contents.fontFace = fontFamily;
    this.contents.fontSize = fontsize;
    this.resetTextColor();
};

Window_NameBox.prototype.loadWindowskin = function () {
    this.windowskin = ImageManager.loadSystem("Window");
};

Window_ChoiceList.prototype.resetFontSettings = function () {
    this.contents.fontFace = $gameSystem.numberFontFace();
    this.contents.fontSize = fontsize;
    this.resetTextColor();
};

Window_ChoiceList.prototype.loadWindowskin = function () {
    this.windowskin = ImageManager.loadSystem("Window");
};


// 選択ウィンドウをメッセージウィンドウの位置に合わせる
Window_ChoiceList.prototype.windowX = function () {
    // const positionType = $gameMessage.choicePositionType();
    // const gap = ((1 - widthScale))/2;
    // if (positionType === 1) {
    //     return (Graphics.boxWidth - this.windowWidth()) / 2;
    // } else if (positionType === 2) {
    //     return Graphics.boxWidth * (1 - gap) - this.windowWidth();
    // } else {
    //     return Graphics.boxWidth * gap;
    // }
    return 800;
};

Window_ChoiceList.prototype.placeCancelButton = function () {
    if (this._cancelButton) {
        const spacing = 8;
        const button = this._cancelButton;
        if (this.x < Graphics.boxWidth / 2) {
            button.x = this.width + spacing;
        } else {
            button.x = -button.width - spacing;
        }
        button.y = this.height / 2 - button.height / 2;
    }
};


// const _Scene_Message_associateWindows = Scene_Message.prototype.associateWindows;
// Scene_Message.prototype.associateWindows = function () {
//     _Scene_Message_associateWindows.apply(this, arguments);
//     this._choiceListWindow.setHelpWindow(this._choiceHelpWindow);
//     this._choiceHelpWindow.setChoiceListWindow(this._choiceListWindow);
// };

// const _Scene_Message_createAllWindows = Scene_Message.prototype.createAllWindows;
// Scene_Message.prototype.createAllWindows = function () {
//     this.createChoiceHelpWindow();
//     _Scene_Message_createAllWindows.apply(this, arguments);
// };

// Scene_Message.prototype.createChoiceHelpWindow = function () {
//     this._choiceHelpWindow = new Window_ChoiceHelp(new Rectangle());
//     this.addWindow(this._choiceHelpWindow);
// };

// Scene_Message.prototype.createChoiceHelpWindow = function () {
//     this._choiceHelpWindow = new Window_ChoiceHelp(new Rectangle());
//     this.addWindow(this._choiceHelpWindow);
// };

// const _Window_ChoiceList_close = Window_ChoiceList.prototype.close;
// Window_ChoiceList.prototype.close = function () {
//     _Window_ChoiceList_close.apply(this, arguments);
//     this._helpWindow.close();
// };