//=============================================================================
// RPG Maker MZ - Etch
//=============================================================================

/*:ja
 * @target MZ
 * @author fude
 * @help Etch.js
 * 本プラグインは、制作者が明示的に許可した場合を除き、いかなる形であれ使用、複製、改変、再配布することを禁じます。
 * 本プラグインを無断で使用したこと、またはその利用によって生じた不具合・損害について、制作者は一切の責任を負いません。
 * 
 * @command init
 * @text 初期化
 * @desc 各種パラメータ設定
 * 
 * @arg live2dModelName
 * @text Live2dモデル選択
 * @type select
 * @option 立ちバック
 * @value h_stand_back
 * @option 正常位
 * @value h_missionary
 * @option フェラチオ
 * @value fellatio
 * @option バック
 * @value back
 * @default h_stand_back
 * 
 * @arg topName
 * @text 竿名
 * @type text
 * 
 * @command dispose
 * @text 終了
 * @desc 終了処理
 *
 * @command dispatchEvent
 * @text イベント発行
 * @desc 遷移イベントの発行
 * @arg event
 * @text イベント発行
 * @desc 発行するイベントの種類を選択
 * @type select
 * @option 射精
 * @value to_ejaclate
 * @option フィニッシュ
 * @value to_finish
 * 
 * @command waitMode
 * @text ウェイトモード
 * @desc えっちの更新を待機/再開する
 *
 * @arg wait
 * @text 進行条件待機
 * @desc true=待機On false=待機Off 振る舞いの更新は続行
 * @default true
 * @type boolean
 *
 * @arg updateWait
 * @text 更新待機モード
 * @desc true=停止On false=停止Off　振る舞いの更新を待機
 * @default true
 * @type boolean
 *
 * @command motionRequest
 * @text モーションリクエスト
 * @arg group
 * @type text
 * 
 * @command requestCondition
 * @text 進行条件セット
 * @desc 新規進行条件をセットする。現在の進行条件が未遂の場合、完遂まで待機しセットする。
 * 
 * @arg condition
 * @text 進行条件スクリプト
 * @desc 進行条件スクリプト
 * @default
 * @type combo
 * @option this._currentState.pistonCnt - this.pistonCnt === 10 // ピストン回数＋10回
 * @option this._currentState instanceof EtchEnd // えっち終了まで実行
 * @option this.live2dCtx._model.internalModel.motionManager.isFinished();
 * 
 * @command setStrokeParam
 * @text ピストン設定
 * @desc ピストンのストロークパラーメータを設定する。
 * 
 * @arg pistonSettings
 * @text ピストン設定
 * @desc ピストンの設定
 * @type struct<pistonSetting>[]
 * 
 * @arg loop
 * @text ループ
 * @desc true=ループする false=ループしない
 * @default true
 * @type boolean
 *
 * @command idlePiston
 * @text ピストン待機
 * @desc ピストンを停止する
 * 
 * @arg isIdle
 * @text 待機
 * @desc true=待機 false=再開
 * @default true
 * @type boolean
 * 
 * @command addCaress
 * @text 愛撫動作(パラメータ動作)追加

 * @arg type
 * @text パラメータムーブタイプ
 * @type select
 * @option 円
 * @value circle
 * @option 直線
 * @value straight
 * 
 * @arg paramIdX
 * @text X軸のパラメータID
 * @type text
 * @desc 直線タイプの場合はX軸のパラメータIDのみ参照
 * @arg paramIdY
 * @text Y軸のパラメータID
 * @type text
 * @arg time
 * @text スピード
 * @desc 一周にかける秒数
 * @decimals 2
 * @type number
 * @default 1.0
 * @arg radius
 * @text 半径(タイプが円のみ)
 * @type number
 * @default 0.5
 * 
 * @command removeCaress
 * @text 愛撫動作(パラメータ動作)削除
 * @arg paramId
 * @text パラメータID
 * @type text
 * @desc X、Yを指定した愛撫動作の場合、IDがいずれかにマッチするものを削除する
 * 
 * @command setPartOpacity
 * @text パーツの表示(透過率)を操作
 * @arg partId
 * @text パーツID
 * @type text
 * @arg opacity
 * @text 透過率
 * @type number
 * @default 0
 * 
 * @command setParameter
 * @text パラメータの値をセット
 * @arg paramId
 * @text パラメータID
 * @type text
 * @arg value
 * @text 値
 * @type number
 * @arg duration
 * @text 時間
 * @type number
 * @desc 何フレームかけてその値となるか
 * 
 */

/*~struct~pistonSetting:
 *
 * @param speedIn
 * @text 挿入速度
 * @desc フレーム数を指定する
 * @type number
 * @default 8
 *
 * @param speedOut
 * @text 抜き速度
 * @desc フレーム数を指定する
 * @type number
 * @default 15
 *
 * @param mash
 * @text 押し付け
 * @desc フレーム数を指定する
 * @type number
 * @default 4
 * 
 * @param depthIn
 * @text 挿入深度
 * @desc 0～1で指定
 * @type number
 * @default 1
 *
 * @param depthOut
 * @text 引き深度
 * @desc 0～1で指定
 * @type number
 * @default 0.8
 * 
 * @param wait
 * @text ウェイト
 * @desc 次の設定へ遷移するまでの時間(1/60秒)
 * @default 300
 *
 */

(function () {
    const pluginName = 'Etch';

    //===============================StateMachine==========================
    const event_to_insert = 'to_insert';
    const event_to_fellatio = 'to_fellatio';
    const event_to_ejaclate = 'to_ejaclate';
    const event_to_finish = 'to_finish';
    const event_to_end = 'to_end';
    const event_to_honban = 'to_honban'

    class Etch extends StateMachine {

        constructor(btm, top, modelName) {
            super(null);
            this.btm = btm;
            this.top = top;
            this.isBusy = false;
            this.requestCond = null
            this.wait = false;
            this.updateWait = false

            this.caress = [];
            this._isReady = false;
            this.live2dCtx = null;
            this._startMode;

            this.loadLive2d(modelName).then(() => {
                this.initTransition();
                this.start(this._startMode);
                this._isReady = true;
            })
        }

        loadLive2d(modelName) {
            switch (modelName) {
                case 'h_stand_back':
                    this.live2dCtx = new H_Stand_Back()
                    this._startMode = Idle;
                    break;
                case 'h_missionary':
                    this.live2dCtx = new H_Missionary();
                    this._startMode = Idle;
                    break;
                case 'fellatio':
                    this.live2dCtx = new H_Fellatio();
                    this._startMode = Idle;
                    break;
                case 'back':
                    this.live2dCtx = new H_Back();
                    this._startMode = Idle;
                    break;
            }

            return this.live2dCtx.loadLive2d().then(() => {
                return Promise.resolve()
            }).catch((error) => {
                console.error(error);
            });
        }

        isReady() {
            return this._isReady;
        }

        saveCurrentPistonCnt() {
            this.pistonCnt = this._currentState.pistonCnt;
        }

        requestCondition(cond) {
            this.cond = cond;
            this.isBusy = true;
            if (this.cond.match(/ピストン回数/))
                this.saveCurrentPistonCnt();
        }
        requestMotion(group) {
            this.live2dCtx._model.motion(group);
        }

        setPistonIdle(isIdle) {
            if (this._currentState.hasOwnProperty('Ipiston')) {
                this._currentState.Ipiston.setIdleState(isIdle)
            }
        }

        update() {
            if (!this.wait && eval(this.cond)) {
                this.isBusy = false;
                this.cond = true;
            };
            if (this.updateWait) return;
            super.update();
        }

        initTransition() {
            // this.addTransition(Insert, Honban, event_to_honban)
            this.addTransition(Honban, Inseminate, event_to_ejaclate)
            // this.addTransition(Cow, Inseminate, event_to_ejaclate)
            this.addTransition(Inseminate, Finish, event_to_finish)
            this.addTransition(Idle, Fellatio, event_to_fellatio)
            this.addTransition(Idle, EtchEnd, event_to_end)
            this.addTransition(Idle, Honban, event_to_honban)
            this.addTransition(Fellatio, Finish, event_to_finish)
            this.addTransition(Finish, EtchEnd, event_to_end)
        }

        setStrokeParam(strokeParam, loop) {
            if (this._currentState.hasOwnProperty('_Ipiston'))
                this._currentState._Ipiston.setStrokeParam(strokeParam, loop)
        }

        addCaressCircle(paramIdX, paramIdY, sec, radius) {
            //重複防止のため登録済かチェック
            if (this.caress.some(caress => caress.hasParamId(paramIdX) || caress.hasParamId(paramIdY)))
                return;
            const coreModel = this.live2dCtx.getCoreModel();
            const newCaress = new CaressCircle(paramIdX, paramIdY, coreModel, sec, radius);
            this.caress.push(newCaress);
        }

        removeCaress(paramId) {
            this.caress = this.caress.filter(caress => {
                return !caress.hasParamId(paramId)
            })
        }

        setPartOpacity(partId, opacity) {
            this.live2dCtx.getCoreModel().setPartOpacityById(partId, opacity);
        }

        setParameter(paramId, value, duration) {
            this._currentState.setChangeParam(paramId, value, duration);
        }

        terminate() {
            this.live2dCtx.terminate();
        }
    }

    //===============================States===============================
    class SexStateBase extends StateBase {

        constructor(stm) {
            super(stm);
            this.btm = stm.btm;
            this.top = stm.top;
            this.frmCnt = 0;
            this._coreModel = stm.live2dCtx.getCoreModel();

            this.clearChangeParam();
        }

        setChangeParam(id, targetValue = 0, duration = 1) {
            this._paramChangeId = id;
            this._paramChangeTargetValue = targetValue;
            this._paramChangeTargetRealValue = targetValue - this._coreModel.getParameterValueById(id);
            this._paramChangeDuration = duration;
        }

        clearChangeParam() {
            this._paramChangeId = '';
            this._paramChangeTargetValue = 0;
            this._paramChangeDuration = 0;
            this._paramChangeTargetRealValue = 0;
        }

        update() {
            this.updateChangeParam();
            super.update();
            this.frmCnt++;
        }

        onUpdate() {
        }

        updateChangeParam() {
            if (!this._paramChangeId) return

            const currentValue = this._coreModel.getParameterValueById(this._paramChangeId)
            if (currentValue === this._paramChangeTargetValue) {
                this.clearChangeParam();
                return;
            }
            const newValue = (currentValue + this._paramChangeTargetRealValue / this._paramChangeDuration);
            const trim = this._paramChangeTargetRealValue > 0 ?
                Math.min(newValue, this._paramChangeTargetValue) :
                Math.max(newValue, this._paramChangeTargetValue);
            this._coreModel.setParameterValueById(this._paramChangeId, trim);
        }
        onEnter(prevState) { this.frmCnt = 0; }
        onExit(nextState) { this.frmCnt = 0; }
    }

    class Fellatio extends SexStateBase {
        onEnter(prev) {
            this._lastOk = 0;
            // this._mode = 'irrumatio';
            this._mode = 'fellatio';
            this._paramMax = this._coreModel.getParameterMaximumValue(this._coreModel.getParameterIndex(this._mode));
            this._Ipiston = new IPiston(this.stm.top);
            this._Ipiston.setEaseThrustSine();

            this._lastInput = null;
            this._stopCount = 0;
            this._holdCount = 0;
            this._speedType = 1;
            this._stimulate = 5;
            this._finish = false;
            this.setStroke(this._speedType);
        }

        setStroke(type) {
            const strokeParamTable = [
                [{ time: { in: 35, out: 35, mash: 1 }, depth: { in: 1, out: 1 }, wait: 300 }],
                [{ time: { in: 28, out: 28, mash: 1 }, depth: { in: 1, out: 1 }, wait: 300 }],
                [{ time: { in: 20, out: 20, mash: 1 }, depth: { in: 1, out: 1 }, wait: 300 }],
                [{ time: { in: 14, out: 14, mash: 1 }, depth: { in: 1, out: 1 }, wait: 300 }],
            ]
            this._Ipiston.setStrokeParam(strokeParamTable[type], true)
        }

        onUpdate() {
            if (this._finish)
                return;
            const diff = this.frmCnt - this._lastOk;
            // if (Input.isTriggered('up')) {
            //     this._speedType = (this._speedType + 1).clamp(0, 3);
            //     this.setStroke(this._speedType);
            //     return
            // } else if (Input.isTriggered('down')) {
            //     this._speedType = (this._speedType - 1).clamp(0, 3);
            //     this.setStroke(this._speedType);
            //     return
            // }

            if (Input.isPressed('ok')) {
                this._stopCount = 0;
                if (this._lastInput !== 'left') {
                    this._Ipiston.setState('thrust', true);
                }
                this._lastInput = 'left';
            }
            else {
                if (this._lastInput !== 'right') {
                    if (this._Ipiston.strokeRate >= 0.7) {
                        AudioManager.playBgs({ name: 'erotic/fellatio_normal_01', volume: 100, pitch: 100 });
                        switch (Math.randomInt(3)) {
                            case 0: AudioManager.playSe({ name: 'erotic/tekoki_oneShot', volume: 90, pitch: 100 }); break;
                            case 1: AudioManager.playSe({ name: 'erotic/tekoki_oneShot', volume: 90, pitch: 130 }); break;
                            case 2: AudioManager.playSe({ name: 'erotic/tekoki_oneShot', volume: 90, pitch: 150 }); break;
                        }
                        if (this._speedType === $gameVariables.value(64)) {
                            const current = $gameVariables.value(63);
                            const newValue = (current + this._stimulate).clamp(0, $gameVariables.value(62))
                            $gameVariables.setValue(63, newValue);
                        }
                    }
                    this._Ipiston.setState('pull', true);
                }
                this._lastInput = 'right';
            }

            if (this._Ipiston.thrustJust) {
                this._lastOk = this.frmCnt;
                if ($gameVariables.value(63) === $gameVariables.value(62)) {
                    this._finish = true;
                }
            }

            if (diff > 120 && this._Ipiston.strokeRate <= 0.1) {
                this._stopCount++;
            } else {
                this._stopCount = 0;
            }

            if (this._Ipiston.strokeRate === 1) {
                this._holdCount++;
                if (this._holdCount > 90) {
                    this.setChangeParam('eyebrow', 1, 50);
                }
            }
            else {
                this._holdCount = 0;
                this.setChangeParam('eyebrow', 0, 180);
            }

            if (this._stopCount > 150) {
                const current = $gameVariables.value(63);
                const newValue = (current - 1).clamp(0, $gameVariables.value(62))
                $gameVariables.setValue(63, newValue);
                AudioManager.stopBgs();
                this._stopCount = 10;
            } else {
                if (this._stopCount < 10)
                    this._Ipiston.update()
            }

            this._coreModel.setParameterValueById('eyes_open', 1 - this._Ipiston.strokeRate / 2);
            this._coreModel.setParameterValueById(this._mode, this._paramMax * this._Ipiston.strokeRate)
        }
        onExit() {
            AudioManager.stopBgs();
        }
    }

    class Idle extends SexStateBase {
    }


    class Insert extends SexStateBase {
        onEnter() {
            this.stm.live2dCtx._model.motion('Insert')
        }
        onUpdate() {
            if (this.stm.live2dCtx._model.internalModel.motionManager.isFinished())
                this.stm.dispatch(event_to_honban)
        }
        onExit() {
            this.stm.live2dCtx._model.motion('Idle')
        }
    }

    class Honban extends SexStateBase {
        onEnter(prev) {
            this.pistonCnt = 0;
            this._mode = 'piston';
            this._paramMax = this._coreModel.getParameterMaximumValue(this._coreModel.getParameterIndex('piston'));
            this._physics = 0;
            if (!!prev && prev.hasOwnProperty('_Ipiston'))
                this._Ipiston = prev._Ipiston;
            else
                this._Ipiston = new IPiston(this.stm.top);
            this._coreModel.setParameterValueById("breath", 1);
        }

        onUpdate() {

            for (const caress of this.stm.caress)
                caress.update()

            if (this._Ipiston.update()) {
                this._Ipiston.flipState();
            }

            this.btm.updatePiston(this._Ipiston.strokeRate, this.top.maleData.penisLength);

            this._coreModel.setParameterValueById(this._mode, this._paramMax * (this._Ipiston.strokeRate));

            const current = this._coreModel.getParameterValueById('piston_physics');
            if (this._physics !== current) {
                if (this._physics > 0)
                    this._coreModel.setParameterValueById('piston_physics', current + 1 / 4)
                else
                    this._coreModel.setParameterValueById('piston_physics', current - 1 / 4)
            }

            if (!this._Ipiston.thrustJust) return;
            this._physics = (this._physics + 1) % 2;
            this.pistonCnt++;

            // ゲームデータ更新
            const isReminiscence = $gameSwitches.value(100);
            if (!isReminiscence) {
                const gameDataPistonCount = $gameVariables.value(187);
                $gameVariables.setValue(187, gameDataPistonCount + 1);
            }
        }

    }

    class CaressCircle {
        constructor(paramIdX, paramIdY, coreModel, aroundSec = 2, radius = 1) {
            this._paramIdX = paramIdX;
            this._paramIdY = paramIdY;
            this._coreModel = coreModel
            this._aroundFrame = aroundSec * 60
            this._pointXCache = []
            this._pointYCache = []
            for (let i = 0; i < this._aroundFrame; i++) {
                const rad = i / this._aroundFrame * Math.PI * 2
                this._pointXCache.push(radius * Math.cos(rad))
                this._pointYCache.push(radius * Math.sin(rad))
            }
            this._frmCnt = 0;
        }

        update() {
            this._coreModel.setParameterValueById(this._paramIdX, this._pointXCache[this._frmCnt])
            this._coreModel.setParameterValueById(this._paramIdY, this._pointYCache[this._frmCnt])
            this._frmCnt = (this._frmCnt + 1) % this._aroundFrame;
        }

        hasParamId(paramId) {
            return paramId === this._paramIdX || paramId === this._paramIdY
        }
    }

    class Inseminate extends SexStateBase {
        onEnter(prev) {
            this._physics = 0;
            this._paramMax = prev._paramMax;
            this._mode = prev._mode;
            if (!!prev && prev.hasOwnProperty('_Ipiston'))
                this._Ipiston = prev._Ipiston;
            else
                this._Ipiston = new IPiston(this.stm.top)

            this._inseminateParam = JsonEx.makeDeepCopy(this.top.inseminateParam)
            this._inseminateWeight = JsonEx.makeDeepCopy(this.top.inseminateWeight)

            this.top._hbAudio.playRandom('nakadashi')

            // ゲームデータ更新
            const isReminiscence = $gameSwitches.value(100);
            if (!isReminiscence) {
                const gameDataInseminateCount = $gameVariables.value(185);
                $gameVariables.setValue(185, gameDataInseminateCount + 1);
            }
        }

        onUpdate() {
            if (this.inseminate()) {
                this.stm.dispatch(event_to_finish);
            }
            this.btm.updatePiston(this._Ipiston.strokeRate, this.top.maleData.penisLength);

            this._coreModel.setParameterValueById(this._mode, this._paramMax * (this._Ipiston.strokeRate))

            if (!this._Ipiston.thrustJust) return;
            this._coreModel.setParameterValueById('piston_physics', (this._physics++ % 2))
            this.pistonCnt++;
        }

        onExit() {
            // console.log('onExit Inseminate')
        }

        inseminate() {
            const ret = !this._Ipiston.update();
            if (this._Ipiston.thrustJust)
                this.top._hbAudio.playRandom('nakadashi')

            if (ret) return false;

            if (this._Ipiston.state === 'thrust' && this._inseminateParam[0] > 0) {
                this._inseminateParam[0]--;
                if (this.btm.uterus.spermSum <= this.btm.uterus._aCapacity)
                    this.btm.uterus.spermSum += this._inseminateWeight[0];
            } else {
                if (this._Ipiston.state === 'thrust') {
                    this._inseminateParam.shift();
                    this._inseminateWeight.shift();
                }
                if (this._inseminateParam.length <= 0) return true;
                this._Ipiston.flipState();
            }
            return false;
        }
    }

    class Finish extends SexStateBase {
        onEnter(prev) {
            this._coreModel = prev._coreModel;
            this._paramMax = prev._paramMax;
            this._mode = prev._mode;
            if (!!prev && prev.hasOwnProperty('_Ipiston'))
                this._Ipiston = prev._Ipiston;
            else
                this._Ipiston = new IPiston(this.stm.top)

            this._Ipiston.setStrokeParam(this.top.getStrokeParam('finish'));
        }

        onUpdate() {
            this._coreModel.setParameterValueById(this._mode, this._paramMax * (this._Ipiston.strokeRate))

            if (this._Ipiston.state !== 'pull')
                this._Ipiston.flipState();

            if (this._Ipiston.update())
                this.stm.dispatch(event_to_end)
        }

        onExit() {
        }
    }

    class EtchEnd extends SexStateBase {
        onEnter(prevState) {
            // console.log('onEnter EtchEnd')
        }
    }

    class IPiston {

        constructor(owner) {
            this.owner = owner;
            this.reset();
        }

        reset() {
            this.thrustJust = false;
            this.strokeRate = 0;
            this.state = 'thrust';
            this.sIndex = 0;
            this.stroke = null;
            this.frmCnt = 0;
            this.lastState = null;
            this.waitCnt = 0;
            this.loop = false;
            this._easeThrust = easeOutQuint;
            this._easePull = easeInOutSine;
        }

        setEaseThrustSine() {
            this._easeThrust = easeOutSine;
            // this._easeThrust = easeOutCubic;

        }

        isReady() {
            return !!this.stroke;
        }

        getStrokeParam() {

            if (this.waitCnt < this.stroke.wait) return this.stroke;


            if (!this.loop && this.sIndex >= this.strokeParams.length) {
                this.sIndex = this.strokeParams.length - 1;
            }

            this.waitCnt = 0;

            return this.strokeParams[this.sIndex++ % this.strokeParams.length]
        }

        setState(state, keep) {
            this.stroke = this.getStrokeParam();
            if (state === 'thrust') {
                this.state = state;
                if (!keep)
                    this.frmCnt = this.stroke.time.in;
            }
            else if (state === 'pull') {
                this.state = state;
                if (keep)
                    this.frmCnt = Math.round(this.stroke.time.out * (1 - this.strokeRate));
                else
                    this.frmCnt = 0;
            }
        }

        setIdleState(isIdle) {
            if (!isIdle && this.state !== 'idle' || isIdle && this.state === 'idle') { // アイドルしていない時にアイドル解除
                return
            }
            this.lastState = isIdle ? this.state : this.lastState;
            this.state = isIdle ? 'idle' : this.lastState;
        }

        flipState() {
            this.stroke = this.getStrokeParam();
            if (this.state === 'pull') {
                this.state = 'thrust';
                this.frmCnt = this.stroke.time.in;
            }
            else if (this.state === 'thrust') {
                this.state = 'pull';
                this.frmCnt = 0;
            }
        }

        update() {
            if (!this.stroke) return false;

            this.thrustJust = false;
            this.pullOutJust = false;
            var isDone = false;
            switch (this.state) {
                case 'thrust':
                    isDone = this.thrust();
                    this.waitCnt++;
                    break;
                case 'pull':
                    isDone = this.pull()
                    this.waitCnt++;
                    break;
                case 'idle':
                    // do nothing
                    break;
            }
            return isDone;
        }

        thrust() {
            if (this.frmCnt < 0) {
                if (this.frmCnt === -1) this.thrustJust = true;
                return this.frmCnt-- <= -this.stroke.time.mash
            }
            this.strokeRate = (1 - this._easeThrust(this.frmCnt / this.stroke.time.in) * this.stroke.depth.out) * this.stroke.depth.in;
            if (this.frmCnt <= 0) {
                this.frmCnt--;
                return this.stroke.time.mash === 0
            }

            this.frmCnt--;
            return false;
        }

        pull() {
            if (this.frmCnt > this.stroke.time.out) return true;

            this.strokeRate = 1 * this.stroke.depth.in - this._easePull(this.frmCnt / this.stroke.time.out) * this.stroke.depth.out;

            if (this.frmCnt === this.stroke.time.out) {
                this._pullOutJust = true;
                // console.log("pull")
                this.frmCnt++;
                return true;
            }

            this.frmCnt++;
            return false;
        }

        setStrokeParam(strokeParams, loop = false) {
            this.strokeParams = strokeParams;
            // 最初の１回のみ挿入時間を取得する
            if (!this.stroke) this.frmCnt = this.strokeParams[0].time.in;
            this.stroke = this.strokeParams[0];
            this.loop = loop;
            this.sIndex = 0;
        }

    }

    class Live2dContext {
        constructor() {
            this._model = null;
            this._filePath = null;
            this._live2dContainer = null;
        }

        loadLive2d() {
            this.clear()
            const option = { autoInteract: false, autoUpdate: false, motionPreload: PIXI.live2d.MotionPreloadStrategy.ALL };
            return PIXI.live2d.Live2DModel.from('./' + this._filePath, option).then((model) => {
                this.setup(model);
                this._model = model;
                this._model.anchor.set(0.5, 0.5);
                return Promise.resolve();
            }).catch((error) => {
                console.error(error);
            });
        }

        setup(model) {
            const live2dSprite = new Sprite_Live2d(model);
            live2dSprite.x = this._x;
            live2dSprite.y = this._y;
            live2dSprite.scale.set(this._scale, this._scale);
            this._live2dContainer = new Live2dContainer(live2dSprite);
            SceneManager._scene._spriteset.addChildlive2d(this._live2dContainer);
            if (this._mosaicRect)
                this._live2dContainer.setupMosaic(this._mosaicRect)
        }

        getCoreModel() {
            return this._model.internalModel.coreModel
        }

        clear() {
            if (!this._model) return;
            this.terminate();
        }

        terminate() {
            this._live2dContainer.clear();
            SceneManager._scene.terminatelive2d(this._live2dContainer)
            this._model = null;
        }
    }

    class H_Stand_Back extends Live2dContext {
        constructor() {
            super();
            this._filePath = 'live2d/stand_back/H_stand_back.model3.json'
            // this._x = 1160;
            this._x = 700;
            this._y = 420;
            this._scale = 0.44;
            // this._mosaicRect = new Rectangle(400, 380, 150, 200);
        }
    }

    class H_Back extends Live2dContext {
        constructor() {
            super();
            this._filePath = 'live2d/back/H_back.model3.json'
            // this._x = 1160;
            this._x = 700;
            this._y = 376;
            this._scale = 0.45;
            // this._mosaicRect = new Rectangle(400, 380, 150, 200);
        }
    }

    class H_Missionary extends Live2dContext {
        constructor() {
            super();
            this._filePath = 'live2d/missionary/H_missionary.model3.json';
            this._x = 700;
            this._y = 400;
            this._scale = 0.55;
            // this._mosaicRect = new Rectangle(400, 380, 150, 200);
        }
    }

    class H_Fellatio extends Live2dContext {
        constructor() {
            super();
            this._filePath = 'live2d/fellatio/H_fellatio.model3.json';
            this._x = 700;
            this._y = 380;
            this._scale = 0.5;
            // this._mosaicRect = new Rectangle(400, 400, 400, 200);
        }
    }


    Spriteset_Base.prototype.addChildlive2d = function (container) {
        // this.addChild(Sprite);
        const priority = 10;
        this._pictureContainer.addChildAt(container, priority);
    };

    Scene_Base.prototype.terminatelive2d = function (live2dContainer) {
        this._spriteset._pictureContainer.removeChild(live2dContainer)
    };

    function Live2dContainer() {
        this.initialize.apply(this, arguments);
    };
    Live2dContainer.prototype = Object.create(PIXI.Container.prototype);
    Live2dContainer.prototype.constructor = Live2dContainer;

    Live2dContainer.prototype.initialize = function (live2dSprite) {
        PIXI.Container.call(this);
        this._live2dSprite = live2dSprite;
        this.mosaicSprite = null;
        this.mosaicTexture = null;
        this.addChild(this._live2dSprite);
    };

    Live2dContainer.prototype.setupMosaic = function (rect) {
        const filter = new PIXI.filters.PixelateFilter();
        filter.size = 15;
        this.mosaicSprite = new Sprite();
        this.mosaicSprite.filters = [filter];
        this.mosaicTexture = PIXI.RenderTexture.create({ width: Graphics.boxWidth, height: Graphics.boxHeight });
        this.mosaicSprite.texture = this.mosaicTexture;
        this.mosaicSprite.texture.frame = rect;
        this.mosaicSprite.move(rect.x, rect.y)
        this.addChild(this.mosaicSprite);
    }

    Live2dContainer.prototype.update = function () {
        this._live2dSprite.update();
        if (!this.mosaicSprite) return;
        const renderer = Graphics.app.renderer;
        renderer.render(this._live2dSprite, this.mosaicTexture);
    }

    Live2dContainer.prototype.clear = function () {
        this._live2dSprite.clear();
        if (this.mosaicTexture)
            this.mosaicTexture.destroy({ destroyBase: true });
        if (this.mosaicSprite)
            this.removeChild(this.mosaicSprite)
    }

    function Sprite_Live2d() {
        this.initialize.apply(this, arguments);
    };
    Sprite_Live2d.prototype = Object.create(PIXI.Container.prototype);
    Sprite_Live2d.prototype.constructor = Sprite_Live2d;

    Sprite_Live2d.prototype.initialize = function (model) {
        PIXI.Container.call(this);
        this._model = model;
        this.addChild(this._model);
    };

    Sprite_Live2d.prototype.update = function () {
        if (this._model) {
            this._model.update(16);
        }
    };

    Sprite_Live2d.prototype.clear = function () {
        if (this._model) {
            this.removeChild(this._model);
            this._model = null;
        }
    };

    var _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
        _Scene_Map_updateMain.apply(this, arguments);
        if (!window.$gameEtch || !window.$gameEtch.isReady())
            return;
        window.$gameEtch.update();
    };

    var _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function () {
        var waiting = null;
        switch (this._waitMode) {
            case 'requestCondition':
                waiting = $gameEtch.isBusy;
                break;
            case 'etch_init':
                waiting = !$gameEtch.isReady();
                break;
        }
        if (waiting !== null) {
            if (!waiting) {
                this._waitMode = '';
            }
            return waiting;
        }
        return _Game_Interpreter_updateWaitMode.call(this);
    };

    PluginManager.registerCommand(pluginName, 'init', function (args) {
        if (window.$gameEtch)
            return false;
        const btm = $gameParty.leader().sex;
        const top = new MaleSexualAbility();
        window.$gameEtch = new Etch(btm, top, args.live2dModelName);
        this.setWaitMode("etch_init");
    });

    PluginManager.registerCommand(pluginName, 'dispose', function (args) {
        if (!window.$gameEtch) return
        $gameEtch.terminate();
        $gameEtch = null;
    });

    PluginManager.registerCommand(pluginName, 'waitMode', function (args) {
        $gameEtch.wait = JSON.parse(args.wait);
        $gameEtch.updateWait = JSON.parse(args.updateWait);
    });

    PluginManager.registerCommand(pluginName, 'dispatchEvent', function (args) {
        $gameEtch.dispatch(args.event);
    });

    PluginManager.registerCommand(pluginName, 'requestCondition', function (args) {
        this.setWaitMode("requestCondition");
        $gameEtch.requestCondition(args.condition);
    });

    PluginManager.registerCommand(pluginName, 'setStrokeParam', function (args) {
        const newStrokeParams = [];
        for (let setting of JSON.parse(args.pistonSettings)) {
            const obj = JsonEx.parse(setting);
            newStrokeParams.push(
                {
                    time: { in: Number(obj.speedIn), out: Number(obj.speedOut), mash: Number(obj.mash) },
                    depth: { in: Number(obj.depthIn), out: Number(obj.depthOut) },
                    wait: Number(obj.wait)
                }
            )
        }
        const loop = JSON.parse(args.loop)

        $gameEtch.setStrokeParam(newStrokeParams, loop);
    });

    PluginManager.registerCommand(pluginName, 'motionRequest', function (args) {
        $gameEtch.requestMotion(args.group);
    });


    PluginManager.registerCommand(pluginName, 'idlePiston', function (args) {
        $gameEtch.setPistonIdle(JSON.parse(args.isIdle));
    });

    PluginManager.registerCommand(pluginName, 'setPartOpacity', function (args) {
        if (!window.$gameEtch)
            return;
        $gameEtch.setPartOpacity(args.partId, +args.opacity);
    });

    PluginManager.registerCommand(pluginName, 'setParameter', function (args) {
        if (!window.$gameEtch)
            return;
        $gameEtch.setParameter(args.paramId, +args.value, +args.duration);
    });

    PluginManager.registerCommand(pluginName, 'addCaress', function (args) {
        if (!window.$gameEtch)
            return;

        switch (args.type) {
            case 'circle':
                $gameEtch.addCaressCircle(args.paramIdX, args.paramIdY, +args.time, +args.radius)
                break;
        }
    });

    PluginManager.registerCommand(pluginName, 'removeCaress', function (args) {
        if (!window.$gameEtch)
            return;

        $gameEtch.removeCaress(args.paramId)
    });

    window[Live2dContext.name] = Live2dContext;
    window[H_Stand_Back.name] = H_Stand_Back;
    window[Insert.name] = Insert;
    window[Honban.name] = Honban;
    window[Inseminate.name] = Inseminate;
    window[Finish.name] = Finish;
    window[EtchEnd.name] = EtchEnd;
}
)();