//=============================================================================
// RPG Maker MZ - FemaleSexualAbility
//=============================================================================

/*:ja
 * @target MZ
 * @author fude
 * @help FemaleSexualAbility.js
 * 本プラグインは、制作者が明示的に許可した場合を除き、いかなる形であれ使用、複製、改変、再配布することを禁じます。
 * 本プラグインを無断で使用したこと、またはその利用によって生じた不具合・損害について、制作者は一切の責任を負いません。
 * 
 *
*/


(function () {
    const pluginName = 'FemaleSexualAbility';

    // =========================== Uterus初期化 ===========================
    const _GameActor_initMembers = Game_Actor.prototype.initMembers;
    Game_Actor.prototype.initMembers = function () {
        _GameActor_initMembers.call(this);
        this.sex = {};
    };

    const _GameActor_setup = Game_Actor.prototype.setup;
    Game_Actor.prototype.setup = function (actorId) {
        _GameActor_setup.call(this, actorId);

        if (this.actorId() === 1)
            this.sex = new FemaleSexualAbility();
    }

    var _Game_Player_update = Game_Player.prototype.update;
    Game_Player.prototype.update = function () {
        _Game_Player_update.apply(this, arguments);
        const actor = $gameParty.leader();
        if (this.actor().actorId() === 1)
            actor.sex.update();
    }

    class FemaleSexualAbility {
        constructor() {
            this.uterus = new UterusBase();
            this.voice = new HeroineVoice(this);
            this._hbAudio = {};
            this.initSe();
        }

        initSe() {
            this._hbAudio = new HbAudioController();
            const pachu = [
                { name: "erotic/piston_dry1", volume: 140, pitch: 100 },
                { name: "erotic/piston_dry2", volume: 140, pitch: 100 },
                { name: "erotic/piston_dry3", volume: 140, pitch: 100 },
                { name: "erotic/piston_dry4", volume: 140, pitch: 100 },
                { name: "erotic/piston_dry5", volume: 140, pitch: 100 },
            ]

            const kuchu = [
                { name: "erotic/kuchu1", volume: 50, pitch: 100 },
                { name: "erotic/kuchu2", volume: 50, pitch: 100 },
                { name: "erotic/kuchu3", volume: 50, pitch: 100 },
                { name: "erotic/kuchu4", volume: 50, pitch: 100 },
                { name: "erotic/kuchu5", volume: 50, pitch: 100 },
            ]

            this._hbAudio.register(pachu, 'pachu');
            this._hbAudio.register(kuchu, 'kuchu');
        }

        update() {
            this.voice.update();
        }


        updatePiston(strokeRate, penisLength) {
            this.uterus.updatePiston(strokeRate, penisLength);

            const itoi = this.uterus.sence.speed.getItoI()

            if ($gameSwitches.value(24)) {
                this.voice.dispatch(event_aegi_reach_orgasm)
            }

            if (itoi === 120) {
                this.voice.dispatch(event_aegi_idle)
            }

            if (this.uterus.sence.speed.isImpact()) {
                if (this.uterus.sence.speed.isFaster()) {
                    this.voice.dispatch(event_aegi_getFaster)
                } else if (this.uterus.sence.speed.isSlower()) {
                    this.voice.dispatch(event_aegi_getSlower)
                }
                else if (itoi < 22) {
                    this.voice.dispatch(event_aegi_high)
                } else if (itoi < 60) {
                    this.voice.dispatch(event_aegi_middle)
                } else if (itoi >= 60) {
                    this.voice.dispatch(event_aegi_low)
                }

                this._hbAudio.playRandom('kuchu')
                const ac = this.uterus.sence.speed.getAcceleration(1);
                if (ac < -0.17) {
                    this._hbAudio.playRandom('pachu')
                }
                // 計測区間初期化
                this.uterus.sence.speed.resetSpeeds();

            }
        }

        onTimePassed() {
            this.uterus.onTimePassed();
        }

    }

    class UterusBase {
        constructor() {
            this._sperms = [];
            this._capacity = 10000;
            this._aCapacity = 16000;
            this.spermSum = 0;
            this.penisDepth = 0;
            this.sence = { speed: new SenceSpeed() };
        }

        hasPenisIn() {
            return this.penisDepth > 0;
        }

        updatePiston(strokeRate) {
            this.penisDepth = strokeRate;
            this.sence.speed.sample(this.penisDepth);
        }
    }

    class SenceSpeed {

        constructor() {
            this.sampleNum = 100;
            this.reset();
            this.lastMidSpeedFaster = 0;
            this.lastMidSpeedSlower = 0;
            this.midSpeed = 0;
            this.lastMidSpeed = 0;
            this.stableCnt = 0;
            this.impact = false
            this.maxSpeed = 0;
            this.minSpeed = Infinity;
            this.itoi = 0;

        }

        reset() {
            this.resetSpeeds();
            this.resetSamples();
        }

        resetSpeeds() {
            this.speeds = Array(this.sampleNum).fill(0)
        }

        resetSamples() {
            this.samples = Array(this.sampleNum).fill(0)
        }

        sample(length) {
            if (this.impact) {
                this.itoi = 0;
            }

            const speed = length - this.samples[this.samples.length - 1];
            this.impact = this.speeds[this.speeds.length - 1] > 0 && speed === 0

            this.speeds.push(speed)
            this.samples.push(length)
            this.samples.shift();
            this.speeds.shift();

            this.itoi++;
        }

        getSpeed(dt) {
            return Math.abs((this.samples[this.samples.length - 1] - this.samples[this.samples.length - 1 - dt]) / dt);
        }

        getMidSpeed(length) {
            return (Math.max(...this.speeds.slice(-length)) + Math.min(...this.speeds.slice(-length).map(speed => Math.abs(speed)).filter(speed => speed !== 0))) / 2
        }

        getAcceleration(dt) {
            return (this.speeds[this.speeds.length - 1] - this.speeds[this.speeds.length - 1 - dt]) / dt;
        }

        getItoI() {
            return this.itoi;
        }

        isImpact() {
            return this.impact;
        }

        isFaster() {
            const current = this.getMidSpeed();
            const isFaster = this.lastMidSpeedFaster !== 0 && current > this.lastMidSpeedFaster;
            this.lastMidSpeedFaster = current;
            return isFaster;
        }

        isSlower() {
            const current = this.getMidSpeed();
            const isSlower = this.lastMidSpeedSlower !== 0 && current < this.lastMidSpeedSlower;
            this.lastMidSpeedSlower = current;
            return isSlower;
        }

        setSampleNum(num) {
            this.sampleNum = num < 1 ? 1 : num;
            this.reset();
        }

    }

    window[FemaleSexualAbility.name] = FemaleSexualAbility;
    window[UterusBase.name] = UterusBase;
    window[SenceSpeed.name] = SenceSpeed;

}
)()