(function () {

    class HbAudioController {

        constructor() {
            this.reg = {}
        }

        register(entry, key) {
            if(this.reg[key]){
                this.reg[key].seList = entry;
            }
            else if (entry instanceof Array) {
                this.reg[key] = new HbSeMulti(entry)
            } else {
                this.reg[key] = new HbSe(entry)
            }

            if (!this.reg[key]) {
                console.log('SEの登録に失敗');
                return;
            }
        }

        Unregister(key) {
            delete this.reg[key]
        }

        play(key, index) {
            this.reg[key].play(index);
        }

        playRandom(key, muteRate) {
            this.reg[key].playRandom(muteRate)
        }

        mute(regx) {
            for (let key in this.reg) {
                if (key.match(regx))
                    this.muteProc.call(this.reg[key])
            }
        }

        muteProc() {
            const seNameList = this.seList.map(se => se.name);
            for (let key in AudioManager._seBuffers) {
                // for (let key in AudioManager._seBuffers.filter(buf => buf._isPlaying)) {
                    if (seNameList.includes(AudioManager._seBuffers[key].name)) {
                    AudioManager._seBuffers[key].fadeOut(1);
                    // AudioManager._seBuffers[key].volume = 0;
                    // AudioManager._seBuffers[key]._isPlaying = false;
                }
            }
            AudioManager.cleanupSe()
        }

        isPlaying(regx) {
            for (let key in this.reg) {
                if (key.match(regx) && this.reg[key].isPlaying())
                    return true;
            }
            return false;
        }

        reductGain(regx) {
            var extractSe = [];
            for (let key in this.reg) {
                if (key.match(regx))
                    extractSe = [...extractSe, ...this.reg[key].seList]
            }

            const seNameList = extractSe.map(se => se.name);
            AudioManager._seBuffers.filter(buf => buf._isPlaying).filter((buf, i) => {
                if (seNameList.includes(buf.name)) {
                    AudioManager._seBuffers[i].volume /= 2;
                }
            })
        }

        getCurrentPlayingBuffers(key){
            return this.reg[key].getCurrentPlayingBuffers();
        }
    }

    class HbSe {
        constructor(se) {
            this.se = se;
        }

        play() {
            AudioManager.playSe(this.se)
        }

        playRandom(muteRate = 0) {
            if (muteRate > 0 && Math.random() < muteRate)
                return;
            AudioManager.playSe(this.se)
        }

        isPlaying() {
            const dupNum = AudioManager._seBuffers.filter(buf => buf._isPlaying).filter((buf, i) => {
                if (this.se.name === buf.name) {
                    return true;
                }
                return false;
            }).length
            return dupNum > 0
        }
    }

    class HbSeMulti {
        constructor(seList) {
            this.seList = seList;
            this.last = null;
        }

        play(index) {
            index = index % this.seList.length;

            AudioManager.playSe(this.seList[index])
        }

        playRandom(muteRate = 0) {
            if (muteRate > 0 && Math.random() < muteRate)
                return;

            var i = 0;
            while ((i = Math.floor(Math.random() * this.seList.length)) === this.last && this.seList.length > 1);
            let se = this.seList[i];
            AudioManager.playSe(se)
            this.last = i;
        }

        isPlaying() {
            return this.getCurrentPlayingBuffers().length > 0
        }

        getCurrentPlayingBuffers(){
            const seNameList = this.seList.map(se => se.name);
            const playing = AudioManager._seBuffers.filter(buf => buf._isPlaying).filter((buf, i) => {
                if (seNameList.includes(buf.name)) {
                    return true;
                }
                return false;
            })

            return playing
        }


    }
    window[HbAudioController.name] = HbAudioController;
    window[HbSe.name] = HbSe;
    window[HbSeMulti.name] = HbSeMulti;
}
)()