



//=============================================================================
// RPG Maker MZ - HeroineVoices
//=============================================================================

/*:ja
 * @target MZ
 *
 * @author fude
 * @help
 * 本プラグインは、制作者が明示的に許可した場合を除き、いかなる形であれ使用、複製、改変、再配布することを禁じます。
 * 本プラグインを無断で使用したこと、またはその利用によって生じた不具合・損害について、制作者は一切の責任を負いません。
 *
*/

//===============================StateMachine==========================
const event_done = 'done';
const event_aegi_middle = 'aegi_middle';
const event_aegi_low = 'aegi_low';
const event_aegi_high = 'aegi_high';
const event_aegi_reach_orgasm = 'aegi_reachOrgasm';
const event_aegi_orgasm = 'aegi_orgasm';
const event_aegi_getFaster = 'aegi_get_faster';
const event_aegi_getSlower = 'aegi_get_slower';
const event_aegi_idle = 'aegi_idle';
(function () {
    class HeroineVoice extends StateMachine {
        constructor(owner) {
            super(owner);
            this._hbAudio = new HbAudioController();
            this.voices = voices;
            this.initTransition();
            this.start(NoSpeek);
        }

        initTransition() {
            this.addTransition(NoSpeek, AegiLow, event_aegi_low)
            this.addTransition(NoSpeek, AegiMiddle, event_aegi_middle)
            this.addTransition(NoSpeek, AegiHigh, event_aegi_high)
            this.addTransition(NoSpeek, IdleBreath, event_aegi_idle)

            this.addTransition(IdleBreath, AegiLow, event_aegi_low)
            this.addTransition(IdleBreath, AegiMiddle, event_aegi_middle)
            this.addTransition(IdleBreath, AegiHigh, event_aegi_high)
            // 喘ぎ終了
            this.addTransition(AegiLow, NoSpeek, event_done)
            this.addTransition(AegiMiddle, NoSpeek, event_done)
            this.addTransition(AegiHigh, NoSpeek, event_done)
            this.addTransition(AegiSlower, NoSpeek, event_done)
            this.addTransition(AegiFaster, NoSpeek, event_done)
            this.addTransition(IdleBreath, NoSpeek, event_done)
            this.addTransition(AegiReachOrgasm, NoSpeek, event_done)
            this.addTransition(AegiOrgasm, NoSpeek, event_done)

            // 速度上昇
            this.addTransition(AegiLow, AegiFaster, event_aegi_getFaster)
            this.addTransition(AegiMiddle, AegiFaster, event_aegi_getFaster)
            this.addTransition(AegiHigh, AegiFaster, event_aegi_getFaster)
            // 速度下降
            this.addTransition(AegiLow, AegiSlower, event_aegi_getSlower)
            this.addTransition(AegiMiddle, AegiSlower, event_aegi_getSlower)
            this.addTransition(AegiHigh, AegiSlower, event_aegi_getSlower)

            // アイドル状態
            this.addTransition(AegiLow, IdleBreath, event_aegi_idle)
            this.addTransition(AegiMiddle, IdleBreath, event_aegi_idle)
            this.addTransition(AegiHigh, IdleBreath, event_aegi_idle)

            // 絶頂喘ぎ
            this.addTransition(NoSpeek, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(IdleBreath, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(AegiSlower, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(AegiFaster, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(AegiLow, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(AegiMiddle, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(AegiHigh, AegiReachOrgasm, event_aegi_reach_orgasm)
            this.addTransition(AegiReachOrgasm, AegiOrgasm, event_aegi_orgasm)


        }

    }

    class VoiceStateBase extends StateBase {
        constructor(owner) {
            super(owner);
            this.hbAudio = owner._hbAudio;
        }

        onEnter() {
            this.hbAudio.register(this.getHeroineVoices()[this.key], this.key);
            if (SceneManager._scene instanceof Scene_Map && SceneManager._scene.isFastForward())
                return
            this.hbAudio.playRandom(this.key, 0)
        }

        onUpdate() {
            if (!this.hbAudio.isPlaying(this.regx))
                this.stm.dispatch(event_done);
        }

        onExit() {
            this.mute();
        }

        mute() {
            this.hbAudio.mute(this.regx);
        }

        getHeroineVoices() {
            return this.stm.voices;
        }

    }

    class NoSpeek extends VoiceStateBase {
        onEnter() {
            // console.log('nospeek')
        }
        onUpdate() {
        }
        mute() { }
    }

    class AegiMiddle extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_middle';
            this.regx = /aegi_middle/;
        }
        onEnter() {
            super.onEnter()
        }
    }

    class AegiHigh extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_high';
            this.regx = /aegi_high/;
        }
    }

    class AegiLow extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_low';
            this.regx = /aegi_low/;
        }
    }

    class AegiFaster extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_getFaster';
            this.regx = /aegi_getFaster/;
        }
    }

    class AegiSlower extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_getSlower';
            this.regx = /aegi_getSlower/;
        }
    }

    class AegiReachOrgasm extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_reach_orgasm';
            this.regx = /aegi_reach_orgasm/;
        }

        onUpdate() {
            if (!this.hbAudio.isPlaying(this.regx))
                this.stm.dispatch(event_aegi_orgasm);
        }

    }

    class AegiOrgasm extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'aegi_orgasm';
            this.regx = /aegi_orgasm/;
        }

        onUpdate() {
            if (!$gameSwitches.value(24)) {
                this.stm.dispatch(event_done);
            }
        }
    }

    class IdleBreath extends VoiceStateBase {
        constructor(owner) {
            super(owner);
            this.key = 'idle_breath';
            this.regx = /idle_breath/;
        }
        onExit() {
            super.onExit()
        }
        onEnter() {
            super.onEnter()
        }
    }

    const voices = {

        aegi_low: [
            { name: "heroine_voices/erotic/aegi_hot_01", volume: 120, pitch: 106 },
        ],

        aegi_middle: [
            { name: "heroine_voices/erotic/aegi_hot_02", volume: 140, pitch: 106 },
        ],

        aegi_high: [
            { name: "heroine_voices/erotic/aegi_hot_03", volume: 150, pitch: 116 },
        ],

        aegi_getFaster: [
            { name: "heroine_voices/erotic/aegi_breath_4", volume: 140, pitch: 106 },
            { name: "heroine_voices/erotic/aegi_breath_6", volume: 140, pitch: 106 },
            { name: "heroine_voices/erotic/aegi_breath_7", volume: 140, pitch: 106 },
        ],

        aegi_getSlower: [
            { name: "heroine_voices/erotic/aegi_long_1", volume: 140, pitch: 106 },
            { name: "heroine_voices/erotic/aegi_short_11", volume: 140, pitch: 106 },
            { name: "heroine_voices/erotic/aegi_short_2", volume: 140, pitch: 106 },
        ],

        idle_breath: [
            { name: "heroine_voices/erotic/kakokyuu_03", volume: 140, pitch: 106 },
        ],

        aegi_reach_orgasm: [
            { name: "heroine_voices/erotic/Orgasm_hot", volume: 140, pitch: 100 },
        ],

        aegi_orgasm: [
            { name: "heroine_voices/erotic/aegi_intence_01", volume: 140, pitch: 100 },
        ],
    }

    window[HeroineVoice.name] = HeroineVoice;
    window[VoiceStateBase.name] = VoiceStateBase;
    window[NoSpeek.name] = NoSpeek;
    window[AegiLow.name] = AegiLow;
    window[AegiMiddle.name] = AegiMiddle;
    window[AegiHigh.name] = AegiHigh;
    window[IdleBreath.name] = IdleBreath;
    window[AegiSlower.name] = AegiSlower;
    window[AegiFaster.name] = AegiFaster;
    window[AegiReachOrgasm.name] = AegiReachOrgasm;
    window[AegiOrgasm.name] = AegiOrgasm;

})()