//=============================================================================
// JSONExPatcher
// By Ramiro Rojo
// DragonUI.js
// Version: 1.0.0
// Released under CC0 Universal 1.0
// You can read the full license from here:
//    https://creativecommons.org/publicdomain/zero/1.0/legalcode
// but basically means "public domain" in fancy words
//=============================================================================
/*:
 * @plugindesc  Allows people to use the JSONEx with namespace classes.
 *
 * To use it, just do a Function.serializeName = 'TheNameOfMyFunction';
 * And it will work if your class is not "standard"
 * As a bonus, if you create a class inside an object using 'MyModule.MyClass'
 * will load too without any problems.
 * It overrides JsonEx._decode and JsonEx._getConstructorName, so ve aware
 */


 /**
  * @static
  * @method _decode
  * @param {Object} value
  * @return {Object}
  * @private
  */


 /**
  * @static
  * @method _getConstructorName
  * @param {Object} value
  * @return {String}
  * @private
  */
 JsonEx._getConstructorName = function(value) {
   var name;
   if (value.constructor.serializeName) {
     name = value.constructor.serializeName;
   } else {
     name = value.constructor.name;
   }
   if (name === undefined) {
     var func = /^\s*function\s*([A-Za-z0-9_$]*)/;
     name = func.exec(value.constructor)[1];
   }
   return name;
 };

/**
 * @static
 * @method _resetPrototype
 * @param {Object} value
 * @param {Object} prototype
 * @return {Object}
 * @private
 */
 JsonEx._resetPrototype = function(value, prototype) {
  if (Object.setPrototypeOf !== undefined) {
      Object.setPrototypeOf(value, prototype);
  } else if ('__proto__' in value) {
      value.__proto__ = prototype;
  } else {
      var newValue = Object.create(prototype);
      for (var key in value) {
          if (value.hasOwnProperty(key)) {
              newValue[key] = value[key];
          }
      }
      value = newValue;
  }
  return value;
};
