/*:ja
 * @author fude
 * @help ステートマシンクラスを提供します
 *
 */
(function () {


    //============================= StateMachine ===============================

    class StateMachine {
        constructor(owner) {
            this._owner = owner;
            this._currentState = {};
            this._states = [];
        }

        addState(Cls) {
            let state = new Cls(this);
            this._states.push(state);
            return state;
        }

        getState(Cls) {
            for (var state of this._states) {
                if (state instanceof Cls)
                    return state
            }
            return this.addState(Cls)
        }

        addTransition(from, to, eventId) {
            let objFrom = this.getState(from);
            if (eventId in objFrom.transitions) {
                console.log(objFrom.constructor.name, 'に対してイベント', eventId, 'の遷移は定義済')
                return;
            }
            let objTo = this.getState(to);
            objFrom.transitions[eventId] = objTo;
        }

        addFreeTransition(To, eventId)  // どのステートからでも指定のステートに遷移できるイベントを登録する
        {
            this.addTransition(StatePhantom, To, eventId);
        }

        addAction(action, State, eventId) {
            let state = this.getState(State);
            if (eventId in state.actions) {
                console.log(state.constructor.name, 'に対してイベント', eventId, 'のアクションは定義済')
                return;
            }
            state.actions[eventId] = action;
        }

        addFreeAction(action, eventId) // どのステートからでも指定のアクションを実行するイベントを登録する
        {
            this.addAction(StatePhantom, action, eventId);
        }

        start(Cls) {
            this._currentState = this.getState(Cls);
            this._currentState.enter(null);
        }

        update() {
            this._currentState.update();
        }

        dispatch(eventId) {
            let cac = this._currentState.actions
            if (!(eventId in cac)) {
                let pac = this.getState(StatePhantom).actions;
                if (eventId in pac)
                    pac[eventId]()
            } else {
                cac[eventId]();
            }

            let ctr = this._currentState.transitions
            if (!(eventId in ctr)) {
                let ptr = this.getState(StatePhantom).transitions;
                if (eventId in ptr) {
                    this.change(ptr[eventId]);
                }
            } else {
                this.change(ctr[eventId]);
            }
        }

        change(next) {
            this._currentState.exit(next);
            next.enter(this._currentState);
            this._currentState = next;
        }
    }

    //============================= StateBase ===============================

    class StateBase {
        constructor(stateMachine) {
            this.stm = stateMachine;
            this.transitions = {};
            this.actions = {};
        }

        enter(prevState) {
            this.onEnter(prevState);
        }

        onEnter(prevState) { }

        update() {
            this.onUpdate();
        }

        onUpdate() { }

        exit(nextState) {
            this.onExit(nextState);
        }

        onExit(nextState) { };
    }

    class StatePhantom extends StateBase { }
    
    window[StateMachine.name] = StateMachine;
    window[StateBase.name] = StateBase;
    window[StatePhantom.name] = StatePhantom;
}
)()