//=============================================================================
// RPG Maker MZ - TransferToEvent
//=============================================================================

/*:ja
 * @target MZ
 * @author fude
 * @help
 * 本プラグインは、制作者が明示的に許可した場合を除き、いかなる形であれ使用、複製、改変、再配布することを禁じます。
 * 本プラグインを無断で使用したこと、またはその利用によって生じた不具合・損害について、制作者は一切の責任を負いません。
 * 
 * @plugindesc 場所移動をイベント位置で指定する
 * 
 * @command setTransferOffset
 * @text 場所移動時オフセット指定
 * @desc イベント位置への移動時オフセットを指定する
 * @arg x
 * @type number
 * @default 0
 * @arg y
 * @type number
 * @default 0
 * 
*/
(function () {
    'use strict';
    const pluginName = 'TransferToEvent';

    const gameTemp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function () {
        this._transferId;
        this._transferOffsetX;
        this._transferOffsetY;
        gameTemp_initialize.apply(this, arguments);
    };

    Game_Temp.prototype.clearTransferInfo = function () {
        this._transferId = '';
        this._transferOffsetX = 0;
        this._transferOffsetY = 0;
    }

    // Transfer Player
    const _Game_Interpreter_command201 = Game_Interpreter.prototype.command201;
    Game_Interpreter.prototype.command201 = function (params) {
        const target = $gameMap.event(this.eventId());
        if (target) {
            const transferId = target.event()?.meta.transfer
            if (transferId) {
                $gameTemp._transferId = transferId;
            }
        }
        return _Game_Interpreter_command201.apply(this, arguments);
    };

    const _Game_Player_performTransfer = Game_Player.prototype.performTransfer;
    Game_Player.prototype.performTransfer = function () {
        const tarnsfarId = $gameTemp._transferId;
        if (tarnsfarId) {
            const targetEvent = $dataMap.events.find(e => e?.meta.transfer === tarnsfarId);
            if (targetEvent) {
                const direction = this._newDirection
                this._newX = $gameMap.roundXWithDirection(targetEvent.x, direction) + $gameTemp._transferOffsetX;
                this._newY = $gameMap.roundYWithDirection(targetEvent.y, direction) + $gameTemp._transferOffsetY;
            }
        }
        $gameTemp.clearTransferInfo();
        _Game_Player_performTransfer.apply(this, arguments);
    };

    //
    // process plugin commands
    //
    PluginManager.registerCommand(pluginName, 'setTransferOffset', function (args) {
        const x = +args.x;
        const y = +args.y;
        if (x || y) {
            $gameTemp._transferOffsetX = x;
            $gameTemp._transferOffsetY = y;
        }
    });


})();