/*:
 * @target MZ
 * @plugindesc メニューと装備/ステータスでアクター1以外を非表示＆切り替え無効にします
 * @author ChatGPT
 * 
 * @help
 * このプラグインは、メニュー画面や各種アクター選択シーンで
 * 1番目のアクター（インデックス0）以外を表示しないようにします。
 * 
 * ■ 機能
 * - メニュー画面の「アクター選択ウィンドウ」にアクター1だけを表示
 * - 装備・ステータス画面などのアクター切り替えを禁止
 * 
 * プラグインコマンドやパラメータはありません。
 */

(() => {
  // アクター選択ウィンドウでアクター1以外を表示しない
  const _Window_MenuStatus_initialize = Window_MenuStatus.prototype.initialize;
  Window_MenuStatus.prototype.initialize = function(rect) {
    _Window_MenuStatus_initialize.call(this, rect);
    this._onlyFirstActor = true;
  };

  const _Window_MenuStatus_numVisibleRows = Window_MenuStatus.prototype.numVisibleRows;
  Window_MenuStatus.prototype.numVisibleRows = function() {
    return this._onlyFirstActor ? 4 : _Window_MenuStatus_numVisibleRows.call(this);
  };

  Window_MenuStatus.prototype.maxItems = function() {
    return this._onlyFirstActor ? 1 : $gameParty.members().length;
  };

Window_MenuStatus.prototype.drawItem = function(index) {
  if (this._onlyFirstActor && index > 0) return;
  const actor = this.actor(index);
  const rect = this.itemRect(index);
  this.drawItemImage(index);
  this.drawItemStatus(index);
};

  Window_MenuStatus.prototype.actor = function(index) {
    return $gameParty.members()[0]; // 固定でアクター1を返す
  };

Window_SavefileList.prototype.drawPartyCharacters = function(info, x, y) {
  if (info.characters && info.characters.length > 0) {
    const data = info.characters[0]; // 先頭のアクターのみ
    const [characterName, characterIndex] = data;
    const spacing = 48;
    const cx = x;
    const cy = y;
    this.drawCharacter(characterName, characterIndex, cx, cy);
  }
};

  // アクター切り替え機能を無効にする共通関数
  const lockToFirstActor = function(sceneClass) {
    const _create = sceneClass.prototype.create;
    sceneClass.prototype.create = function() {
      _create.call(this);
      this._actor = $gameParty.members()[0];
    };

    const _onActorChange = sceneClass.prototype.onActorChange;
    sceneClass.prototype.onActorChange = function() {
      // なにもしない＝切り替えできなくする
    };
  };

  lockToFirstActor(Scene_Status);
  lockToFirstActor(Scene_Equip);
  lockToFirstActor(Scene_Skill);
})();
