//=============================================================================
// HSMZ_Custom_EquipCommonEvent.js（改修版）
// 装備変更・装備解除時にコモンイベントを実行し、
// 防具を外したときはIDを変数24、etypeIdを変数23に保存（4/22）
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 装備変更または装備解除時にコモンイベントを実行、防具IDとetypeIdを変数に保存
 * @author n2naokun（改修 by メリケン）
 *
 * @help
 * 【装備したとき】
 * 装備アイテムのメモ欄に以下を記述：
 *   <EquipCommonEvent:コモンイベントID,アクターID>
 *
 * 【装備を外したとき】
 * アクターのメモ欄に以下を記述：
 *   <UnequipCommonEvent:コモンイベントID,スロットID>
 *
 * 防具を外したときに以下の変数に代入されます：
 *   変数24番：防具ID
 *   変数23番：装備タイプID（etypeId）
 */

"use strict";

var Imported = Imported || {};
Imported.HSMZ_Custom_EquipCommonEvent = true;

(function () {

    const _Scene_Equip_executeEquipChange = Scene_Equip.prototype.executeEquipChange;
    Scene_Equip.prototype.executeEquipChange = function () {
        const actor = this.actor();
        const slotId = this._slotWindow.index();
        const oldItem = actor.equips()[slotId];
        const newItem = this._itemWindow.item(); // null なら装備解除

        // ▼ 装備解除時に、防具だった場合はIDとetypeIdを保存
        if (!newItem && oldItem && DataManager.isArmor(oldItem)) {
            $gameVariables.setValue(24, oldItem.id);       // 防具ID
            $gameVariables.setValue(23, oldItem.etypeId);  // 装備タイプID
        }

        // ▼ 通常装備処理
        _Scene_Equip_executeEquipChange.call(this);

        // ▼ コモンイベント判定
        let commonEventId = null;

        if (newItem) {
            commonEventId = this.extractEquipCommonEvent(newItem, actor);
        } else {
            commonEventId = this.extractUnequipCommonEvent(actor, slotId);
        }

        if (commonEventId != null) {
            this._commonEvent = $gameTemp.setupMenuCommonEvent(commonEventId, "Scene_Equip", 0);
        }

        if (this.hasCommonEvent()) {
            if (!this._spriteset) this.createSpriteset();
            if (!this._messageWindow) {
                this.createAllMessageWindow();
            }
        }
    };

    Scene_Equip.prototype.extractEquipCommonEvent = function (item, actor) {
        if (!item) return null;
        const regExp = /<EquipCommonEvent:([0-9]+),([0-9]+)>/g;
        const note = item.note;
        const actorId = actor.actorId();
        let match;
        let result = null;

        while ((match = regExp.exec(note)) !== null) {
            const eventId = Number(match[1]);
            const targetId = Number(match[2]);
            if (actorId === targetId) {
                result = eventId;
                break;
            }
        }

        return result;
    };

    Scene_Equip.prototype.extractUnequipCommonEvent = function (actor, slotId) {
        if (!actor) return null;
        const regExp = /<UnequipCommonEvent:([0-9]+),([0-9]+)>/g;
        const note = actor.actor().note;
        let match;
        let result = null;

        while ((match = regExp.exec(note)) !== null) {
            const eventId = Number(match[1]);
            const targetSlot = Number(match[2]);
            if (slotId === targetSlot) {
                result = eventId;
                break;
            }
        }

        return result;
    };

})();
