/*:
 * @target MZ
 * @plugindesc ステート合成：ステートA + B = C をパラメータで設定可能（解除時Cも解除）するプラグインです。
 * @author ChatGPT
 * 
 * @param CompositeStates
 * @text 合成ステート一覧
 * @type struct<CompositeState>[]
 * @desc ステートAとBの組み合わせでステートCを自動付与します。AまたはBが解除されるとCも解除されます。
 */

/*~struct~CompositeState:
 * @param stateA
 * @text ステートA
 * @type state
 * @desc 合成の条件となるステートAのID
 * 
 * @param stateB
 * @text ステートB
 * @type state
 * @desc 合成の条件となるステートBのID
 * 
 * @param result
 * @text 合成ステートC
 * @type state
 * @desc ステートAとBが揃ったとき自動付与されるステートCのID
 */

(() => {
  const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];

  const parameters = PluginManager.parameters(pluginName);
  const compositeStatesRaw = JSON.parse(parameters["CompositeStates"] || "[]");

  const compositeStates = compositeStatesRaw.map(entry => {
    const data = JSON.parse(entry);
    return {
      a: Number(data.stateA),
      b: Number(data.stateB),
      result: Number(data.result),
    };
  });

  const _Game_Battler_addNewState = Game_Battler.prototype.addNewState;
  Game_Battler.prototype.addNewState = function(stateId) {
    _Game_Battler_addNewState.call(this, stateId);
    this.checkCompositeStates();
  };

  const _Game_Battler_eraseState = Game_Battler.prototype.eraseState;
  Game_Battler.prototype.eraseState = function(stateId) {
    _Game_Battler_eraseState.call(this, stateId);
    this.checkRemoveCompositeStates(stateId);
  };

  Game_Battler.prototype.checkCompositeStates = function() {
    for (const entry of compositeStates) {
      if (this.isStateAffected(entry.a) && this.isStateAffected(entry.b)) {
        if (!this.isStateAffected(entry.result)) {
          this.addState(entry.result);
        }
      }
    }
  };

  Game_Battler.prototype.checkRemoveCompositeStates = function(removedStateId) {
    for (const entry of compositeStates) {
      if (
        (removedStateId === entry.a || removedStateId === entry.b) &&
        this.isStateAffected(entry.result)
      ) {
        this.removeState(entry.result);
      }
    }
  };
})();
