/*:
 * @target MZ
 * @plugindesc 装備画面のヘルプウィンドウを装備スロットの下に配置し、同じ幅に揃えます。
 * @author YourName
 * @help
 * このプラグインを導入すると、Scene_Equip に表示される
 * ヘルプウィンドウ（アイテム説明）が装備スロットの下に表示され、
 * 幅もスロットウィンドウと同じになります。
 *
 * 利用規約: 商用・非商用問わず自由に利用・改変可能（MITライセンス相当）
 */

(() => {
    const pluginName = "EquipHelpWindowBelowSlot";

    Scene_Equip.prototype.helpWindowRect = function() {
        // ステータスウィンドウの幅（＝スロットの左端）
        const statusW = this.statusWidth();
        const wx = statusW;
        const ww = Graphics.boxWidth - statusW;

        // スロットウィンドウの下に接続するために、そこの高さを取得
        const slotWindowHeight = this.slotWindowRect().height;
        const wy = slotWindowHeight;

        // ヘルプウィンドウの高さ（標準2行分）
        const wh = this.calcWindowHeight(2, false);

        return new Rectangle(wx, 520, ww, wh);
    };
})();
