//=============================================================================
// IZNB_ReplaceFileName.js
//=============================================================================

/*:
 * @plugindesc 読み込み画像変更(変数No.26固定)
 * @author Izunabi
 * @requiredAssets img/faces/another_ori1
 * @requiredAssets img/faces/another_ori2
 * @requiredAssets img/faces/ori_ori1
 * @requiredAssets img/faces/ori_ori2
 * @requiredAssets img/faces/ori1
 * @requiredAssets img/faces/ori2
 * @requiredAssets img/system/ButtonSet72
 * @requiredAssets img/system/Shadow1
 * @requiredAssets img/system/Shadow2
 */

(function(){
    'use strict';
    Game_Interpreter.prototype.IZNB_RFN_Action = function( value ) {
            switch (value) {
            case 'n': // Normal
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsNormal;
                break;
            case 'a': // Another
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsAnother;
                break;
            default: // switching by value
                if (1 == $gameVariables.value(26)) {
                    ReplaceNameList_Effective.img = ReplaceNameList.imgAsAnother;
                } else {
                    ReplaceNameList_Effective.img = ReplaceNameList.imgAsNormal;
                }
                break;
            }
    };

    var parameters = PluginManager.parameters('IZNB_ReplaceFileName');
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;




// ====================================================================

    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'IZNBRFN') {

            switch (args[0]) {
            case 'n': // Normal
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsNormal;
                break;
            case 'a': // Another
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsAnother;
                break;
            default: // switching by value
                if ($gameVariables.value(26) == 0) {
                    ReplaceNameList_Effective.img = ReplaceNameList.imgAsAnother;
                } else {
                    ReplaceNameList_Effective.img = ReplaceNameList.imgAsNormal;
                }
                break;
            }
        }
    };

// ====================================================================

    var ReplaceNameList = {
        img:{
        "img/faces/ori1.png":"img/faces/ori1.png",
        "img/faces/ori2.png":"img/faces/ori2.png",
        },
        imgAsNormal:{
        "img/faces/ori1.png":"img/faces/ori_ori1.png",
        "img/faces/ori2.png":"img/faces/ori_ori2.png",
        },
        imgAsAnother:{
        "img/faces/ori1.png":"img/faces/another_ori1.png",
        "img/faces/ori2.png":"img/faces/another_ori2.png",
        },

        audio:{
        },
        movies:{
        }
    };


    var ReplaceNameList_Effective = {

        img:{
        "img/faces/ori1.png":"img/faces/another_ori1.png",
        "img/faces/ori2.png":"img/faces/another_ori2.png",
        }

    };

// ====================================================================


    
    var _Bitmap_load = Bitmap.load;
    Bitmap.load = function(url) {
        var _url = decodeURIComponent(url);
        if (ReplaceNameList_Effective.img.hasOwnProperty(_url)) {
            if ($gameVariables.value(26) == 0) {
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsAnother;
            } else {
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsNormal;
            }
            url = ReplaceNameList_Effective.img[_url];
        }
        return _Bitmap_load.call(this, url);
    };
    
    var _Bitmap_request = Bitmap.request;
    Bitmap.request = function(url) {
        var _url = decodeURIComponent(url);
        if (ReplaceNameList_Effective.img.hasOwnProperty(_url)) {
            if ($gameVariables.value(26) == 0) {
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsAnother;
            } else {
                ReplaceNameList_Effective.img = ReplaceNameList.imgAsNormal;
            }
            url = ReplaceNameList_Effective.img[_url];
        }
        return _Bitmap_request.call(this, url);
    };
    

}());
