//=============================================================================
// IZNB_SelfCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2022 Izunabi
// 使う人いるん？
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2017/04/18 初版。とりあえずコアスクリプトを直接書き換えてた部分を移動
// 1.0.1 2022/12/04 改版。見聞録用にいろいろいじったよ
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/izunabiIS
//=============================================================================

/*:
 * 
 * @plugindesc Izunabi Self Custom
 * @author Izunabi
 * @requiredAssets img/system/DirPad
 * @requiredAssets img/system/CancelButton
 * @requiredAssets img/system/ActionButton
 * 
 */
/*:ja
 * YEP_SkillLearning.jsの下に配置すること。
 * YEP_SKillLearning.jsを使わない場合、Scene_LearnSkillに関する処理は削ること。
 * 
 * @plugindesc Izunabi用　YEP_SkillLearning.jsの下に配置すること
 * @author Izunabi
 * @help なんとなく分かる思う
 *
 * 利用規約：
 *  勝手に使って下さい
 
 * @requiredAssets img/system/DirPad
 * @requiredAssets img/system/CancelButton
 * @requiredAssets img/system/ActionButton
 */

/*
// 「逃げる」が確定成功
BattleManager.processEscape = function() {
    $gameParty.performEscape();
    SoundManager.playEscape();
    var success = this._preemptive ? true : (Math.random() < this._escapeRatio);
// Izunabi修正 常にtrueにする start
    //常にtrueにする
    success = true;
// Izunabi修正 常にtrueにする end
    if (success) {
        this.displayEscapeSuccessMessage();
        this._escaped = true;
        this.processAbort();
    } else {
        this.displayEscapeFailureMessage();
        this._escapeRatio += 0.1;
        $gameParty.clearActions();
        this.startTurn();
    }
    return success;
};
*/

/*
// 状態異常攻撃の計算式から運を除外
// 防御やスキル側の追加効果ステート付与計算式(普通の状態異常)
Game_Action.prototype.itemEffectAddAttackState = function(target, effect) {
    this.subject().attackStates().forEach(function(stateId) {
        var chance = effect.value1;
        chance *= target.stateRate(stateId);
        chance *= this.subject().attackStatesRate(stateId);
// Izunabi修正 攻撃側のステート70(デバフ成功UP)、防御側のステート71(デバフ耐性ダウン)率に補正を入れる start
        //chance *= this.lukEffectRate(target);
        var stateRateAdditional = 0
        // 攻撃側倍率 + 防御側倍率計算：
        //   倍率から1を減算した値を足し込み、最後に再度1を足し込む。
        //   1:1の場合0+0+1=1、4:1の場合3+0+1=4、4:4の場合3+3+1=7
        stateRateAdditional += this.subject().stateRate(70) - 1;
        stateRateAdditional += target.stateRate(69) - 1;
        stateRateAdditional += 1;
        // 得られた追加ステート成功率を掛け算する
        chance *= stateRateAdditional;
// Izunabi修正 攻撃側のステート70(デバフ成功UP)、防御側のステート71(デバフ耐性ダウン)で率に補正を入れる end
        if (Math.random() < chance) {
            if (stateId === target.deathStateId()) {
              if (target.isImmortal()) target.removeImmortal();
            }
            target.addState(stateId);
            this.makeSuccess(target);
        }
    }.bind(this), target);
};
*/

/*
Game_Action.prototype.itemEffectAddNormalState = function(target, effect) {
    var stateId = effect.dataId;
    var chance = effect.value1;
//    if (!this.isCertainHit()) {
      chance *= target.stateRate(stateId);
//      chance *= this.lukEffectRate(target);
//    }
// Izunabi修正 攻撃側のステート70(デバフ成功UP)、防御側のステート71(デバフ耐性ダウン)率に補正を入れる start
        //chance *= this.lukEffectRate(target);
        var stateRateAdditional = 0
        // 攻撃側倍率 + 防御側倍率計算：
        //   倍率から1を減算した値を足し込み、最後に再度1を足し込む。
        //   1:1の場合0+0+1=1、4:1の場合3+0+1=4、4:4の場合3+3+1=7
        stateRateAdditional += this.subject().stateRate(70) - 1;
        stateRateAdditional += target.stateRate(69) - 1;
        stateRateAdditional += 1;
        // 得られた追加ステート成功率を掛け算する
        chance *= stateRateAdditional;
// Izunabi修正 攻撃側のステート70(デバフ成功UP)、防御側のステート71(デバフ耐性ダウン)で率に補正を入れる start
    if (Math.random() < chance) {
      if (stateId === target.deathStateId()) {
        if (target.isImmortal()) target.removeImmortal();
      }
      target.addState(stateId);
      this.makeSuccess(target);
    }
};
*/

/*
// 運による計算をしない
Game_Action.prototype.lukEffectRate = function(target) {
// Izunabi修正　運による変化を削除、常に1.0を返す
//    return Math.max(1.0 + (this.subject().luk - target.luk) * 0.001, 0.0);
    return Math.max(1.0);
// Izunabi修正
};
*/

/*
// 先制攻撃なし
Game_Party.prototype.ratePreemptive = function(troopAgi) {
    var rate = this.agility() >= troopAgi ? 0.05 : 0.03;
    if (this.hasRaisePreemptive()) {
        rate *= 4;
    }
    // 先制攻撃自体を発生させない by Izunabi
    rate = 0;
    return rate;
};
*/
/*
// 不意打ちなし
Game_Party.prototype.rateSurprise = function(troopAgi) {
    var rate = this.agility() >= troopAgi ? 0.03 : 0.05;
    if (this.hasCancelSurprise()) {
        rate = 0;
    }
    // 不意打ち自体を発生させない by Izunabi
    rate = 0;
    return rate;
};
*/




/*
// 敵遭遇しない最低保証値変更
Game_Player.prototype.makeEncounterCount = function() {
    var n = $gameMap.encounterStep();
    // Izunabi修正
//    this._encounterCount = Math.randomInt(n) + Math.randomInt(n) + 1;
    // 遭遇率の歩数変更、最低保証値を4歩に
    this._encounterCount = Math.randomInt(n) + Math.randomInt(n) + 4;
};
*/


// 文章表示時に常に\>が指定されている状態にする。\<で戻せるよ
Window_Base.prototype.obtainEscapeString = function(textState) {
    var arr = /^\<(.*?)\>/.exec(textState.text.slice(textState.index));
//    if (arr) {
        textState.index += arr[0].length;
        return String(arr[0].slice(1, arr[0].length - 1));
//    } else {
//        return '';
//    }
};
Window_Message.prototype.processEscapeCharacter = function(code, textState) {
    this._lineShowFast = true; // 常にtrueにする
    switch (code) {
    case '$':
        this._goldWindow.open();
        break;
    case '.':
        this.startWait(15);
        break;
    case '|':
        this.startWait(60);
        break;
    case '!':
        this.startPause();
        break;
//    case '>': // この分岐は要らない
//        this._lineShowFast = true;
//        break;
    case '<':
        this._lineShowFast = false;
        break;
    case '^':
        this._pauseSkip = true;
        break;
    default:
        Window_Base.prototype.processEscapeCharacter.call(this, code, textState);
        break;
    }
};
Window_Message.prototype.clearFlags = function() {
    this._showFast = false;
//    this._lineShowFast = false;
    this._lineShowFast = true; // 常にtrueにする
    this._pauseSkip = false;
};
Window_Message.prototype.processNewLine = function(textState) {
//    this._lineShowFast = false;
    this._lineShowFast = true; // 常にtrueにする
    Window_Base.prototype.processNewLine.call(this, textState);
    if (this.needsNewPage(textState)) {
        this.startPause();
    }
};


// 文字列の、\{ \} を実行したときのフォントサイズ変更幅を縮める

Window_Base.prototype.makeFontBigger = function() {
    if (this.contents.fontSize <= 96) {
//        this.contents.fontSize += 12;
        this.contents.fontSize += 6;
    }
};

Window_Base.prototype.makeFontSmaller = function() {
    if (this.contents.fontSize >= 24) {
//        this.contents.fontSize -= 12;
        this.contents.fontSize -= 6;
    }
};




/*
// 装備欄から自動装備と解除を削除
// YEP_EquipCore.jsを利用している場合用
Window_EquipCommand.prototype.makeCommandList = function() {
    this.addCommand(TextManager.equip2,   'equip');
    this.addCommand(Yanfly.Param.EquipFinishCmd, 'cancel');
    // 装備欄から自動装備と解除を削除
//    this.addCommand(TextManager.optimize, 'optimize');
//    this.addCommand(TextManager.clear,    'clear');
};
*/

Scene_Equip.prototype.createCommandWindow = function() {
    var wx = this._statusWindow.width;
    var wy = this._helpWindow.height;
    var ww = Graphics.boxWidth - this._statusWindow.width;
    this._commandWindow = new Window_EquipCommand(wx, wy, ww);
    this._commandWindow.setHelpWindow(this._helpWindow);
    this._commandWindow.setHandler('equip',    this.commandEquip.bind(this));
//    this._commandWindow.setHandler('optimize', this.commandOptimize.bind(this));
    this._commandWindow.setHandler('clear',    this.commandClear.bind(this));
    this._commandWindow.setHandler('cancel',   this.popScene.bind(this));
    this._commandWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._commandWindow.setHandler('pageup',   this.previousActor.bind(this));
    this.addWindow(this._commandWindow);
};

Window_EquipCommand.prototype.makeCommandList = function() {
    this.addCommand(TextManager.equip2,   'equip');
//    this.addCommand(TextManager.optimize, 'optimize');
    this.addCommand(TextManager.clear,    'clear');
};



// これはプラグインで制御するため除去
//// クリティカル発生時のダメージを3倍　→　1.25倍に修正
//Game_Action.prototype.applyCritical = function(damage) {
////    return damage * 3;
//    return damage * 1.25;
//};

/*
// パーティコマンドの幅を変更する
Window_PartyCommand.prototype.windowWidth = function() {
//    return 192;
    return 192;
};
*/

/*
// パーティコマンドの表示行数を変更する
Window_PartyCommand.prototype.numVisibleRows = function() {
//    return 4;
    return 6;
};
*/




// ステータス画面の描画を変更する



// 基礎情報出力
Window_Status.prototype.drawBasicInfo = function(x, y) {

    var ds = this._actor.currentClass().meta;
    
    var lineHeight = this.lineHeight();
    this.drawActorLevel(this._actor, x, (y + lineHeight * 0)-16);
    this.drawActorIcons(this._actor, x + 96, (y + lineHeight * 0)-18);
    this.drawActorHp(this._actor, x, (y + lineHeight * 1)-18);
    this.drawActorMp(this._actor, x, (y + lineHeight * 2)-20);
//    this.drawActorTp(this._actor, x, (y + lineHeight * 3)-22, 185);
    if (ds.iznbClassId == 1) {
        
        this.changeTextColor(this.systemColor());
        this.drawText('※()内:基礎値 + 会話 + 装備・状態補正', x, (y + lineHeight * 3)-12);
        
        var paramId = 0;
        this.changeTextColor(this.systemColor());
        var paramBase = $gameActors.actor(1).paramBase(paramId);
        var paramTalk = $gameVariables.value(71 + paramId);
        var paramEquip = this._actor.param(paramId) - paramBase - paramTalk;
        var paramTextBuild = '(';
        paramTextBuild += ( '   ' + paramBase ).slice( -3);
        paramTextBuild += ' + ';
        paramTextBuild += ( '   ' + paramTalk ).slice( -3);
        paramTextBuild += ' + ';
        paramTextBuild += ( '   ' + paramEquip ).slice( -3);
        paramTextBuild += ')';
        this.drawText(paramTextBuild, x + 200, (y + lineHeight * 1)-18);
        
        
        paramId = 1;
        this.changeTextColor(this.systemColor());
        paramBase = $gameActors.actor(1).paramBase(paramId);
        paramTalk = $gameVariables.value(71 + paramId);
        paramEquip = this._actor.param(paramId) - paramBase - paramTalk;
        paramTextBuild = '(';
        paramTextBuild += ( '   ' + paramBase ).slice( -3);
        paramTextBuild += ' + ';
        paramTextBuild += ( '   ' + paramTalk ).slice( -3);
        paramTextBuild += ' + ';
        paramTextBuild += ( '   ' + paramEquip ).slice( -3);
        paramTextBuild += ')';
        this.drawText(paramTextBuild, x + 200, (y + lineHeight * 2)-20);

        this.drawYourHistory(x, y);

    }
    
/*
    var jp = this._actor.jp(this._actor.currentClass().id);
    var jp = this._actor.jp(this._actor.currentClass().id);
    var jpIcon = Yanfly.Icon.Jp;
    
    //this.changeTextColor(this.systemColor());
    this.drawIcon(jpIcon, x + 96, (y + lineHeight * 0)-16);
    this.drawText(jp, x + 96 + 32, (y + lineHeight * 0)-16);
*/

};

// 水平ラインとブロック描画
Window_Status.prototype.refresh = function() {
    this.contents.clear();
    if (this._actor) {
/*
        var lineHeight = this.lineHeight();
        this.drawBlock1(lineHeight * 0);
        this.drawHorzLine(lineHeight * 1);
        this.drawBlock2(lineHeight * 2);
        this.drawHorzLine(lineHeight * 6);
        this.drawBlock3(lineHeight * 7);
        this.drawHorzLine(lineHeight * 13);
        this.drawBlock4(lineHeight * 14);
*/
        // 文字サイズ変更と水平ライン除去
        this.contents.fontSize = 28;
        var lineHeight = this.lineHeight();
        var blockLineHeight = 32;
        this.drawBlock1(blockLineHeight * 0);
        this.drawBlock2(blockLineHeight * 1.2);
        this.drawBlock3(blockLineHeight * 6.3);
        this.drawBlock4(blockLineHeight * 14.6);

    }
};

// ウィンドウブロックごとの出力内容

// 最上部 名前表示欄
//var iznbMasterSprite = new Sprite(ImageManager.loadPicture("00_master_stand_75"));
//var iznbMasterSprite_panaka = new Sprite(ImageManager.loadPicture("00_master_panaca_stand_75"));

Window_Status.prototype.drawBlock1 = function(y) {
//    this.drawActorName(this._actor, 6, y);
//    this.drawActorClass(this._actor, 192, y);
//    this.drawActorNickname(this._actor, 432, y);
    this.contents.fontSize = 26;
    var ds = this._actor.currentClass().meta;
    if (ds.profHero == 1) {
        // クウの場合
        this.drawText(' ' + $gameVariables.value(181) + ds.profNameAdd, 6, y);
        this.drawText(ds.profClass, 360, y);
    } else if (ds.profHero == 2) {
        // ルウの場合
        this.drawText(' ' + $gameVariables.value(182) + ds.profNameAdd, 6, y);
        this.drawText(ds.profClass, 360, y);
    } else {
        var anotherFlag = 0;
        if (ds.profAnotherFlag) {
            anotherFlag = Number(ds.profAnotherFlag);
        }
        if (anotherFlag > 0 && $gameSwitches.value(anotherFlag)) {
            this.drawText(ds.profNameA, 6, y);
            this.drawText(ds.profClassA, 360, y);
        } else {
            this.drawText(ds.profName, 6, y);
            this.drawText(ds.profClass, 360, y);
        }
    }

/*
    var sprite = iznbMasterSprite;
    var spritePanaka = iznbMasterSprite_panaka;
    var targetSprite;
    if ($gameSwitches.value(39)) {
        targetSprite = spritePanaka;
    } else {
        targetSprite = sprite;
    }
    if (ds.iznbClassId == 2) {
        targetSprite.x = 600;
        targetSprite.y = 350;
        targetSprite.anchor.x = 0.5;
        targetSprite.anchor.y = 0.5;
        targetSprite.visible = true;
        this.addChild(targetSprite);
        if ($gameSwitches.value(39)) {
            this.drawText('パナカ', 6, y);
        } else {
            this.drawText('師匠', 6, y);
        }
    } else {
        this.removeChild(sprite);
        this.removeChild(spritePanaka);
        this.drawText($gameVariables.value(85), 6, y);
    }
*/
    
    this.drawExpInfoIzunabi(190, 0);

};



// アクター顔 + ゲージ + 経験値欄
Window_Status.prototype.drawBlock2 = function(y) {
//    this.drawActorFace(this._actor, 12, y);
//    this.drawBasicInfo(204, y);
//    this.drawExpInfoIzunabi(456, y);
    this.contents.fontSize = 26;
    this.drawActorFace(this._actor, 12, y);
    this.drawBasicInfo(190, y + 10);
};

Window_Status.prototype.drawExpInfoIzunabi = function(x, y) {
    var lineHeight = this.lineHeight();
    var expTotal = TextManager.expTotal.format(TextManager.exp);
    var expNext = TextManager.expNext.format(TextManager.level);
    var value1 = this._actor.currentExp();
    var value2 = this._actor.nextRequiredExp();
    this.contents.fontSize = 26;
    if (this._actor.isMaxLevel()) {
        value1 = '-------';
        value2 = '-------';
    }
    this.changeTextColor(this.systemColor());
//    this.drawText(expTotal, x, y + lineHeight * 0, 270);
//    this.drawText(expNext, x, y + lineHeight * 2, 270);
    this.drawText(expTotal, x, y + lineHeight * 0, 220);
    this.drawText(expNext, x + 270, y + lineHeight * 0, 220);
    this.resetTextColor();
//    this.drawText(value1, x, y + lineHeight * 1, 270, 'right');
//    this.drawText(value2, x, y + lineHeight * 3, 270, 'right');
    this.drawText(value1, x, y + lineHeight * 0, 220, 'right');
    this.drawText(value2, x + 270, y + lineHeight * 0, 220, 'right');

};


// パラメータ、装備描画欄
Window_Status.prototype.drawBlock3 = function(y) {
    this.contents.fontSize = 26;
    var xPos = 12;
    var yPos = 0;
    this.drawParametersIzunabi(xPos, y);
    
    this.contents.fontSize = 24;
    this.drawEquipments(xPos, y + 200);
};

Window_Status.prototype.drawParametersIzunabi = function(x, y) {
    textFontSize = 26;
    this.contents.fontSize = textFontSize;
    var lineHeight = textFontSize + 4;
    var xPos = x;
    var yPos = y;
    var paramArray = [2,3,4,5,6,7]; // param 斬～神秘
    var paramNameArray = [];
    var paramWidth = 96;
    
    var ds = this._actor.currentClass().meta;
    
    for (var i = 0; i < paramArray.length; i++) {
        var paramId = paramArray[i];
        var y2 = y + lineHeight * i;
        this.changeTextColor(this.systemColor());
        this.drawText(TextManager.param(paramId), xPos, y2, paramWidth);
        this.resetTextColor();
        this.drawText(this._actor.param(paramId), xPos + paramWidth, y2, 72, 'right');
        
        if (ds.iznbClassId == 1) {
            this.changeTextColor(this.systemColor());
            var paramBase = $gameActors.actor(1).paramBase(paramId);
            var paramTalk = $gameVariables.value(71 + paramId);
            var paramEquip = this._actor.param(paramId) - paramBase - paramTalk;
            var paramTextBuild = '(';
            paramTextBuild += ( '   ' + paramBase ).slice( -3);
            paramTextBuild += ' + ';
            paramTextBuild += ( '   ' + paramTalk ).slice( -3);
            paramTextBuild += ' + ';
            paramTextBuild += ( '   ' + paramEquip ).slice( -3);
            paramTextBuild += ')';
            this.drawText(paramTextBuild, xPos + 190, y2);
            
        }
    }

};


Window_Status.prototype.drawYourHistory = function(x, y) {
    this.contents.fontSize = 26;
    var xPos = x + 260;
    var yPos = y + 156;
    var w1 = (26 * 8);
    var lineHeight = this.lineHeight();
    this.changeTextColor(this.systemColor());
    this.drawText('訓練回数　　　：', xPos, yPos + lineHeight * 0);
    this.drawText('訓練獲得経験値：', xPos, yPos + lineHeight * 1);
    this.drawText('結晶精製回数　：', xPos, yPos + lineHeight * 2);
    this.drawText('結晶精製量　　：', xPos, yPos + lineHeight * 3);
    this.drawText('総ターン数　　：', xPos, yPos + lineHeight * 4);
    if ($gameSwitches.value(144)) {
        this.drawText('つよニュー回数：', xPos, yPos + lineHeight * 5);
    }
    
    this.resetTextColor();
    this.drawText($gameVariables.value(103) + '回', xPos + w1, yPos + lineHeight * 0);
    this.drawText($gameVariables.value(104), xPos + w1, yPos + lineHeight * 1);
    this.drawText($gameVariables.value(106) + '回', xPos + w1, yPos + lineHeight * 2);
    this.drawText($gameVariables.value(107), xPos + w1, yPos + lineHeight * 3);
    var dispTurnNum = $gameVariables.value(34);
    if ($gameSwitches.value(1)) {
        dispTurnNum += $gameVariables.value(3);
    }
    if (dispTurnNum >= 10000) {
        dispTurnNum = 9999;
    }
    this.drawText(dispTurnNum + 'ターン', xPos + w1, yPos + lineHeight * 4);
    
    if ($gameSwitches.value(144)) {
        this.drawText($gameVariables.value(202) + '回', xPos + w1, yPos + lineHeight * 5);
    }
    
    
};

Window_Status.prototype.drawResistParamsIzunabi = function(x, y) {
    textFontSize = 26;
    this.contents.fontSize = textFontSize;
    var lineHeight = textFontSize + 4;
    var xPos = x;
    var yPos = y;
    var paramArray = [17,19,18,2,3,4,5,7,8];
    var paramNameArray = ['耐斬','耐刺','耐打','耐炎','耐氷','耐風','耐閃','耐酸','耐矢'];
    var paramIconArray = [336,337,338,64,65,69,66,2,78];
    var paramNameWidth = 72;
    var paramWidth = 90;
    var iconWidth = 30;
    for (var i = 0; i < paramArray.length; i++) {
        var paramId = paramArray[i];
        var paramName = paramNameArray[i];
        var paramIconNum = paramIconArray[i];
        var y2 = y + lineHeight * i;
        this.drawIcon(paramIconNum, xPos, y2 + 2);
        this.changeTextColor(this.systemColor());
        this.drawText(paramName, xPos + iconWidth, y2, paramNameWidth);
        this.resetTextColor();
        this.drawText(100 - (Math.round(this._actor.elementRate(paramId) * 100) / 1) + '%', xPos + paramNameWidth, y2, paramWidth, 'right');
    }

};


Window_Status.prototype.drawSpLineUpIzunabi = function(x, y) {
    this.contents.fontSize = 26;
    this.changeTextColor(this.systemColor());
    this.drawText('所持戦術', x, y);
    this.resetTextColor();

    var spStr = this._actor.currentClass().meta.spStr;
    this.contents.fontSize = 25;
    this.drawText('' + spStr, x + 130, y);
    this.resetTextColor();

}

Window_Status.prototype.drawStateParamsIzunabi = function(x, y) {
    var lineHeight = this.lineHeight();
    var xPos = x;
    var yPos = y;
    var paramArray = [7,8,9,10,11,6,22,23,24,25,26,27,28,29,42,43,44,45];
    var paramNameArray = ['血','毒','火','電','死','衰','衝','転','凍','怖','暴','暗','倒','縛','攻','防','速','秘'];
    var paramIconArray = [11,2,64,66,26,27,6,22,65,10,5,3,24,9,50,51,54,52];
    
    var textFontSize = 20;
    
    var iconWidth = textFontSize + 4;
    var paramNameWidth = iconWidth + (textFontSize * 1) + 2;
    var paramWidth = (textFontSize * 2) + 7;
    var yPosAdjustText = -6;

    var colWidth = paramNameWidth + paramWidth;

    var pColums = 4;
    var nowRow = 0;
    var nowCol = 0;
    var drawCount = 0;
    
    
    this.contents.fontSize = textFontSize + 4;
    this.changeTextColor(this.systemColor());
    this.drawText('状態異常耐性', xPos, y);
    this.resetTextColor();

    this.contents.fontSize = textFontSize;
    for (var i = 0; i < paramArray.length; i++) {
    
        var paramId = paramArray[i];
        // ステートは100%でないものだけ描画する
        if (this._actor.stateRate(paramId) == 1) {
            continue;
        }
        
        if (drawCount % pColums == 0) {
            nowRow = nowRow + 1;
            nowCol = 0;
        } else {
            nowCol = nowCol + 1;
        }
        drawCount = drawCount + 1
        
        var paramName = paramNameArray[i];
        var paramIconNum = paramIconArray[i];
        var y2 = yPos + lineHeight * nowRow;
        
        this.drawIcon(paramIconNum, xPos + (nowCol * colWidth), y2);
        
        this.changeTextColor(this.systemColor());
        this.drawText(paramName, xPos + (nowCol * colWidth) + iconWidth, y2 + yPosAdjustText, paramNameWidth);
        this.resetTextColor();
        
        this.drawText(100 - (Math.round(this._actor.stateRate(paramId) * 100) / 1) + '%', xPos + (nowCol * colWidth) + paramNameWidth, y2 + yPosAdjustText, paramWidth, 'left');
    }


};

// プロフィール欄
Window_Status.prototype.drawBlock4 = function(y) {
//    this.drawProfile(6, y);
    textFontSize = 24;
    this.contents.fontSize = textFontSize;
    var lineHeight = textFontSize + 6;
    var ds = this._actor.currentClass().meta;
    
    var anotherFlag = 0;
    if (ds.profAnotherFlag) {
        anotherFlag = Number(ds.profAnotherFlag);
    }
    if (anotherFlag > 0 && $gameSwitches.value(anotherFlag)) {
        this.drawText(ds.profStrA, 0, y + (lineHeight * 0));
        this.drawText(ds.profStrB, 0, y + (lineHeight * 1));
        this.drawText(ds.profStrC, 0, y + (lineHeight * 2));
        this.drawText(ds.profStrD, 0, y + (lineHeight * 3));
    } else {
        this.drawText(ds.profStr1, 0, y + (lineHeight * 0));
        this.drawText(ds.profStr2, 0, y + (lineHeight * 1));
        this.drawText(ds.profStr3, 0, y + (lineHeight * 2));
        this.drawText(ds.profStr4, 0, y + (lineHeight * 3));
    }
    
};



Window_Status.prototype.drawParametersIzunabi = function(x, y) {
    textFontSize = 26;
    this.contents.fontSize = textFontSize;
    var lineHeight = textFontSize + 4;
    var xPos = x;
    var yPos = y;
    var paramArray = [2,3,4,5,6,7]; // param 斬～神秘
    var paramNameArray = [];
    var paramWidth = 96;
    
    var ds = this._actor.currentClass().meta;
    
    for (var i = 0; i < paramArray.length; i++) {
        var paramId = paramArray[i];
        var y2 = y + lineHeight * i;
        this.changeTextColor(this.systemColor());
        this.drawText(TextManager.param(paramId), xPos, y2, paramWidth);
        this.resetTextColor();
        this.drawText(this._actor.param(paramId), xPos + paramWidth, y2, 72, 'right');
        
        if (ds.iznbClassId == 1) {
            this.changeTextColor(this.systemColor());
            var paramBase = $gameActors.actor(1).paramBase(paramId);
            var paramTalk = $gameVariables.value(71 + paramId);
            var paramEquip = this._actor.param(paramId) - paramBase - paramTalk;
            var paramTextBuild = '(';
            paramTextBuild += ( '   ' + paramBase ).slice( -3);
            paramTextBuild += ' + ';
            paramTextBuild += ( '   ' + paramTalk ).slice( -3);
            paramTextBuild += ' + ';
            paramTextBuild += ( '   ' + paramEquip ).slice( -3);
            paramTextBuild += ')';
            this.drawText(paramTextBuild, xPos + 190, y2);
            
        }
    }

};




// 左右キーでもページ切替

// プロセスにrightとleftを追加。動作内容はpagedownとpageupに同じ
// 左右とpageup/pagedownを一緒にすると不都合があるので(並び替え画面とか装備画面とか)
// 分けて定義し、左右キーを使えるウィンドウにleftとrightを追加するものとする)
// pagedownでgrepした結果に、leftとrightを足し込むべきか判断してゆく

Window_Selectable.prototype.processHandling = function() {
    if (this.isOpenAndActive()) {
        if (this.isOkEnabled() && this.isOkTriggered()) {
            this.processOk();
        } else if (this.isCancelEnabled() && this.isCancelTriggered()) {
            this.processCancel();
        } else if (this.isHandled('pagedown') && Input.isTriggered('pagedown')) {
            this.processPagedown();
        } else if (this.isHandled('pageup') && Input.isTriggered('pageup')) {
            this.processPageup();
// Izunabi修正 ここから追記 START
        } else if (this.isHandled('right') && Input.isTriggered('right')) {
            this.processPagedown();
        } else if (this.isHandled('left') && Input.isTriggered('left')) {
            this.processPageup();
// Izunabi修正 ここまで追記 END
        }
    }
};

// プロセスの左右アクションを追加
Window_Selectable.prototype.processLeft = function() {
    SoundManager.playCursor();
    this.updateInputData();
    this.deactivate();
    this.callHandler('left');
};
Window_Selectable.prototype.processRight = function() {
    SoundManager.playCursor();
    this.updateInputData();
    this.deactivate();
    this.callHandler('right');
};


// スキルタイプウィンドウに左右ハンドラーを追加
Scene_Skill.prototype.createSkillTypeWindow = function() {
    var wy = this._helpWindow.height;
    this._skillTypeWindow = new Window_SkillType(0, wy);
    this._skillTypeWindow.setHelpWindow(this._helpWindow);
    this._skillTypeWindow.setHandler('skill',    this.commandSkill.bind(this));
    this._skillTypeWindow.setHandler('cancel',   this.popScene.bind(this));
    this._skillTypeWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._skillTypeWindow.setHandler('pageup',   this.previousActor.bind(this));
// Izunabi修正 ここから追記 START
    this._skillTypeWindow.setHandler('right', this.nextActor.bind(this));
    this._skillTypeWindow.setHandler('left',   this.previousActor.bind(this));
// Izunabi修正 ここまで追記 END
    this.addWindow(this._skillTypeWindow);
};



/*
// 装備画面では左右キーによる選択肢操作があるため、予め潰しておく(選択肢を縦配置にするなど)
//
// YEP_EquipCoreの装備ウィンドウを上書き定義
Scene_Equip.prototype.createCommandWindow = function() {
    var wy = this._helpWindow.height;
    this._commandWindow = new Window_EquipCommand(0, wy, 240);
    this._commandWindow.setHelpWindow(this._helpWindow);
    this._commandWindow.setHandler('equip', this.commandEquip.bind(this));
    this._commandWindow.setHandler('cancel', this.popScene.bind(this));
// Izunabi修正 ここから除去 START
// 自動装備と装備解除ボタンは除去する
//    this._commandWindow.setHandler('optimize', this.commandOptimize.bind(this));
//    this._commandWindow.setHandler('clear', this.commandClear.bind(this));
// Izunabi修正 ここまで除去 END
    this._commandWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._commandWindow.setHandler('pageup', this.previousActor.bind(this));
    this._commandWindow.setHandler('right', this.nextActor.bind(this));
    this._commandWindow.setHandler('left', this.previousActor.bind(this));
    this.addWindow(this._commandWindow);
};
*/

/*
// YEP_SkillLearningのスキル一覧ウィンドウを上書き定義
Scene_LearnSkill.prototype.createCommandWindow = function() {
    var wy = this._helpWindow.height;
    this._commandWindow = new Window_SkillLearnCommand(0, wy);
    this._commandWindow.setHelpWindow(this._helpWindow);
    this._commandWindow.setHandler('class',    this.commandClass.bind(this));
    this._commandWindow.setHandler('cancel',   this.popScene.bind(this));
    this._commandWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._commandWindow.setHandler('pageup',   this.previousActor.bind(this));
// Izunabi修正 ここから追記 START
    this._commandWindow.setHandler('right', this.nextActor.bind(this));
    this._commandWindow.setHandler('left',   this.previousActor.bind(this));
// Izunabi修正 ここまで追記 END
    this._commandWindow.setHelpWindow(this._helpWindow);
    this.addWindow(this._commandWindow);
};
*/

// ステータス画面
Scene_Status.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
    this._statusWindow = new Window_Status();
    this._statusWindow.setHandler('cancel',   this.popScene.bind(this));
    this._statusWindow.setHandler('pagedown', this.nextActor.bind(this));
    this._statusWindow.setHandler('pageup',   this.previousActor.bind(this));
// Izunabi修正 ここから追記 START
    this._statusWindow.setHandler('right', this.nextActor.bind(this));
    this._statusWindow.setHandler('left',   this.previousActor.bind(this));
// Izunabi修正 ここまで追記 END
    this._statusWindow.reserveFaceImages();
    this.addWindow(this._statusWindow);
};


// セーブ画面の描画処理変更
Window_SavefileList.prototype.drawContents = function(info, rect, valid) {
    var bottom = rect.y + rect.height;
    if (rect.width >= 420) {
// ゲームタイトル描画部分を変更する START
//        this.drawGameTitle(info, rect.x + 192, rect.y, rect.width - 192);
        // 2人の名前を使用 → $gameVariables.value(181) + $gameVariables.value(182) + '見聞録'
        // 各データに保持するためTMSaveDataLabel.jsに描画処理を移動
// ゲームタイトル描画部分を変更する END
        if (valid) {
            this.drawPartyCharactersIzunabi(info, rect.x + 10, bottom - 66);
        }
    }
    var lineHeight = this.lineHeight();
    var y2 = bottom - lineHeight;
    if (y2 >= lineHeight) {
        this.drawPlaytime(info, rect.x, y2, rect.width);
    }
};

// セーブ画面に表示されるパーティキャラ描画処理を顔に変更する
Window_SavefileList.prototype.drawPartyCharactersIzunabi = function(info, x, y) {
    if (info.faces) {
        var faceHeight = 60;
        var faceWidth = 96;
        var faceWidthMergin = faceWidth + 8;
        for (var i = 0; i < info.faces.length; i++) {
            this.drawFace(info.faces[i][0], info.faces[i][1], x + (i * faceWidthMergin), y, faceWidth, faceHeight);
        }
    }
};


/*
// 非物理でもクリティカル率100%以上の場合、クリティカルにする
Game_Action.prototype.itemCri = function(target) {
//    return this.item().damage.critical ? this.subject().cri * (1 - target.cev) : 0;
    var retCritical = 0;
    if (this.subject().cri > 1) {
        retCritical = this.subject().cri * (1 - target.cev)
    } else {
        retCritical = this.item().damage.critical ? this.subject().cri * (1 - target.cev) : 0
    }
    return retCritical;
};
*/


/*
// メニュー画面の表示領域修正(AltMenuScreen.jsを修正)
// メニュー画面 コマンド列数
    Window_MenuCommand.prototype.maxCols = function() {
        return 4;
    };

// メニュー画面 コマンド行数
    Window_MenuCommand.prototype.numVisibleRows = function() {
//        return 2;
        return 3;
    };

// メニュー画面 キャラクター列数
    Window_MenuStatus.prototype.maxCols = function() {
        return 4;
    };

// メニュー画面 キャラクター行数
    Window_MenuStatus.prototype.numVisibleRows = function() {
//        return 1;
        return 2;
    };
*/

/*
// メニュー画面 キャラステータス描画
    Window_MenuStatus.prototype.drawItemImage = function(index) {
        var actor = $gameParty.members()[index];
        var rect = this.itemRectForText(index);
        var w = Math.min(rect.width, 144);
        var h = Math.min(rect.height, 144);
        var lineHeight = this.lineHeight();
        this.changePaintOpacity(actor.isBattleMember());
//        this.drawActorFace(actor, rect.x, rect.y + lineHeight * 2.5, w, h);
        this.drawActorFace(actor, rect.x + 16, rect.y + lineHeight * 0.5, w, h);
        this.changePaintOpacity(true);
    };
*/

/*
// メニュー画面 キャラステータス描画
    Window_MenuStatus.prototype.drawItemStatus = function(index) {
        var actor = $gameParty.members()[index];
        var rect = this.itemRectForText(index);
        var x = rect.x;
        var y = rect.y;
        var width = rect.width;
        var bottom = y + rect.height;
        var lineHeight = this.lineHeight();
        
        lineHeight = 24 + 4;
        this.contents.fontSize = 24;
        var levelWidth = 48;
        
        this.drawActorName(actor, x, y + lineHeight * 0, width - levelWidth);
//        this.drawActorLevel(actor, x, y + lineHeight * 1, width);
        this.drawActorLevel(actor, x + (width - levelWidth) + 2, y + lineHeight * 0, levelWidth - 2);
//        this.drawActorClass(actor, x, bottom - lineHeight * 4, width);
//        this.drawActorHp(actor, x, bottom - lineHeight * 3, width);
//        this.drawActorMp(actor, x, bottom - lineHeight * 2, width);
//        this.drawActorTp(actor, x, bottom - lineHeight * 1, width);
        this.drawActorHp(actor, x, bottom - lineHeight * 2.3, width);
        this.drawActorMp(actor, x, bottom - lineHeight * 1.3, (width / 2) - 2);
        this.drawActorTp(actor, x + (width / 2) + 2, bottom - lineHeight * 1.3, (width / 2) - 2);
//        this.drawActorIcons(actor, x, bottom - lineHeight * 1, width);
        this.drawActorIcons(actor, x, y + lineHeight * 1, width);
    };
*/

// オプション画面の幅を広げる
Window_Options.prototype.windowWidth = function() {
//    return 400;
    return 720;
};
// オプション画面の変動部分の幅を広げる
Window_Options.prototype.statusWidth = function() {
//    return 120;
    return 400;
};


/*
// YEP_BattleEngineCore.jsの書き換え
// 対象がアクターの場合、ダメージポップアップは出さない
Game_Battler.prototype.startDamagePopup = function() {
    if (!this._enemyId) {
        // 対象が_enemyIdを持っていない場合 = アクターの場合、何もしない
        return;
    }
    var result = this.result();
    if (result.missed || result.evaded) {
      var copyResult = JsonEx.makeDeepCopy(result);
      copyResult.hpAffected = false;
      copyResult.mpDamage = 0;
      this._damagePopup.push(copyResult);
    }
    if (result.hpAffected) {
      var copyResult = JsonEx.makeDeepCopy(result);
      copyResult.mpDamage = 0;
      this._damagePopup.push(copyResult);
    }
    if (result.mpDamage !== 0) {
      var copyResult = JsonEx.makeDeepCopy(result);
      copyResult.hpAffected = false;
      this._damagePopup.push(copyResult);
    }
};
*/

/*
// バトルログ 表示終わりにウェイトをかける
Window_BattleLog.prototype.displayActionResults = function(subject, target) {
    if (target.result().used) {
        this.push('pushBaseLine');
        this.displayCritical(target);
        this.push('popupDamage', target);
        this.push('popupDamage', subject);
        this.displayDamage(target);
        this.displayAffectedStatus(target);
        this.displayFailure(target);
        this.push('waitForNewLine');
        this.push('popBaseLine');
        this.push('addTextWaitOnly', 12);
    }
};
*/

/*
Window_BattleLog.prototype.addTextWaitOnly = function(waitTimes) {
    this.waitForParam(waitTimes);
};

Window_BattleLog.prototype.waitForParam = function(waitTimes) {
    this._waitCount = waitTimes;
};

// Window_BattleLog.prototype.displayHpDamage.push('addText', Window_BattleLog.prototype.displayHpDamage.makeHpDamageText(target));

Window_BattleLog.prototype.messageSpeed = function() {
    return 2;
};
*/


// ショップで武器防具購入時のアクター装備と能力変化の描画を修正
Window_ShopStatus.prototype.refresh = function() {
    this.contents.clear();
    if (this._item) {
        var x = this.textPadding();
        this.drawPossession(x, 0);
        if (this.isEquipItem()) {
            this.drawEquipInfo(x, this.lineHeight() * 1);
        }
    }
};

Window_ShopStatus.prototype.drawEquipInfo = function(x, y) {
    var members = this.statusMembers();
    for (var i = 0; i < members.length; i++) {
        this.drawActorEquipInfo(x, y + this.lineHeight() * (i * 5.2), members[i]);
    }
};

Window_ShopStatus.prototype.statusMembers = function() {
    var start = this._pageIndex * this.pageSize();
    var end = start + this.pageSize();
    return $gameParty.members().slice(start, end);
};

Window_ShopStatus.prototype.pageSize = function() {
    return 4;
};

Window_ShopStatus.prototype.maxPages = function() {
    return Math.floor(($gameParty.size() + this.pageSize() - 1) / this.pageSize());
};

Window_ShopStatus.prototype.drawActorEquipInfo = function(x, y, actor) {
    var enabled = actor.canEquip(this._item);
    this.changePaintOpacity(enabled);
    this.resetTextColor();
    this.drawText(actor.name(), x, y, 168);
    
    var actorId = actor.actorId();
    var equips = $gameActors.actor(actorId).equips();
    for (var i = 1; i < equips.length; i++) {
        if (equips[i] == null) {
        } else {
            var item_name = equips[i].name;
            var item_icon = equips[i].iconIndex;
            this.drawIcon(item_icon, x + 16, y + this.lineHeight() * i);
            this.drawText(item_name, x + 16 + 36, y + this.lineHeight() * i);
        }
    }
    this.changePaintOpacity(true);
};

Window_ShopStatus.prototype.drawActorParamChange = function(x, y, actor, item1) {
    var width = this.contents.width - this.textPadding() - x;
    var paramId = this.paramId();
    var change = this._item.params[paramId] - (item1 ? item1.params[paramId] : 0);
    this.changeTextColor(this.paramchangeTextColor(change));
    this.drawText((change > 0 ? '+' : '') + change, x, y, width, 'right');
};

Window_ShopStatus.prototype.paramId = function() {
    return DataManager.isWeapon(this._item) ? 2 : 3;
};

Window_ShopStatus.prototype.currentEquippedItem = function(actor, etypeId) {
    var list = [];
    var equips = actor.equips();
    var slots = actor.equipSlots();
    for (var i = 0; i < slots.length; i++) {
        if (slots[i] === etypeId) {
            list.push(equips[i]);
        }
    }
    var paramId = this.paramId();
    var worstParam = Number.MAX_VALUE;
    var worstItem = null;
    for (var j = 0; j < list.length; j++) {
        if (list[j] && list[j].params[paramId] < worstParam) {
            worstParam = list[j].params[paramId];
            worstItem = list[j];
        }
    }
    return worstItem;
};

Window_ItemCategory.prototype.makeCommandList = function() {
//    this.addCommand(TextManager.item,    'item');
//    this.addCommand(TextManager.weapon,  'weapon');
    this.addCommand(TextManager.armor,   'armor');
//    this.addCommand(TextManager.keyItem, 'keyItem');
};


/*
// ショップで武器防具購入時のアクター装備と能力変化の描画を修正
Window_ShopStatus.prototype.refresh = function() {
    this.contents.clear();
    if (this._item) {
        var x = this.textPadding();
        this.drawPossession(x, 0);
        if (this.isEquipItem()) {
//            this.drawEquipInfoIznb(x, this.lineHeight() * 2);
            this.drawEquipInfoIznb(x, this.lineHeight() * 1);
        }
    }
};

Window_ShopStatus.prototype.drawEquipInfoIznb = function(x, y) {
    var members = this.statusMembersIznb();
    for (var i = 0; i < members.length; i++) {
//        this.drawActorEquipInfoIznb(x, y + this.lineHeight() * (i * 2.4), members[i]);
        this.drawActorEquipInfoIznb(x, y + this.lineHeight() * (i * 1.2), members[i]);
    }
};

Window_ShopStatus.prototype.statusMembersIznb = function() {
    var start = this._pageIndex * this.pageSizeIznb();
    var end = start + this.pageSizeIznb();
    return $gameParty.members().slice(start, end);
};

Window_ShopStatus.prototype.pageSizeIznb = function() {
    return 8;
};
*/
/*
Window_ShopStatus.prototype.maxPages = function() {
    return Math.floor(($gameParty.size() + this.pageSizeIznb() - 1) / this.pageSizeIznb());
};
*/
/*
Window_ShopStatus.prototype.drawActorEquipInfoIznb = function(x, y, actor) {
    var enabled = actor.canEquip(this._item);
    this.changePaintOpacity(enabled);
    this.resetTextColor();
    this.contents.fontSize = 24;
    var actorNameWidth = 24 * 5;
    this.drawText(actor.name(), x, y, actorNameWidth);
    var item1 = this.currentEquippedItem(actor, this._item.etypeId);
    if (enabled) {
//        this.drawActorParamChange(x, y, actor, item1);
    }
//    this.drawItemNameIznb(item1, x, y + this.lineHeight());
    this.drawItemNameIznb(item1, x + actorNameWidth, y);
    this.changePaintOpacity(true);
    this.contents.fontSize = 28;
};

Window_Base.prototype.drawItemNameIznb = function(item, x, y, width) {
    width = width || (312 - 24 * 5);
    if (item) {
        var iconBoxWidth = Window_Base._iconWidth + 0;
        this.resetTextColor();
        this.contents.fontSize = 22;
        this.drawIcon(item.iconIndex, x + 2, y + 2);
        this.drawText(item.name, x + iconBoxWidth, y - 2, width - iconBoxWidth);
    }
};
*/


// Izunabi用_フォントサイズをリセットしない、制御文字受付drawText
Window_Base.prototype.drawTextExIzunabi = function(text, x, y) {
    if (text) {
        var textState = { index: 0, x: x, y: y, left: x };
        textState.text = this.convertEscapeCharacters(text);
        textState.height = this.calcTextHeight(textState, false);
        while (textState.index < textState.text.length) {
            this.processCharacter(textState);
        }
        return textState.x - x;
    } else {
        return 0;
    }
};


// Bitmapデータ取得時に、nullエラーが出るので暫定対応
/**
 * Performs a block transfer.
 *
 * @method blt
 * @param {Bitmap} source The bitmap to draw
 * @param {Number} sx The x coordinate in the source
 * @param {Number} sy The y coordinate in the source
 * @param {Number} sw The width of the source image
 * @param {Number} sh The height of the source image
 * @param {Number} dx The x coordinate in the destination
 * @param {Number} dy The y coordinate in the destination
 * @param {Number} [dw=sw] The width to draw the image in the destination
 * @param {Number} [dh=sh] The height to draw the image in the destination
 */
Bitmap.prototype.blt = function(source, sx, sy, sw, sh, dx, dy, dw, dh) {
    dw = dw || sw;
    dh = dh || sh;
    if (sx >= 0 && sy >= 0 && sw > 0 && sh > 0 && dw > 0 && dh > 0 &&
            sx + sw <= source.width && sy + sh <= source.height) {
// Izunabi nullの場合、いったん処理を抜けてしまう add start
        if (!this._context || !this._context.globalCompositeOperation) {
            return;
        }
// Izunabi nullの場合、いったん処理を抜けてしまう add end
        this._context.globalCompositeOperation = 'source-over';
        this._context.drawImage(source._canvas, sx, sy, sw, sh, dx, dy, dw, dh);
        this._setDirty();
    }
};



/*
const _Game_BattlerBase_canUse = Game_BattlerBase.prototype.canUse;
Game_BattlerBase.prototype.canUse = function(item) {
    if (_Game_BattlerBase_canUse.call(this, item)) {
        var useFlg = true;
        var switchNum = 0;
        if (item.meta.disableSwitch) {
            switchNum = Number(item.meta.disableSwitch));
            if ($gameSwitches.value(switchNum)) {
                // disableFlg = trueの場合
                useFlg = false;
            }
        }
        return useFlg;
    } else {
        return false;
    }
};
*/



// 戦闘中のスリップダメージ処理
// プラグイン競合(？)でポップアップ非表示かつ死亡時演出なしだったので修正
/*
Game_Battler.prototype.regenerateHp = function() {
    var value = Math.floor(this.mhp * this.hrg);
    value = Math.max(value, -this.maxSlipDamage());
    if (value !== 0) {
// ダメージポップアップ、死亡判定、死亡演出を入れる
//       this.gainHp(value);

        this._damagePopup = true;
        this.startDamagePopup();
        this.performResultEffects();
        this.gainHp(value);

        if (this.isDead()) {
            this.performCollapse();
        }
    }
};
*/


/*
// エネミーの設定時、メモ欄による追加設定を反映する
Game_Enemy.prototype.traitObjects = function() {
//    return Game_Battler.prototype.traitObjects.call(this).concat(this.enemy());
    var metaTextArray = ['ボス','ザコ'];
    var metaEnemyIdArray = [8,7];
    var concatEnemyData = Game_Battler.prototype.traitObjects.call(this).concat(this.enemy());
    for (var i = 0; i < metaTextArray.length; i++) {
        var evalStr = 'this.enemy().meta.' + metaTextArray[i];
        var checkMeta = eval('this.enemy().meta.' + metaTextArray[i]);
        if (!(typeof checkMeta === 'undefined')) {
            concatEnemyData.concat($dataEnemies[metaEnemyIdArray[i]]);
        }
    }
    return concatEnemyData;
};
*/

/*
enemyの保有しているkey  Object.keys(オブジェクト名) の結果

id
actions
battlerHue
battlerName
dropItems
exp
traits
gold
name
note
params
meta
attackAnimationId
reflectAnimationId
spriteCannotMove
gauge1
gauge2
gauge3
gaugeIcon1
gaugeIcon2
gaugeIcon3
hideHpGauge
showHpGauge
hpGaugeWidth
hpGaugeHeight
hpGaugeBackColor
hpGaugeColor1
hpGaugeColor2
jp
maxBuff
maxDebuff
showStateTurns
*/


/*
Game_Battlerの持っているkey Object.keys(this) の中身

// 味方バトラーのkeys
_hp
_mp
_tp
_hidden
_paramPlus
_states
_stateTurns
_stateSteps
_buffs
_buffTurns
_stateCounter
_actions
_speed
_result
_actionState
_lastTargetIndex
_animations
_damagePopup
_effectType
_motionType
_weaponImageId
_motionRefresh
_selected
_actorId
_name
_nickname
_classId
_level
_characterName
_characterIndex
_faceName
_faceIndex
_battlerName
_exp
_skills
_equips
_actionInputIndex
_lastMenuSkill
_lastBattleSkill
_lastCommandSymbol
_profile
_anchorX
_anchorY

// エネミーバトラーのkeys
_hp
_mp
_tp
_hidden
_paramPlus
_states
_stateTurns
_buffs
_buffTurns
_stateCounter
_actions
_speed
_result
_actionState
_lastTargetIndex
_animations
_damagePopup
_effectType
_motionType
_weaponImageId
_motionRefresh
_selected
_enemyId
_letter
_plural
_screenX
_screenY
*/



