//=============================================================================
// IZNB_SelfCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2022 Izunabi
// 使う人いるん？
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2024/03/01 初版
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/izunabiIS
//=============================================================================

/*:
 * 
 * @plugindesc Izunabi Self Custom
 * @author Izunabi
 * 
 */
/*:ja
 * SRPGギア用にいろいろ
 * 
 * @plugindesc Izunabi用
 * @author Izunabi
 * @help なんとなく分かる思う
 *
 * 利用規約：
 *  勝手に使って下さい
 
 */


//====================================================================
// ●Window_SrpgStatus
//====================================================================
    //----------------------------------------------------------------
    // SRPG戦闘で使用するステータスウィンドウ
    //----------------------------------------------------------------
    window.Window_SrpgStatus = function() {
        this.initialize.apply(this, arguments);
    }

    Window_SrpgStatus.prototype = Object.create(Window_Base.prototype);
    Window_SrpgStatus.prototype.constructor = Window_SrpgStatus;

    // 初期化
    Window_SrpgStatus.prototype.initialize = function(x, y) {
        var width = this.windowWidth();
        var height = this.windowHeight();
        this._type = null;
        this._battler = null;
        Window_Base.prototype.initialize.call(this, x, y, width, height);
        this.refresh();
    };

    // ウィンドウの幅
    Window_SrpgStatus.prototype.windowWidth = function() {
        return 408;
    };

    // ウィンドウの高さ
    Window_SrpgStatus.prototype.windowHeight = function() {
        return this.fittingHeight(10);
    };

    // ユニットのセット
    Window_SrpgStatus.prototype.setBattler = function(data, flip) {
        this._type = data[0];
        this._battler = data[1];
        this._flip = flip;
        this.refresh();
    };

    // ユニットのクリア
    Window_SrpgStatus.prototype.clearBattler = function() {
        this._type = null;
        this._battler = null;
        this.refresh();
    };

    // リフレッシュ
    Window_SrpgStatus.prototype.refresh = function() {
        this.contents.clear();
        if (!this._battler) {
          return;
        }
        if (this._type === 'actor') {
            this.drawContentsActor();
        } else if (this._type === 'enemy') {
            this.drawContentsEnemy();
        }
    };

    // アクターのステータスの描画
    Window_SrpgStatus.prototype.drawContentsActor = function() {
        var lineHeight = this.lineHeight();
        this.drawActorName(this._battler, 6, lineHeight * 0);
//        this.drawActorClass(this._battler, 192, lineHeight * 0);
        if (this._flip) {
            this.drawActorFace(this._battler, 6, lineHeight * 0);
            this.drawBasicInfoActor(176, lineHeight * 1);
        } else {
            this.drawActorFace(this._battler, 220, lineHeight * 0);
            this.drawBasicInfoActor(6, lineHeight * 1);
        }
//        this.drawActorSrpgEqiup(this._battler, 6, lineHeight * 5);
        this.drawParameters(6, lineHeight * 4);
        this.drawSrpgParameters(6, lineHeight * 7);
    };

    // エネミーのステータスの描画
    Window_SrpgStatus.prototype.drawContentsEnemy = function() {
        var lineHeight = this.lineHeight();
        this.drawActorName(this._battler, 6, lineHeight * 0);
//        this.drawEnemyClass(this._battler, 192, lineHeight * 0);
        if (this._flip) {
            this.drawEnemyFace(this._battler, 6, lineHeight * 0);
            this.drawBasicInfoEnemy(176, lineHeight * 1);
        } else {
            this.drawEnemyFace(this._battler, 220, lineHeight * 0);
            this.drawBasicInfoEnemy(6, lineHeight * 1);
        }
//        this.drawEnemySrpgEqiup(this._battler, 6, lineHeight * 5);
        this.drawParameters(6, lineHeight * 4);
        this.drawSrpgParameters(6, lineHeight * 7);
    };

    // アクターのLv, EXP, ステート、HP, MP, TPの描画
    Window_SrpgStatus.prototype.drawBasicInfoActor = function(x, y) {
        var lineHeight = this.lineHeight();
        //this.drawSrpgExpRate(this._battler, x, y + lineHeight * 0);
        this.drawActorLevel(this._battler, x, y + lineHeight * -1);
        this.drawActorIcons(this._battler, x, y + lineHeight * 0);
        this.drawActorHp(this._battler, x, y + lineHeight * 1);
        if ($dataSystem.optDisplayTp) {
            this.drawActorMp(this._battler, x, y + lineHeight * 2, 90);
            this.drawActorTp(this._battler, x + 96, y + lineHeight * 2, 90);
        } else {
            this.drawActorMp(this._battler, x, y + lineHeight * 2);
        }
    };

    // エネミーのLv, ステート、HP, MP, TPの描画
    Window_SrpgStatus.prototype.drawBasicInfoEnemy = function(x, y) {
        var lineHeight = this.lineHeight();
        this.drawEnemyLevel(this._battler, x, y + lineHeight * -1);
        this.drawActorIcons(this._battler, x, y + lineHeight * 0);
        this.drawActorHp(this._battler, x, y + lineHeight * 1);
        if ($dataSystem.optDisplayTp) {
            this.drawActorMp(this._battler, x, y + lineHeight * 2, 90);
            this.drawActorTp(this._battler, x + 96, y + lineHeight * 2, 90);
        } else {
            this.drawActorMp(this._battler, x, y + lineHeight * 2);
        }
    };

    // 攻撃力などパラメータの描画
    Window_SrpgStatus.prototype.drawParameters = function(x, y) {
        var lineHeight = this.lineHeight();
        for (var i = 0; i < 6; i++) {
            var paramId = i + 2;
            var x2 = x + 188 * (i % 2);
            var y2 = y + lineHeight * Math.floor(i / 2);
            this.changeTextColor(this.systemColor());
            this.drawText(TextManager.param(paramId), x2, y2, 120);
            this.resetTextColor();
            this.drawText(this._battler.param(paramId), x2 + 120, y2, 48, 'right');
        }
    };

    // 移動力と武器射程の描画
    Window_SrpgStatus.prototype.drawSrpgParameters = function(x, y) {
        this.changeTextColor(this.systemColor());
        this.drawText(_textSrpgMove, x, y, 120);
        this.resetTextColor();
        this.drawText(this._battler.srpgMove(), x + 120, y, 48, 'right');
        this.changeTextColor(this.systemColor());
        this.drawText(_textSrpgRange, x + 188, y, 120);
        this.resetTextColor();
        var text = '';
        if (this._battler.srpgWeaponMinRange() > 0) {
            text += this._battler.srpgWeaponMinRange() + '-';
        }
        text += this._battler.srpgWeaponRange();
        this.drawText(text, x + 188 + 72, y, 96, 'right');
    };

