//=============================================================================
// IZNB_SelfCustom.js
// ----------------------------------------------------------------------------
// Copyright (c) 2022 Izunabi
// 使う人いるん？
// ----------------------------------------------------------------------------
// Version
// 1.0.0 2023/08/20 初版。SteamAPIを使用するためのコアスクリプト変換
// ----------------------------------------------------------------------------
// [Twitter]: https://twitter.com/izunabiIS
//=============================================================================


/* rpg_core.js */

Utils.isNwjs = function() {
    return typeof require === 'function' && typeof process === 'object';
};

Utils.isElectronjs = function() {
    return window && window.process && window.process.versions && window.process.versions['electron'];
};


Utils.isOptionValid = function (name) {
    if (location.search.slice(1).split('&').contains(name)) { return 1; };
    if (this.isElectronjs()) {
        if (this.isNwjs() && process.argv.length > 0 && process.argv[0].split('&').contains(name)) { return 1; };
    } else {
        if (typeof nw !== "undefined" && nw.App.argv.length > 0 && nw.App.argv[0].split('&').contains(name)) { return 1; };
    }
    return 0;
};


Input._wrapNwjsAlert = function () {
    if (Utils.isElectronjs()) {
        var _alert = window.alert;
        window.alert = function () {
            _alert.apply(this, arguments);
            require('electron').ipcRenderer.send('focusMainWindow');
            Input.clear();
        };
    } else {
        if (Utils.isNwjs()) {
            var _alert = window.alert;
            window.alert = function () {
                var gui = require('nw.gui');
                var win = gui.Window.get();
                _alert.apply(this, arguments);
                win.focus();
                Input.clear();
            };
        }
    }
};



/* rpg_managers.js */

StorageManager.localFileDirectoryPath = function () {
    var path = require('path');
    if (Utils.isElectronjs()) {
        var base = path.dirname(__filename);
        return Utils.isOptionValid('test') ? path.join(base, 'save/') : path.join(base, '../../save/');
    } else {
        var base = path.dirname(process.mainModule.filename);
        return path.join(base, 'save/');
    }
};

SceneManager.initialize = function () {
    this.initGraphics();
    this.checkFileAccess();
    this.initAudio();
    this.initInput();
    if (!Utils.isElectronjs()) {
        this.initNwjs();
    }
    this.checkPluginErrors();
    this.setupErrorHandlers();
};

SceneManager.onKeyDown = function (event) {
    if (!event.ctrlKey && !event.altKey) {
        switch (event.keyCode) {
            case 116:   // F5
                if (Utils.isElectronjs()) {
                    location.reload();
                } else {
                    if (Utils.isNwjs()) {
                        location.reload();
                    }
                }
                break;
            case 119:   // F8
                if (Utils.isElectronjs()) {
                    if (Utils.isOptionValid('test')) {
                        require('electron').ipcRenderer.send('openDevTools');
                    }
                } else {
                    if (Utils.isNwjs() && Utils.isOptionValid('test')) {
                        require('nw.gui').Window.get().showDevTools();
                    }
                }
                break;
        }
    }
};

