/*:
 * @plugindesc KMS_Minimap: icon visibility hard-resync + range check fix
 * @author you
 * @help Place this plugin BELOW KMS_Minimap.js and any FPLE patches.
 */
(function() {
  'use strict';

  // --- 1) 範囲判定のバグ修正（dx,dy を使って返す） ---
  if (window.Sprite_Minimap && Sprite_Minimap.prototype.isInDrawRange) {
    const _isInDrawRange = Sprite_Minimap.prototype.isInDrawRange;
    Sprite_Minimap.prototype.isInDrawRange = function(x, y) {
      var begin = this._drawRange.begin, end = this._drawRange.end;
      var dx = x, dy = y;
      if ($gameMap.isLoopHorizontal()) dx = (dx + $gameMap.width())  % $gameMap.width();
      if ($gameMap.isLoopVertical())   dy = (dy + $gameMap.height()) % $gameMap.height();
      return dx >= begin.x && dx <= end.x && dy >= begin.y && dy <= end.y;
    };
  }

  // --- 2) 毎フレームの強制リシンク（親の updateMinimap の後に実施） ---
  if (window.Spriteset_Map) {
    const _updateMinimap = Spriteset_Map.prototype.updateMinimap;
    Spriteset_Map.prototype.updateMinimap = function() {
      _updateMinimap.call(this);

      const mm = this._minimap;
      if (!mm || !mm._objectSprites || !mm.visible || mm.opacity <= 0) return;

      const begin = mm._drawRange.begin;
      const diff  = mm._scrollDiff;

      for (let i = 0; i < mm._objectSprites.length; i++) {
        const spr = mm._objectSprites[i];
        if (!spr || !spr.getObject) continue;

        const obj = spr.getObject();
        if (!obj) continue;

        // 現在の描画範囲内か？
        const inRange = mm.isInDrawRange(obj.x - 1, obj.y - 1);

        // アイコンそのものが存在するか（イベント/乗り物の属性で -1 のとき非表示）
        const hasIcon = (typeof spr.getCurrentIconIndex === 'function')
          ? (spr.getCurrentIconIndex() >= 0)
          : true;

        // ← ここで毎フレーム強制同期：外に出たらfalse、入ったらtrueへ必ず復帰
        spr.visible = inRange && hasIcon;

        // 可視時は位置も更新（復帰フレームで正しい座標に）
        if (spr.visible && spr.updatePosition) {
          spr.updatePosition(begin, diff);
        }
      }
    };
  }
})();
