

  1
  2
  3
  4
  5
  6
  7
  8
  9
 10
 11
 12
 13
 14
 15
 16
 17
 18
 19
 20
 21
 22
 23
 24
 25
 26
 27
 28
 29
 30
 31
 32
 33
 34
 35
 36
 37
 38
 39
 40
 41
 42
 43
 44
 45
 46
 47
 48
 49
 50
 51
 52
 53
 54
 55
 56
 57
 58
 59
 60
 61
 62
 63
 64
 65
 66
 67
 68
 69
 70
 71
 72
 73
 74
 75
 76
 77
 78
 79
 80
 81
 82
 83
 84
 85
 86
 87
 88
 89
 90
 91
 92
 93
 94
 95
 96
 97
 98
 99
100
101
102
103
104
105
106
107
108
109
110
111
112
113
114
115
116
117
118
119
120
121
122
123
124
125
126
127
128
129
130
131
132
133
134
135
136
137
138
139
140
141
142
143
144
145
146
147
148
149
150
151
152
153
154
155
156
157
158
159
160
161
162
163
164
165
166
167
168
169
170
171
172
173
174
175
176
177
178
179
180
181
182
183
184
185
186
187
188
189
190
191
192
193
194
195
196
197
198
199
200
201
202
203
204
205
206
207
208
209
210
211
212
213
214
215
216
217
218
219
220
221
222
223
224
225
226
227
228
229
230
231
232
233
234
235
236
237
238
239
240
241
242
243
244
245
246
247
248
249
250
251
252
253
254
255
256
257
258
259
260
261
262
263
264
265
266
267
268
269
270
271
272
273
274
275
276
277
278
279
280
281
282
283
284
285
286
287
288
289
290
291
292
293
294
295
296
297
298
299
300
301
302
303
304
305
306
307
308
309
310
311
312
313
314
315
316
317
318
319
320
321
322
323
324
325
326
327
328
329
330
331
332
333
334
335
336
337
338
339
340
341
342
343
344
345
346
347
348
349
350
351
352
353
354
355
356
357
358
359
360
361
362
363
364
365
366
367
368
369
370
371
372
373
374
375
376
377
378
379
380
381
382
383
384
385
386
387
388
389
390
391
392
393
394
395
396
397
398
399
400
401
402
403
404
405
406
407
408
409
410
411
412
413
414
415
416
417
418
419
420
421
422
423
424
425
426
427
428
429
430
431
432
433
434
435
436
437
438
439
440
441
442
443
444
445
446
447
448
449
450
451

	

//=============================================================================
// RouletteBlinkPicture.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 回転式ルーレット機能（演出の補助等）
 * @author まっつＵＰ
 * 
 * @param spinsename
 * @text 回転中SE
 * @desc ルーレット回転中SE
 * @type file
 * @require 1
 * @dir audio/se/
 * @default
 * 
 * @param spinseparam
 * @text 回転中SEparam
 * @desc 上記seのvolume, pitch, pan（位相）
 * @default [80, 100, 0]
 * 
 * @param stopsename
 * @text 停止時SE
 * @desc ルーレット停止時SE
 * @type file
 * @require 1
 * @dir audio/se/
 * @default
 * 
 * @param stopseparam
 * @text 停止時SEparam
 * @desc 上記seのvolume, pitch, pan（位相）
 * @default [80, 100, 0]
 * 
 * @param Reelpattern
 * @text リールパターン
 * @desc 各リールパターンの設定
 * @type struct<ReelpatternData>[]
 * @default []
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * ---導入---
 * 
 * RouletteBlinkPicture.jsは
 * プラグイン管理上の任意の行に適用してください。
 * 
 * プラグイン内容の変更（改変）による動作の保証はできませんので
 * 変更する場合はあらかじめ必要なバックアップをとるなど十分に注意してください。
 * 
 * 
 * ---プラグインコマンド---
 * 
 * RBPcommand mode patternindex startpictid setresult
 * 
 * modeはルーレットのモード
 * (1:確定モード、2:未確定（即停止）モード、3:未確定（滑り）モード)
 * patternindexはリール画像パターン(何番目のリールか)
 * startpictidは起点ピクチャID、
 * 点滅用ピクチャを表示する最初のピクチャID
 * (IDを連続して８つピクチャ表示)
 * setresultは確定モード時に予め決める結果値
 * (1-8,原則確定モードでのみ利用)
 * を代わりに入れます。
 * 
 * 実行後のルーレット終了後に
 * 変数(原則ID1)に結果値を表す数値1-8が代入されます。
 * 
 * 例：RBPcommand 1 1 2 1
 * 
 * 
 * ---その他---
 * 
 * イベントコマンド「スクリプト」で、
 * $gameScreen.clearPictures();
 * を実行することで、デフォルトの機能のピクチャの表示で表示したID1~100の
 * ピクチャを非表示にし、その設定を削除することができます。
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

/*~struct~ReelpatternData:
 * @param lightpicture
 * @text 点滅用ピクチャ
 * @desc 点滅用ピクチャ(img/picture)
 * 真上から時計回りに８つ分。
 * @type file[]
 * @require 1
 * @dir img/pictures/
 * @default
 * 
 */

var Imported = Imported || {};
Imported.RouletteBlinkPicture = true;

(function() {

const stringifyReplacer = function(key, value) {
    if(value === 'null') return value;
    try{
        return JSON.parse(value);
    }catch(e){
        return value;
    }
};

//プラグインパラメータの設定に使う関数等はこれより上に。
const parameters = PluginManager.parameters('RouletteBlinkPicture');

const RBPspinsename = String(parameters['spinsename'] || '');
const RBPspinseparam = JSON.parse(parameters['spinseparam']);
const RBPstopsename = String(parameters['stopsename'] || '');
const RBPstopseparam = JSON.parse(parameters['stopseparam']);

//構造体（Array型）。各要素はobject型（その内容の型は各パラメータの通り）。
const RBPReelpattern = JSON.parse(JSON.stringify(parameters['Reelpattern'], stringifyReplacer));
//console.log(RBPReelpattern);

const lightpictureslength = 8;
//(欠番)コメントポイント：ウェイト値決定-3


//DataManager

DataManager.RBPReelpattern = function() {
    return RBPReelpattern || [];
};

DataManager.RBPReelpatternlightpictures = function(index) {
    index = Math.max(Number(index || 0) , 0);
    const obj = this.RBPReelpattern()[index] || {};
    return obj.lightpicture || [];
};

//実際に使用する新しい配列
DataManager.RBPretarraylightpictures = function(index) {
    const array = this.RBPReelpatternlightpictures(index);
    array.length = lightpictureslength;
    return array.map(function(str) {
        return String(str || '');
    });
};


//AudioManager

AudioManager.RBPplayse = function(name, array) {
    if(!(name && array)) return;
    var se = {};
    se.name = name;
    se.volume = Number(array[0] || 80);
    se.pitch = Number(array[1] || 100);
    se.pan = Number(array[2] || 0);
    this.playSe(se);
};


//SceneManager

//ルーレットのキー押下による判定、いずれかの入力（isTriggered系は新たに入力している必要があります。）
SceneManager.RBPinputok = function() {
    return Input.isTriggered('ok') || TouchInput.isTriggered();
};


//Game_Interpreter

//必要な設定の初期化
Game_Interpreter.prototype.RBPinterclear = function() {
    this._RBPRoulettemode = 0;
    this._RBPpatternindex = 0;
    this._RBPstartpictid = 0;
    this._RBPsetresult = 0;
    this._RBPsetrand = 0;
    this._RBPcurrentindex = 0;
    this._RBPresultvalue = 0;
    this._RBPsbX = 0;
    this._RBPsbY = 0;
    this.RBPsetRoulettephase('none');
    this.RBPsetlightpictures();
};

Game_Interpreter.prototype.RBPsetlightpictures = function(array) {
    this._lightpictures = array || [];
};

Game_Interpreter.prototype.RBPlightpictures = function() {
    return this._lightpictures;
};

//指定のIDから連続したIDに、８つピクチャを表示。
Game_Interpreter.prototype.RBPshowlightpictures = function(startid) {
    const startindexopacity = 0;
    const opacity = 0;
    var currentopacity = 0;
    this.RBPlightpictures().forEach(function(pictname, index) {
        if(index === 0){
            currentopacity = startindexopacity;
        }else{
            currentopacity = opacity;
        }
        $gameScreen.showPicture(startid + index, pictname, 0, 0, 0, 100, 100, currentopacity, 0);
    });
};

Game_Interpreter.prototype.RBPsetRoulettephase = function(phase) {
    this._RBPRoulettephase = phase;
    this._RBPcounttime = 0;
};


const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    this.RBPorigpluginCommand(command, args);
};

//このプラグインの新規プラグインコマンド、指定引数の数値化など
Game_Interpreter.prototype.RBPorigpluginCommand = function(command, args) {
    if(command !== 'RBPcommand') return;
    const mode = Number(args[0] || 1);
    const patternindex = Number(args[1] || 1);
    const startpictid = Number(args[2] || 10);
    const setresult = Number(args[3] || 1);
    this.RBPstartRoulette(mode, patternindex, startpictid, setresult);
};

//this.RBPinterclear()は、一応セーブへの負荷の軽減を考慮し、clearではなくこちらに入れる。
Game_Interpreter.prototype.RBPstartRoulette = function(mode, patternindex, startpictid, setresult) {
    this.RBPinterclear();
    this._RBPRoulettemode = mode;
    this._RBPpatternindex = patternindex - 1;
    this._RBPstartpictid = startpictid;
    this._RBPsetresult = setresult - 1;
    //console.log(this._RBPRoulettemode, this._RBPpatternindex, this._RBPstartpictid, this._RBPsetresult);

    this.RBPsetlightpictures(DataManager.RBPretarraylightpictures(this._RBPpatternindex));
    this.setWaitMode('RBPRoulette');
    this.RBPsetRoulettephase('firstBlink');
};


const _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
Game_Interpreter.prototype.updateWaitMode = function() {
    return this.RBPupdateRoulette() || _Game_Interpreter_updateWaitMode.call(this);
};

//指定のwaitModeの間ルーレットの更新を行い続ける。
Game_Interpreter.prototype.RBPupdateRoulette = function() {
    if(this._waitMode !== 'RBPRoulette') return false;
    const phase = this._RBPRoulettephase;
    if(phase === 'none') return true;
    switch(phase) {

        case 'firstBlink':
            this.RBPupdateRoulettefirstBlink();
            break;

        case 'Spinning':
            this.RBPupdateRouletteSpinning();
            break;

        case 'Spinningwithslide':
            this.RBPupdateRouletteSpinningwithslide();
            break;

        case 'endBlink':
            this.RBPupdateRouletteendBlink();
            break;

    }
    return true;
};

Game_Interpreter.prototype.RBPupdateRoulettefirstBlink = function() {
    this._RBPcounttime++;

    //コメントポイント：ウェイト値決定-1…元10
    const blinkwait1 = 5;
    //コメントポイント：ウェイト値決定-2…元60
    const movewait1 = 20;
    //対象のピクチャが最初の点滅で表示状態になる回数…元4
    const firstblinktimes = 2;

    const startid = this._RBPstartpictid;
    const fbshowtiming = this._RBPcounttime % blinkwait1;
    const fbhidetiming = this._RBPcounttime % (blinkwait1 * 2);
    const fblasttiming = blinkwait1 * (firstblinktimes * 2 - 1);

    if(this._RBPcounttime === 1){
        this.RBPshowlightpictures(startid);
    }

    if(this._RBPcounttime <= fblasttiming){
        const pict = $gameScreen.picture(startid);
        if(fbhidetiming === 0){
            pict._opacity = 0;
        }else if(fbshowtiming === 0){
            pict._opacity = 255;
        }
    }
   
    if(this._RBPcounttime >= (fblasttiming + movewait1)){
        //コメントポイント：乱数値決定-1…元16-24
//        this._RBPsetrand = Math.randomInt(lightpictureslength + 1) + lightpictureslength * 2;
        this._RBPsetrand = Math.randomInt(lightpictureslength + 1) + lightpictureslength ;
        this._RBPcurrentindex = 0;
        this.RBPsetRoulettephase('Spinning');
    }
    
};

//回転開始後、キー入力まで
Game_Interpreter.prototype.RBPupdateRouletteSpinning = function() {
    this._RBPcounttime++;
    
    //コメントポイント：ウェイト値決定-4
    this.RBPupdateblinknext(4);

    if(this._RBPsetrand <= 0 && SceneManager.RBPinputok()){
        this.RBPsetRoulettephase('Spinningwithslide');
    }
    
};

Game_Interpreter.prototype.RBPupdateblinknext = function(wait) {
    const blinkwait1 = wait;
    const blinknexttiming = this._RBPcounttime % blinkwait1;

    if(blinknexttiming === 0){
        AudioManager.RBPplayse(RBPspinsename, RBPspinseparam);
        $gameScreen.picture(this._RBPstartpictid + this._RBPcurrentindex)._opacity = 0;
        this._RBPcurrentindex = (this._RBPcurrentindex + 1) % lightpictureslength;
        this._RBPsetrand--;
        $gameScreen.picture(this._RBPstartpictid + this._RBPcurrentindex)._opacity = 255;
    }
};

//滑り回転
Game_Interpreter.prototype.RBPupdateRouletteSpinningwithslide = function() {
    this._RBPcounttime++;

    //コメントポイント：ウェイト値決定-5…元10
    const blinkwait1 = 5;
    //コメントポイント：ウェイト値決定-6…元30
    const blinkwait2 = 10;

    if(this._RBPcounttime === 1){
        switch(this._RBPRoulettemode) {

            //コメントポイント：滑り値Ｘ決定（確定モード）
            //コメントポイント：滑り値Y決定（確定モード）
            case 1:
                var minvalue = 4;
                var dif = this._RBPsetresult - this._RBPcurrentindex;
                if(this._RBPsetresult < this._RBPcurrentindex){
                    dif += lightpictureslength;
                }
                if(minvalue > dif){
                    dif += lightpictureslength;
                }
                this._RBPsbY = 3;
                this._RBPsbX = dif - this._RBPsbY;
                break;
    
            //コメントポイント：滑り値Ｘ決定（即停止モード）
            //コメントポイント：滑り値Y決定（即停止モード）
            case 2:
                this._RBPsbX = 1;
                this._RBPsbY = 1;
                break;
    
            //コメントポイント：滑り値Ｘ決定（未確定モード）
            //コメントポイント：滑り値Y決定（未確定モード）
            case 3:
                var minvalue = 3;
                this._RBPsbX = Math.randomInt(lightpictureslength + 1 - minvalue) + minvalue;
                this._RBPsbY = 3;
                break;
    
        }
    }
    
    const xblinktime = blinkwait1 * this._RBPsbX;
    const allblinktime = xblinktime + blinkwait2 * this._RBPsbY;
    
    if(this._RBPcounttime <= xblinktime){
        this.RBPupdateblinknext(blinkwait1);
    }else{
        this.RBPupdateblinknext(blinkwait2);
    }

    if(this._RBPcounttime >= allblinktime){
        this.RBPsetRoulettephase('endBlink');
    }
    
};

Game_Interpreter.prototype.RBPupdateRouletteendBlink = function() {
    this._RBPcounttime++;
    
    //コメントポイント：ウェイト値決定-7
    const blinkwait1 = 5;
    //対象のピクチャが点滅で表示状態になる回数…元10
    const firstblinktimes = 5;

    const fbhidetiming = this._RBPcounttime % blinkwait1;
    const fbshowtiming = this._RBPcounttime % (blinkwait1 * 2);
    const fblasttiming = blinkwait1 * (firstblinktimes * 2);

    if(this._RBPcounttime === 1){
        AudioManager.RBPplayse(RBPstopsename, RBPstopseparam);
    }

    if(this._RBPcounttime <= fblasttiming){
        const pict = $gameScreen.picture(this._RBPstartpictid + this._RBPcurrentindex);
        if(fbshowtiming === 0){
            pict._opacity = 255;
        }else if(fbhidetiming === 0){
            pict._opacity = 0;
        }
    }

    if(this._RBPcounttime >= fblasttiming){
        this.RBPendRoulette();
    }
    
};


Game_Interpreter.prototype.RBPendRoulette = function() {
    this._RBPresultvalue = this._RBPcurrentindex + 1;
    this.RBPoutputsetValue();
    this.setWaitMode('');
    this.RBPinterclear();
};

//コメントポイント：結果リターン
Game_Interpreter.prototype.RBPoutputsetValue = function() {
    const id = 1;
    const value = Number(this._RBPresultvalue || 0);
    $gameVariables.setValue(id, value);
};


})();

