/*:
 * @target MZ
 * @plugindesc プレイヤーの現在地が指定リージョンまたはイベントでブロックされているか判定してスイッチと座標変数を操作
 * @author 
 *
 * @param SwitchId
 * @text 判定結果スイッチID
 * @type switch
 * @desc 配置可能ならON (true)、ブロックされていたらOFF (false) にするスイッチ
 * @default 1
 *
 * @param VariableX
 * @text 現在地X座標変数ID
 * @type variable
 * @desc プレイヤーX座標を格納する変数
 * @default 1
 *
 * @param VariableY
 * @text 現在地Y座標変数ID
 * @type variable
 * @desc プレイヤーY座標を格納する変数
 * @default 2
 *
 * @param ForbiddenRegionId
 * @text 禁止リージョンID
 * @type number
 * @min 0
 * @desc このリージョン番号のタイルはブロック対象とする
 * @default 5
 *
 * @command CheckCurrentPlace
 * @text 現在地配置判定
 * @desc プレイヤー現在地がブロックされているか判定してスイッチ切替＆座標を変数に格納
 */

(() => {
    const pluginName = "CheckCurrentPlace"; // ← 修正済み
    const parameters = PluginManager.parameters(pluginName);
    const defaultSwitchId = Number(parameters['SwitchId'] || 1);
    const variableXId = Number(parameters['VariableX'] || 1);
    const variableYId = Number(parameters['VariableY'] || 2);
    const forbiddenRegionId = Number(parameters['ForbiddenRegionId'] || 5);

    PluginManager.registerCommand(pluginName, "CheckCurrentPlace", args => {
        console.log("[CheckCurrentPlace] コマンド呼び出し成功！");

        const switchId = defaultSwitchId;

        // プレイヤー座標
        const x = $gamePlayer.x;
        const y = $gamePlayer.y;

        // 変数に格納
        $gameVariables.setValue(variableXId, x);
        $gameVariables.setValue(variableYId, y);

        // 他イベント判定（e.posで安全チェック）
        const otherEventOnTile = $gameMap.events().some(e =>
            e && !e._erased && typeof e.pos === "function" && e.pos(x, y)
        );

        // リージョン取得
        const regionId = $gameMap.regionId(x, y);

        // ブロック判定
        const isBlocked = (regionId === forbiddenRegionId) || otherEventOnTile;

        // スイッチ操作
        $gameSwitches.setValue(switchId, !isBlocked);

        // デバッグ出力
        console.log("[CheckCurrentPlace] mapId:", $gameMap.mapId(),
                    "x:", x, "y:", y,
                    "regionId:", regionId,
                    "forbiddenRegionId:", forbiddenRegionId,
                    "otherEventOnTile:", otherEventOnTile,
                    "isBlocked:", isBlocked,
                    "switchId:", switchId,
                    "switchValueNow:", $gameSwitches.value(switchId));
    });
})();
