/*:
 * @target MZ
 * @plugindesc <Enemy>付きイベントの数を数えて変数に入れるプラグイン
 * @author 
 *
 * @param DefaultVariable
 * @type variable
 * @text デフォルト変数
 * @desc カウント結果を入れる変数（コマンドで指定しない場合）
 * @default 1
 *
 * @command CountEnemies
 * @text <Enemy>カウント
 * @desc 現在マップ上の<Enemy>イベント数を変数に格納
 *
 * @arg variableId
 * @type variable
 * @text 格納する変数
 * @desc 結果を入れる変数
 * @default 0
 */

(() => {
    const pluginName = "CountEnemyEvents";
    const parameters = PluginManager.parameters(pluginName);
    const defaultVariable = Number(parameters["DefaultVariable"] || 1);

    PluginManager.registerCommand(pluginName, "CountEnemies", args => {
        const variableId = Number(args.variableId) || defaultVariable;
        const count = $gameMap.events().filter(ev => {
            return ev.event().meta.Enemy; // <Enemy>タグのイベントだけ
        }).length;
        $gameVariables.setValue(variableId, count);
    });
})();
