// CustomJump.js Ver.1.0.0
// MIT License (C) 2024 あわやまたな
// http://opensource.org/licenses/mit-license.php


/*:
* @target MZ
* @orderBefore ReplaceTargetCharacter
* @plugindesc Controls jump height and duration.
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/507266111.html
* @help Ver.1.0.0
* The player and the follower are linked.
*
* [Scripts（Movement Route）]
* this.setJumpData(height); //Set height
* this.setJumpData(height, duration); //Set height and duration
* this.setJumpData(null, duration); //Set duration
* this.clearJumpData(); //Initialization
*
* @command setJumpData
* @text Set Jump Data
* @desc 
* @arg characterId
* @text Character ID
* @desc Specify the character's ID.
* This Event:0  Player:-1
* @default -1
* @arg height
* @text Height
* @desc Initialize with no input.
* @arg duration
* @text Duration
* @desc Initialize with no input.
*/


/*:ja
* @target MZ
* @orderBefore ReplaceTargetCharacter
* @plugindesc ジャンプの高さ、時間を操作します。
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/article/507266111.html
* @help プレイヤーと隊列メンバーは連動します。
*
* [スクリプト（移動ルート）]
* this.setJumpData(高さ); //高さを設定
* this.setJumpData(高さ, 時間); //高さと時間を設定
* this.setJumpData(null, 時間); //時間を設定
* this.clearJumpData(); //初期化
*
* [更新履歴]
* 2024/12/23：Ver.1.0.0　公開。
*
* @command setJumpData
* @text ジャンプの設定
* @desc 
* @arg characterId
* @text キャラクターID
* @desc キャラクターのIDを指定します。
* このイベント:0  プレイヤー:-1
* @default -1
* @arg height
* @text 高さ
* @desc 未入力で初期化。
* @arg duration
* @text 時間
* @desc 未入力で初期化
*/


'use strict';
{
	const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];


	//-----------------------------------------------------------------------------
	// PluginManager


	const _PluginManager = window.PluginManagerEx || window.PluginManager;
	const scriptName = window.PluginManagerEx ? document.currentScript : pluginName;
	_PluginManager.registerCommand(scriptName, "setJumpData", function(args) {
		const character = this.character(+args.characterId);
		if (character) {
			const h = args.height !== "" ? null : +args.height;
			const d = args.duration !== "" ? null : +args.duration;
			character.setJumpData(h, d);
		}
	});


	//-----------------------------------------------------------------------------
	// Game_CharacterBase


	const _Game_CharacterBase_initMembers = Game_CharacterBase.prototype.initMembers;
	Game_CharacterBase.prototype.initMembers = function() {
		_Game_CharacterBase_initMembers.call(this);
		this.clearJumpData();
		this._jumpCustomRate = 1;
	};


	Game_CharacterBase.prototype.clearJumpData = function() {
		this._jumpCustomHeight = null;
		this._jumpCustomDuration = null;
	};


	Game_CharacterBase.prototype.setJumpData = function(h, d) {
		this._jumpCustomHeight = h ?? null;
		this._jumpCustomDuration = d ?? null;
	};


	Game_CharacterBase.prototype.jumpCustomHeight = function() {
		return this._jumpCustomHeight;
	};


	Game_CharacterBase.prototype.jumpCustomDuration = function() {
		return this._jumpCustomDuration;
	};


	Game_CharacterBase.prototype.jumpMaxHeight = function() {
		const c = this._jumpCount;
		this._jumpCount = this._jumpPeak;
		const h = this.jumpHeight();
		this._jumpCount = c;
		return h;
	};


	const _Game_CharacterBase_jumpHeight = Game_CharacterBase.prototype.jumpHeight;
	Game_CharacterBase.prototype.jumpHeight = function() {
		const rate = this._jumpCustomRate ?? 1;
		return _Game_CharacterBase_jumpHeight.call(this) * rate;
	};


	const _Game_CharacterBase_jump = Game_CharacterBase.prototype.jump;
	Game_CharacterBase.prototype.jump = function(xPlus, yPlus) {
		this._jumpCustomRate = 1;
		_Game_CharacterBase_jump.apply(this, arguments);
		if (this._jumpCustomDuration != null) {
			this._jumpCount = this._jumpCustomDuration;
			this._jumpPeak = this._jumpCount / 2;
		}
		if (this._jumpCustomHeight != null) {
			this._jumpCustomRate = this._jumpCustomHeight / this.jumpMaxHeight();
		}
	};


	//-----------------------------------------------------------------------------
	// Game_Followers


	const _Game_Followers_jumpAll = Game_Followers.prototype.jumpAll;
	Game_Followers.prototype.jumpAll = function() {
		if ($gamePlayer.isJumping()) {
			for (const follower of this._data) {
				follower.setJumpData($gamePlayer.jumpCustomHeight(), $gamePlayer.jumpCustomDuration());
			}
		}
		_Game_Followers_jumpAll.call(this);
	};


	//-----------------------------------------------------------------------------
	// Game_Follower


	const _Game_Follower_update = Game_Follower.prototype.update
	Game_Follower.prototype.update = function() {
		this.setJumpData($gamePlayer.jumpCustomHeight(), $gamePlayer.jumpCustomDuration());
		_Game_Follower_update.call(this);
	};


}
