/*:
 * @target MZ
 * @plugindesc 指定タグのあるイベントのセルフスイッチをマップ切替ごとにリセット
 * @author 
 *
 * @help
 * イベントのメモ欄に
 * <ResetSelfSwitch>
 * と書いておくと、そのイベントのセルフスイッチA～Dが
 * マップに入るたびにリセットされます。
 */

(() => {
    const _Game_Map_setupEvents = Game_Map.prototype.setupEvents;
    Game_Map.prototype.setupEvents = function() {
        _Game_Map_setupEvents.call(this);

        this.events().forEach(event => {
            if (event.event().meta.ResetSelfSwitch) {
                ["A","B","C","D"].forEach(sw => {
                    $gameSelfSwitches.setValue([this.mapId(), event.eventId(), sw], false);
                });
            }
        });
    };
})();
