/*:
 * @target MZ
 * @plugindesc 指定範囲内のイベントのセルフスイッチを変更し、プレイヤーが範囲内ならコモンイベント呼び出し（完全同時更新）
 * @author 
 *
 * @command SetNearbySelfSwitch
 * @text 周囲イベントセルフスイッチ変更＋プレイヤー判定
 * @desc 呼び出し元イベントの周囲のイベントにセルフスイッチを設定、プレイヤーが範囲内ならコモンイベントを呼び出す
 *
 * @arg Radius
 * @type number
 * @min 0
 * @text 判定半径
 * @desc 呼び出し元イベントの周囲何マスを判定するか
 * @default 1
 *
 * @arg NoteTag
 * @type string
 * @text 対象メモタグ
 * @desc このメモタグを持つイベントのみ対象。空なら全イベント。
 * @default 
 *
 * @arg SelfSwitch
 * @type select
 * @option A
 * @option B
 * @option C
 * @option D
 * @text セルフスイッチ
 * @desc 変更するセルフスイッチ
 * @default A
 *
 * @arg Value
 * @type boolean
 * @text 設定する値
 * @desc ON(true) / OFF(false)
 * @default true
 *
 * @arg CommonEventId
 * @type common_event
 * @text プレイヤー範囲内時のコモンイベント
 * @desc プレイヤーが範囲内にいたら1回だけ呼び出されるコモンイベント。0なら呼ばない。
 * @default 0
 */

(() => {
    const pluginName = "SetNearbySelfSwitch";

    PluginManager.registerCommand(pluginName, "SetNearbySelfSwitch", function (args) {
        const radius = Number(args.Radius || 1);
        const noteTag = String(args.NoteTag || '');
        const ssId = String(args.SelfSwitch || 'A');
        const value = args.Value === 'true';
        const commonEventId = Number(args.CommonEventId || 0);

        const eventId = this.eventId();
        const sourceEvent = $gameMap.event(eventId);
        if (!sourceEvent) return;

        const sx = sourceEvent.x;
        const sy = sourceEvent.y;

        // === 変更予約用の配列 ===
        const switchChanges = [];

        // === イベント処理 ===
        for (const ev of $gameMap.events()) {
            if (!ev || ev._erased) continue;
            if (ev.eventId() === eventId) continue; // 自分は除外

            // タグチェック
            if (noteTag && !ev.event().note.includes(`<${noteTag}>`)) continue;

            // 範囲判定
            if (Math.abs(ev.x - sx) <= radius && Math.abs(ev.y - sy) <= radius) {
                switchChanges.push([$gameMap.mapId(), ev.eventId(), ssId]);
            }
        }

        // === 一括反映 ===
        if (switchChanges.length > 0) {
            switchChanges.forEach(key => $gameSelfSwitches.setValue(key, value));
            $gameMap.requestRefresh(); // 最後にまとめてページ更新
        }

        // === プレイヤー判定 ===
        const px = $gamePlayer.x;
        const py = $gamePlayer.y;
        if (Math.abs(px - sx) <= radius && Math.abs(py - sy) <= radius) {
            if (commonEventId > 0) {
                $gameTemp.reserveCommonEvent(commonEventId);
            }
        }
    });
})();
