/*:
 * @plugindesc 一時的に敵イベント（<Enemy:名前>）のプライオリティを下げ、プレイヤーがすり抜け可能にします。
 * @author 
 *
 * @help
 * ■使い方
 * スクリプトコマンドで以下を呼び出してください：
 * 
 * TemporaryPriority.activate(range, duration);
 *
 * ・range: プレイヤーからの距離（タイル数）
 * ・duration: フレーム数（すり抜け状態の継続時間）
 * 
 * 例：TemporaryPriority.activate(4, 60);
 * 
 * ■備考
 * ・対象は <Enemy:何か> のメモがあるイベントのみ
 * ・イベントの優先度が「通常キャラの下」に変化し、プレイヤーがすり抜け可能になります
 * ・duration 経過後に「通常キャラと同じ」に戻ります
 */

(() => {
    window.TemporaryPriority = {
        activate: function(range, duration) {
            const px = $gamePlayer.x;
            const py = $gamePlayer.y;

            $gameMap.events().forEach(ev => {
                if (ev.event() && ev.event().meta.Enemy && !ev._erased) {
                    const dx = Math.abs(ev.x - px);
                    const dy = Math.abs(ev.y - py);
                    if (dx <= range && dy <= range) {
                        console.log(`🟡 敵ID:${ev.eventId()} プライオリティ変更`);
                        ev._originalPriorityType = ev._priorityType;
                        ev._priorityType = 0; // 通常キャラの下
                        ev._priorityTimer = duration;
                    }
                }
            });
        }
    };

    // 優先度タイマー管理
    const _Game_Event_update = Game_Event.prototype.update;
    Game_Event.prototype.update = function() {
        _Game_Event_update.call(this);

        if (this._priorityTimer > 0) {
            this._priorityTimer--;
            if (this._priorityTimer === 0) {
                console.log(`🔵 敵ID:${this.eventId()} プライオリティ元に戻す`);
                if (this._originalPriorityType !== undefined) {
                    this._priorityType = this._originalPriorityType;
                    this._originalPriorityType = undefined;
                }
            }
        }
    };

    // 優先度取得のオーバーライド（反映させるため）
    Game_Event.prototype.priorityType = function() {
        return this._priorityType !== undefined
            ? this._priorityType
            : this.event().priorityType;
    };
})();
