/*:
 * @plugindesc タイトル画面で選択された項目を回転させ、右にずらすプラグイン
 * @param Rotation Speed
 * @text 回転の速さ
 * @desc 選択された項目が回転する速さを設定します
 * @default 10
 *
 * @param Rotation Radius
 * @text 回転の半径
 * @desc 選択された項目が回転する範囲（ピクセル）を設定します
 * @default 2
 */

(function() {
    // パラメーター設定
    const parameters = PluginManager.parameters('TitleFloatEffect');
    const rotationSpeed = Number(parameters['Rotation Speed'] || 10);   // 回転の速さ
    const rotationRadius = Number(parameters['Rotation Radius'] || 2);  // 回転の半径（ピクセル）

    // 元の描画メソッドを拡張
    const _Window_TitleCommand_drawItem = Window_TitleCommand.prototype.drawItem;
    Window_TitleCommand.prototype.drawItem = function(index) {
        const rect = this.itemLineRect(index);
        const text = this.commandName(index);

        // 右にずらす
        let offsetX = this.index() === index ? 20 : 0; // 横のずれ
        let offsetY = 0; // 縦のずれ

        // 選択中の項目がくるくる回る
        if (this.index() === index) {
            const time = performance.now() / 1000; // 時間を基に
            // 回転方向の計算（円を描く）
            offsetX += Math.cos(time * rotationSpeed) * rotationRadius;
            offsetY += Math.sin(time * rotationSpeed) * rotationRadius;
        }

        // 左揃えで描画し、選択中は右にずらしてくるくる回る
        this.resetTextColor();
        this.drawText(text, rect.x + offsetX, rect.y + offsetY, rect.width, 'left');
    };

    // 振動中は右にずらす動作を維持
    const _Window_TitleCommand_update = Window_TitleCommand.prototype.update;
    Window_TitleCommand.prototype.update = function() {
        _Window_TitleCommand_update.call(this);

        // 選択中の項目がくるくる回るようにする
        if (this.index() !== -1) {
            this.refresh(); // 選択中の項目を更新
        }
    };
})();
