//=============================================================================
// SaveScreenEX.js
// ----------------------------------------------------------------------------
//■参考
//NUUN様プラグイン NUUN_SaveScreen_3.js
// ----------------------------------------------------------------------------
/*:
 * @target MZ
 * @plugindesc セーブ画面に情報を付与
 * @author 宗盛ゼツキヨ
 *
 * @help
 * セーブ画面に指定した変数の値を表示できます。
 * X座標、Y座標を指定して表示位置を変更してください。
 *
 * @param SSEX_nameVariable
 * @desc 変数番号。
 * @text メッセージ表示変数番号
 * @type variable
 * @default 0
 *
 * @param SSEX_X_Coordinate
 * @text X座標（相対）
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 300
 * @max 9999
 * @min -9999
 * 
 * @param SSEX_Y_Coordinate
 * @text Y座標（相対）
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @max 9999
 * @min -9999
 *
 * @param SSEX_FontSize
 * @desc フォントサイズ（メインフォントからの差）
 * @text フォントサイズ
 * @type number
 * @default -6
 * @min -99
 */
 
(() => {
   'use strict';
    const pluginName = "SaveScreenEX";
    const SSEX_param = PluginManager.parameters(pluginName);
    const SSEX_setNum = Number(SSEX_param['SSEX_nameVariable']);
    const SSEX_Xpos = Number(SSEX_param['SSEX_X_Coordinate']);
    const SSEX_Ypos = Number(SSEX_param['SSEX_Y_Coordinate']);
    //const SSEX_FSize = Number(SSEX_param['SSEX_FontSize']);

    const _makeSavefileInfo = DataManager.makeSavefileInfo;
    DataManager.makeSavefileInfo = function () {
        const info = _makeSavefileInfo.call(this);
        var message = ""
        if (SSEX_setNum > 0) {
            message = $gameVariables.value(SSEX_setNum);
        }
        info.AnyName = message;
        return info;
    };

    Window_SavefileList.prototype.drawContents = function(info, rect) {
        const bottom = rect.y + rect.height;
        if (rect.width >= 420) {
            this.drawPartyCharacters(info, rect.x + 220, bottom - 8);
        }
        const lineHeight = this.lineHeight();
        const y2 = bottom - lineHeight - 4;
        if (y2 >= lineHeight) {
            this.drawPlaytime(info, rect.x, y2, rect.width);
        }
        
        //メッセージ表示
        //this.contents.fontSize = $gameSystem.mainFontSize() + SSEX_FSize;
        this.drawText(info.AnyName, rect.x + SSEX_Xpos, rect.y + SSEX_Ypos, rect.width);
    };
})();